/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.weaving.jpa;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.eclipse.persistence.exceptions.StaticWeaveException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.deployment.ArchiveFactoryImpl;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.weaving.AbstractStaticWeaveOutputHandler;
import org.eclipse.persistence.internal.jpa.weaving.StaticWeaveDirectoryOutputHandler;
import org.eclipse.persistence.internal.jpa.weaving.StaticWeaveJAROutputHandler;
import org.eclipse.persistence.internal.localization.ToStringLocalization;
import org.eclipse.persistence.jpa.Archive;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.DefaultSessionLog;
import org.eclipse.persistence.tools.weaving.jpa.StaticWeaveClassTransformer;

public class StaticWeaveProcessor {
    private URL source;
    private URL target;
    private URL persistenceInfo;
    private String persistenceXMLLocation;
    private Writer logWriter;
    private ClassLoader classLoader;
    private int logLevel = 8;
    private static final int NUMBER_OF_BYTES = 1024;

    public StaticWeaveProcessor(String source, String target) throws MalformedURLException {
        if (source != null) {
            this.source = new File(source).toURL();
        }
        if (target != null) {
            this.target = new File(target).toURL();
        }
    }

    public StaticWeaveProcessor(File source, File target) throws MalformedURLException {
        this.source = source.toURL();
        this.target = target.toURL();
    }

    public StaticWeaveProcessor(URL source, URL target) {
        this.source = source;
        this.target = target;
    }

    public void setLog(Writer logWriter) {
        this.logWriter = logWriter;
    }

    public void setLogLevel(int level) {
        this.logLevel = level;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setPersistenceInfo(URL persistenceInfo) {
        this.persistenceInfo = persistenceInfo;
    }

    public void setPersistenceInfo(String persistenceInfoPath) throws MalformedURLException {
        if (persistenceInfoPath != null) {
            this.persistenceInfo = new File(persistenceInfoPath).toURL();
        }
    }

    public String getPersistenceXMLLocation() {
        return this.persistenceXMLLocation;
    }

    public void setPersistenceXMLLocation(String persistenceXMLLocation) {
        this.persistenceXMLLocation = persistenceXMLLocation;
    }

    public void setPersistenceInfo(File persistenceInfoFile) throws MalformedURLException {
        if (persistenceInfoFile != null) {
            this.persistenceInfo = persistenceInfoFile.toURL();
        }
    }

    public void performWeaving() throws URISyntaxException, MalformedURLException, IOException {
        this.preProcess();
        this.process();
    }

    private void preProcess() throws URISyntaxException, MalformedURLException {
        AbstractSessionLog.getLog().setLevel(this.logLevel);
        if (this.logWriter != null) {
            ((DefaultSessionLog)AbstractSessionLog.getLog()).setWriter(this.logWriter);
        }
        if (!new File(Helper.toURI(this.source)).exists()) {
            throw StaticWeaveException.missingSource();
        }
        URI targetURI = Helper.toURI(this.target);
        if (this.isDirectory(this.source) && targetURI.toString().endsWith(".jar")) {
            AbstractSessionLog.getLog().log(6, ToStringLocalization.buildMessage("staticweave_processor_unknown_outcome", new Object[]{null}));
        }
        if (!this.isDirectory(this.source) && this.target.toString().equals(this.source.toString())) {
            throw StaticWeaveException.weaveInplaceForJar(this.source.toString());
        }
        if (!new File(targetURI).exists() && !targetURI.toString().endsWith(".jar")) {
            new File(targetURI).mkdirs();
            this.target = new File(targetURI).toURL();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process() throws IOException, URISyntaxException {
        AbstractStaticWeaveOutputHandler swoh = this.isDirectory(this.target) ? new StaticWeaveDirectoryOutputHandler(this.source, this.target) : new StaticWeaveJAROutputHandler(new JarOutputStream(new FileOutputStream(new File(Helper.toURI(this.target)))));
        this.classLoader = this.classLoader == null ? Thread.currentThread().getContextClassLoader() : this.classLoader;
        this.classLoader = new URLClassLoader(this.getURLs(), this.classLoader);
        StaticWeaveClassTransformer classTransformer = null;
        classTransformer = this.persistenceInfo != null ? new StaticWeaveClassTransformer(this.persistenceInfo, this.persistenceXMLLocation, this.classLoader, this.logWriter, this.logLevel) : new StaticWeaveClassTransformer(this.source, this.persistenceXMLLocation, this.classLoader, this.logWriter, this.logLevel);
        Archive sourceArchive = new ArchiveFactoryImpl().createArchive(this.source);
        try {
            Iterator<String> entries = sourceArchive.getEntries();
            while (entries.hasNext()) {
                String entryName = entries.next();
                InputStream entryInputStream = sourceArchive.getEntry(entryName);
                swoh.addDirEntry(StaticWeaveProcessor.getDirectoryFromEntryName(entryName));
                JarEntry newEntry = new JarEntry(entryName);
                if (!entryName.endsWith(".class")) {
                    swoh.addEntry(entryInputStream, newEntry);
                    continue;
                }
                String className = PersistenceUnitProcessor.buildClassNameFromEntryString(entryName);
                byte[] originalClassBytes = null;
                byte[] transferredClassBytes = null;
                try {
                    Class<?> thisClass = this.classLoader.loadClass(className);
                    if (thisClass == null) {
                        swoh.addEntry(entryInputStream, newEntry);
                        continue;
                    }
                    InputStream is = this.classLoader.getResourceAsStream(entryName);
                    if (is != null) {
                        ByteArrayOutputStream baos = null;
                        try {
                            baos = new ByteArrayOutputStream();
                            byte[] bytes = new byte[1024];
                            int bytesRead = is.read(bytes, 0, 1024);
                            while (bytesRead >= 0) {
                                baos.write(bytes, 0, bytesRead);
                                bytesRead = is.read(bytes, 0, 1024);
                            }
                            originalClassBytes = baos.toByteArray();
                        }
                        finally {
                            baos.close();
                        }
                    } else {
                        swoh.addEntry(entryInputStream, newEntry);
                        continue;
                    }
                    transferredClassBytes = classTransformer.transform(className.replace('.', '/'), thisClass, originalClassBytes);
                    if (transferredClassBytes != null) {
                        swoh.addEntry(newEntry, transferredClassBytes);
                        continue;
                    }
                    swoh.addEntry(entryInputStream, newEntry);
                }
                catch (IllegalClassFormatException e) {
                    AbstractSessionLog.getLog().logThrowable(6, e);
                    swoh.addEntry(entryInputStream, newEntry);
                }
                catch (ClassNotFoundException e) {
                    AbstractSessionLog.getLog().logThrowable(6, e);
                    swoh.addEntry(entryInputStream, newEntry);
                }
                finally {
                    entryInputStream.close();
                }
            }
        }
        finally {
            sourceArchive.close();
            swoh.closeOutputStream();
        }
    }

    public static String getDirectoryFromEntryName(String entryName) {
        String result = "";
        if (entryName == null) {
            return result;
        }
        if (entryName.lastIndexOf("/") >= 0) {
            result = entryName.substring(0, entryName.lastIndexOf("/")) + File.separator;
        }
        return result;
    }

    private boolean isDirectory(URL url) throws URISyntaxException {
        File file = new File(Helper.toURI(url));
        return file.isDirectory();
    }

    private URL[] getURLs() {
        if (this.source != null && this.persistenceInfo != null) {
            return new URL[]{this.persistenceInfo, this.source};
        }
        if (this.source != null) {
            return new URL[]{this.source};
        }
        if (this.persistenceInfo != null) {
            return new URL[]{this.persistenceInfo};
        }
        return new URL[0];
    }
}

