/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AccountExpiredException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.JAASCallbackHandler;
import org.apache.catalina.realm.RealmBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;

public class JAASRealm
extends RealmBase {
    private static final Log log = LogFactory.getLog(JAASRealm.class);
    protected String appName = null;
    protected static final String info = "org.apache.catalina.realm.JAASRealm/1.0";
    protected static final String name = "JAASRealm";
    protected List<String> roleClasses = new ArrayList<String>();
    protected List<String> userClasses = new ArrayList<String>();
    protected boolean useContextClassLoader = true;
    protected String roleClassNames = null;
    protected String userClassNames = null;

    @Deprecated
    public void setAppName(String name) {
        this.appName = name;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setUseContextClassLoader(boolean useContext) {
        this.useContextClassLoader = useContext;
        log.info("Setting useContextClassLoader = " + useContext);
    }

    public boolean isUseContextClassLoader() {
        return this.useContextClassLoader;
    }

    @Override
    public void setContainer(Container container) {
        super.setContainer(container);
        if (this.appName == null) {
            String name = container.getName();
            this.appName = name = this.makeLegalForJAAS(name);
            log.info("Set JAAS app name " + this.appName);
        }
    }

    public String getRoleClassNames() {
        return this.roleClassNames;
    }

    public void setRoleClassNames(String roleClassNames) {
        this.roleClassNames = roleClassNames;
    }

    protected void parseClassNames(String classNamesString, List<String> classNamesList) {
        classNamesList.clear();
        if (classNamesString == null) {
            return;
        }
        ClassLoader loader = this.getClass().getClassLoader();
        if (this.isUseContextClassLoader()) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        String[] classNames = classNamesString.split("[ ]*,[ ]*");
        for (int i = 0; i < classNames.length; ++i) {
            if (classNames[i].length() == 0) continue;
            try {
                Class<?> principalClass = Class.forName(classNames[i], false, loader);
                if (Principal.class.isAssignableFrom(principalClass)) {
                    classNamesList.add(classNames[i]);
                    continue;
                }
                log.error("Class " + classNames[i] + " is not implementing " + "java.security.Principal! Class not added.");
                continue;
            }
            catch (ClassNotFoundException e) {
                log.error("Class " + classNames[i] + " not found! Class not added.");
            }
        }
    }

    public String getUserClassNames() {
        return this.userClassNames;
    }

    public void setUserClassNames(String userClassNames) {
        this.userClassNames = userClassNames;
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public Principal authenticate(String username, String credentials) {
        return this.authenticate(username, new JAASCallbackHandler(this, username, credentials));
    }

    @Override
    public Principal authenticate(String username, String clientDigest, String nonce, String nc, String cnonce, String qop, String realmName, String md5a2) {
        return this.authenticate(username, new JAASCallbackHandler(this, username, clientDigest, nonce, nc, cnonce, qop, realmName, md5a2, "DIGEST"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Principal authenticate(String username, CallbackHandler callbackHandler) {
        try {
            Principal principal;
            LoginContext loginContext = null;
            if (this.appName == null) {
                this.appName = "Tomcat";
            }
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("jaasRealm.beginLogin", username, this.appName));
            }
            ClassLoader ocl = null;
            if (!this.isUseContextClassLoader()) {
                ocl = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            }
            try {
                loginContext = new LoginContext(this.appName, callbackHandler);
            }
            catch (Throwable e) {
                ExceptionUtils.handleThrowable(e);
                log.error(sm.getString("jaasRealm.unexpectedError"), e);
                Principal principal2 = null;
                return principal2;
            }
            finally {
                if (!this.isUseContextClassLoader()) {
                    Thread.currentThread().setContextClassLoader(ocl);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("Login context created " + username);
            }
            Subject subject = null;
            try {
                loginContext.login();
                subject = loginContext.getSubject();
                if (subject == null) {
                    if (!log.isDebugEnabled()) return null;
                    log.debug(sm.getString("jaasRealm.failedLogin", username));
                    return null;
                }
            }
            catch (AccountExpiredException e) {
                if (!log.isDebugEnabled()) return null;
                log.debug(sm.getString("jaasRealm.accountExpired", username));
                return null;
            }
            catch (CredentialExpiredException e) {
                if (!log.isDebugEnabled()) return null;
                log.debug(sm.getString("jaasRealm.credentialExpired", username));
                return null;
            }
            catch (FailedLoginException e) {
                if (!log.isDebugEnabled()) return null;
                log.debug(sm.getString("jaasRealm.failedLogin", username));
                return null;
            }
            catch (LoginException e) {
                log.warn(sm.getString("jaasRealm.loginException", username), e);
                return null;
            }
            catch (Throwable e) {
                ExceptionUtils.handleThrowable(e);
                log.error(sm.getString("jaasRealm.unexpectedError"), e);
                return null;
            }
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("jaasRealm.loginContextCreated", username));
            }
            if ((principal = this.createPrincipal(username, subject, loginContext)) == null) {
                log.debug(sm.getString("jaasRealm.authenticateFailure", username));
                return null;
            }
            if (!log.isDebugEnabled()) return principal;
            log.debug(sm.getString("jaasRealm.authenticateSuccess", username));
            return principal;
        }
        catch (Throwable t) {
            log.error("error ", t);
            return null;
        }
    }

    @Override
    protected String getName() {
        return name;
    }

    @Override
    protected String getPassword(String username) {
        return null;
    }

    @Override
    protected Principal getPrincipal(String username) {
        return this.authenticate(username, new JAASCallbackHandler(this, username, null, null, null, null, null, null, null, "CLIENT_CERT"));
    }

    protected Principal createPrincipal(String username, Subject subject, LoginContext loginContext) {
        ArrayList<String> roles = new ArrayList<String>();
        Principal userPrincipal = null;
        for (Principal principal : subject.getPrincipals()) {
            String principalClass = principal.getClass().getName();
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("jaasRealm.checkPrincipal", principal, principalClass));
            }
            if (userPrincipal == null && this.userClasses.contains(principalClass)) {
                userPrincipal = principal;
                if (log.isDebugEnabled()) {
                    log.debug(sm.getString("jaasRealm.userPrincipalSuccess", principal.getName()));
                }
            }
            if (!this.roleClasses.contains(principalClass)) continue;
            roles.add(principal.getName());
            if (!log.isDebugEnabled()) continue;
            log.debug(sm.getString("jaasRealm.rolePrincipalAdd", principal.getName()));
        }
        if (userPrincipal == null) {
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("jaasRealm.userPrincipalFailure"));
                log.debug(sm.getString("jaasRealm.rolePrincipalFailure"));
            }
        } else if (roles.size() == 0 && log.isDebugEnabled()) {
            log.debug(sm.getString("jaasRealm.rolePrincipalFailure"));
        }
        return new GenericPrincipal(username, null, roles, userPrincipal, loginContext);
    }

    protected String makeLegalForJAAS(String src) {
        String result = src;
        if (result == null) {
            result = "other";
        }
        if (result.startsWith("/")) {
            result = result.substring(1);
        }
        return result;
    }

    @Override
    protected void startInternal() throws LifecycleException {
        this.parseClassNames(this.userClassNames, this.userClasses);
        this.parseClassNames(this.roleClassNames, this.roleClasses);
        super.startInternal();
    }
}

