/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.tomcat7;

import java.lang.reflect.Field;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.ContextConfig;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.util.digester.Digester;
import org.ow2.jonas.security.SecurityService;
import org.ow2.jonas.web.tomcat7.SetSecurityServiceRule;

public class JOnASContextConfig
extends ContextConfig {
    private SecurityService service = null;
    public static final String DEFAULT_CONTEXT_XML = "conf/tomcat7-context.xml";
    public static final String DEFAULT_WEB_XML = "conf/tomcat7-web.xml";

    public String getDefaultWebXml() {
        if (this.defaultWebXml == null) {
            this.defaultWebXml = DEFAULT_WEB_XML;
        }
        return this.defaultWebXml;
    }

    public String getDefaultContextXml() {
        if (this.defaultContextXml == null) {
            this.defaultContextXml = DEFAULT_CONTEXT_XML;
        }
        return this.defaultContextXml;
    }

    protected Digester createContextDigester() {
        Digester digester = super.createContextDigester();
        digester.addRule("Context/Realm", new SetSecurityServiceRule(this.service));
        return digester;
    }

    public void setSecurityService(SecurityService service) {
        this.service = service;
    }

    protected synchronized void init() {
        contextDigester = null;
        super.init();
    }

    protected void webConfig() {
        super.webConfig();
        boolean ignore = this.context.getIgnoreAnnotations();
        if (ignore) {
            InstanceManager instanceManager = ((StandardContext)this.context).getInstanceManager();
            Class<?> clazz = instanceManager.getClass();
            Field f = null;
            try {
                f = clazz.getDeclaredField("ignoreAnnotations");
                f.setAccessible(true);
                f.set(instanceManager, Boolean.TRUE);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Unable to find the field", e);
            }
            catch (NoSuchFieldException e) {
                throw new IllegalStateException("Unable to find the field", e);
            }
            this.context.setIgnoreAnnotations(false);
        }
    }
}

