/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import javax.ws.rs.core.Cookie;
import javax.ws.rs.ext.RuntimeDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieHeaderProvider
implements RuntimeDelegate.HeaderDelegate<Cookie> {
    private static final String VERSION = "$Version";
    private static final String PATH = "$Path";
    private static final String DOMAIN = "$Domain";
    private static final String DOUBLE_QUOTE = "\"";

    public Cookie fromString(String c) {
        String[] tokens;
        if (c == null) {
            throw new IllegalArgumentException("Cookie value can not be null");
        }
        int version = 0;
        String name = null;
        String value = null;
        String path = null;
        String domain = null;
        for (String token : tokens = c.split(";")) {
            String theToken = token.trim();
            if (theToken.startsWith(VERSION)) {
                version = Integer.parseInt(this.stripQuotes(theToken.substring(VERSION.length() + 1)));
                continue;
            }
            if (theToken.startsWith(PATH)) {
                path = this.stripQuotes(theToken.substring(PATH.length() + 1));
                continue;
            }
            if (theToken.startsWith(DOMAIN)) {
                domain = this.stripQuotes(theToken.substring(DOMAIN.length() + 1));
                continue;
            }
            int i = theToken.indexOf(61);
            if (i == -1) continue;
            name = theToken.substring(0, i);
            value = i == theToken.length() + 1 ? "" : this.stripQuotes(theToken.substring(i + 1));
        }
        if (name == null || value == null) {
            throw new IllegalArgumentException("Cookie is malformed : " + c);
        }
        return new Cookie(name, value, path, domain, version);
    }

    private String stripQuotes(String value) {
        return value.replaceAll(DOUBLE_QUOTE, "");
    }

    public String toString(Cookie c) {
        StringBuilder sb = new StringBuilder();
        if (c.getVersion() != 0) {
            sb.append(VERSION).append('=').append(c.getVersion()).append(';');
        }
        sb.append(c.getName()).append('=').append(c.getValue());
        if (c.getPath() != null) {
            sb.append(';').append(PATH).append('=').append(c.getPath());
        }
        if (c.getDomain() != null) {
            sb.append(';').append(DOMAIN).append('=').append(c.getDomain());
        }
        return sb.toString();
    }
}

