/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.pool.impl.enhanced.internal.lock.impl;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.ow2.util.pool.impl.enhanced.internal.lock.api.ISignalClearableCondition;

public class SignalClearableConditionProxy
implements ISignalClearableCondition {
    private Condition condition;

    public SignalClearableConditionProxy(Condition condition) {
        if (condition == null) {
            throw new IllegalArgumentException("condition is null");
        }
        this.condition = condition;
    }

    public static ISignalClearableCondition createProxy(Condition condition) {
        if (condition instanceof ISignalClearableCondition) {
            return (ISignalClearableCondition)condition;
        }
        return new SignalClearableConditionProxy(condition);
    }

    public void clearAllSignal() {
    }

    public void await() throws InterruptedException {
        this.condition.await();
    }

    public boolean await(long time, TimeUnit unit) throws InterruptedException {
        return this.condition.await(time, unit);
    }

    public long awaitNanos(long nanosTimeout) throws InterruptedException {
        return this.condition.awaitNanos(nanosTimeout);
    }

    public void awaitUninterruptibly() {
        this.condition.awaitUninterruptibly();
    }

    public boolean awaitUntil(Date deadline) throws InterruptedException {
        return this.condition.awaitUntil(deadline);
    }

    public void signal() {
        this.condition.signal();
    }

    public void signalAll() {
        this.condition.signalAll();
    }

    public void await(long timeout) throws InterruptedException {
        if (timeout < 0L) {
            throw new IllegalArgumentException();
        }
        if (timeout == 0L) {
            this.condition.await();
        } else {
            this.condition.await(timeout, TimeUnit.MILLISECONDS);
        }
    }

    public void signalAllUnclearable() {
        this.condition.signalAll();
    }
}

