/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.cmi.internal;

import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Set;
import javax.ejb.EJBObject;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceRegistration;
import org.ow2.carol.util.configuration.ConfigurationRepository;
import org.ow2.cmi.component.event.EventComponent;
import org.ow2.cmi.controller.common.ClusterViewManager;
import org.ow2.cmi.controller.factory.ClusterViewManagerFactory;
import org.ow2.cmi.controller.server.AbsServerClusterViewManager;
import org.ow2.cmi.controller.server.IServerConfig;
import org.ow2.cmi.controller.server.ServerClusterViewManager;
import org.ow2.cmi.osgi.ILoadBalancingService;
import org.ow2.jonas.cmi.CmiService;
import org.ow2.jonas.cmi.internal.CmiServicePolicyStrategyManager;
import org.ow2.jonas.cmi.internal.CmiServiceProperty;
import org.ow2.jonas.cmi.internal.LoadBalancingListener;
import org.ow2.jonas.cmi.internal.event.BeanEventListener;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.service.ServiceException;
import org.ow2.util.component.api.Component;
import org.ow2.util.event.api.IEventListener;
import org.ow2.util.event.api.IEventService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmiServiceImpl
extends AbsServiceImpl
implements CmiService,
Pojo {
    private InstanceManager __IM;
    private static Logger cmilogger = Log.getLogger((String)"org.ow2.jonas.cmi");
    private boolean __FjmxService;
    private JmxService jmxService;
    private boolean __Fcontext;
    private final BundleContext context;
    private static ClusterViewManager clusterViewManager;
    private boolean __FclusterViewManagerRegistration;
    private ServiceRegistration clusterViewManagerRegistration;
    private boolean __FeventService;
    private IEventService eventService;
    private boolean __FpolicyStrategyManager;
    private CmiServicePolicyStrategyManager policyStrategyManager;
    private boolean __Flistener;
    private LoadBalancingListener listener;
    private boolean __FbeanEventListener;
    IEventListener beanEventListener;
    private boolean __MdoStart;
    private boolean __MdoStop;
    private boolean __MgetJmxService;
    private boolean __MsetJmxService$org_ow2_jonas_jmx_JmxService;
    private boolean __MsetEventService$org_ow2_util_event_api_IEventService;
    private boolean __MaddClusteredObject$java_lang_String$java_lang_Object$java_lang_Class$java_lang_Class$java_lang_ClassLoader$boolean$boolean;
    private boolean __MremoveClusteredObject$java_lang_String;
    private boolean __MgetBeanEventListener;
    private boolean __MsetBeanEventListener$org_ow2_util_event_api_IEventListener;

    JmxService __getjmxService() {
        if (!this.__FjmxService) {
            return this.jmxService;
        }
        return (JmxService)this.__IM.onGet((Object)this, "jmxService");
    }

    void __setjmxService(JmxService jmxService) {
        if (!this.__FjmxService) {
            this.jmxService = jmxService;
            return;
        }
        this.__IM.onSet((Object)this, "jmxService", (Object)jmxService);
    }

    BundleContext __getcontext() {
        if (!this.__Fcontext) {
            return this.context;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "context");
    }

    void __setcontext(BundleContext bundleContext) {
        if (!this.__Fcontext) {
            this.context = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "context", (Object)bundleContext);
    }

    ServiceRegistration __getclusterViewManagerRegistration() {
        if (!this.__FclusterViewManagerRegistration) {
            return this.clusterViewManagerRegistration;
        }
        return (ServiceRegistration)this.__IM.onGet((Object)this, "clusterViewManagerRegistration");
    }

    void __setclusterViewManagerRegistration(ServiceRegistration serviceRegistration) {
        if (!this.__FclusterViewManagerRegistration) {
            this.clusterViewManagerRegistration = serviceRegistration;
            return;
        }
        this.__IM.onSet((Object)this, "clusterViewManagerRegistration", (Object)serviceRegistration);
    }

    IEventService __geteventService() {
        if (!this.__FeventService) {
            return this.eventService;
        }
        return (IEventService)this.__IM.onGet((Object)this, "eventService");
    }

    void __seteventService(IEventService iEventService) {
        if (!this.__FeventService) {
            this.eventService = iEventService;
            return;
        }
        this.__IM.onSet((Object)this, "eventService", (Object)iEventService);
    }

    CmiServicePolicyStrategyManager __getpolicyStrategyManager() {
        if (!this.__FpolicyStrategyManager) {
            return this.policyStrategyManager;
        }
        return (CmiServicePolicyStrategyManager)this.__IM.onGet((Object)this, "policyStrategyManager");
    }

    void __setpolicyStrategyManager(CmiServicePolicyStrategyManager cmiServicePolicyStrategyManager) {
        if (!this.__FpolicyStrategyManager) {
            this.policyStrategyManager = cmiServicePolicyStrategyManager;
            return;
        }
        this.__IM.onSet((Object)this, "policyStrategyManager", (Object)cmiServicePolicyStrategyManager);
    }

    LoadBalancingListener __getlistener() {
        if (!this.__Flistener) {
            return this.listener;
        }
        return (LoadBalancingListener)this.__IM.onGet((Object)this, "listener");
    }

    void __setlistener(LoadBalancingListener loadBalancingListener) {
        if (!this.__Flistener) {
            this.listener = loadBalancingListener;
            return;
        }
        this.__IM.onSet((Object)this, "listener", (Object)loadBalancingListener);
    }

    IEventListener __getbeanEventListener() {
        if (!this.__FbeanEventListener) {
            return this.beanEventListener;
        }
        return (IEventListener)this.__IM.onGet((Object)this, "beanEventListener");
    }

    void __setbeanEventListener(IEventListener iEventListener) {
        if (!this.__FbeanEventListener) {
            this.beanEventListener = iEventListener;
            return;
        }
        this.__IM.onSet((Object)this, "beanEventListener", (Object)iEventListener);
    }

    public CmiServiceImpl(BundleContext bundleContext) {
        this(null, bundleContext);
    }

    private CmiServiceImpl(InstanceManager _manager, BundleContext context) {
        this._setInstanceManager(_manager);
        this.__setjmxService(null);
        this.__seteventService(null);
        this.__setpolicyStrategyManager(null);
        this.__setbeanEventListener(null);
        this.__setcontext(context);
    }

    protected void doStart() throws ServiceException {
        if (!this.__MdoStart) {
            this.__doStart();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStart", new Object[0]);
            this.__doStart();
            this.__IM.onExit((Object)this, "doStart", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStart", throwable);
            throw throwable;
        }
    }

    private void __doStart() throws ServiceException {
        URL cmiConfUrl;
        File deployDirectory = new File(JProp.getJonasBase(), CmiServiceProperty.DEFAULT_DEPLOY_DIRECTORY.getPropertyName());
        try {
            File cmiConf = new File(JProp.getConfDir(), "cmi-config.xml");
            if (!cmiConf.exists()) {
                cmilogger.log(BasicLevel.ERROR, (Object)("Missing file 'cmi-config.xml' in JONAS_BASE : " + JProp.getConfDir()));
                throw new ServiceException("Missing file 'cmi-config.xml' in JONAS_BASE : " + JProp.getConfDir());
            }
            cmiConfUrl = cmiConf.toURI().toURL();
        }
        catch (Exception e) {
            cmilogger.log(BasicLevel.ERROR, (Object)"Cannot configure Carol to use CMI", (Throwable)e);
            throw new ServiceException("Cannot configure Carol to use CMI", (Throwable)e);
        }
        final ClusterViewManagerFactory clusterViewManagerFactory = ClusterViewManagerFactory.getFactory();
        IExecution<Boolean> startExec = new IExecution<Boolean>(){

            public Boolean execute() throws Exception {
                ConfigurationRepository.getServerConfiguration().enableCMI(cmiConfUrl);
                clusterViewManager = clusterViewManagerFactory.create();
                if (CmiServiceImpl.this.__geteventService() != null) {
                    List components = clusterViewManagerFactory.getConfig().getComponents().getComponents();
                    if (components != null) {
                        for (Component eventComponent : components) {
                            if (!EventComponent.class.isAssignableFrom(eventComponent.getClass())) continue;
                            ((EventComponent)eventComponent).setEventService(CmiServiceImpl.this.__geteventService());
                        }
                    }
                    if (clusterViewManager instanceof ServerClusterViewManager) {
                        CmiServiceImpl.this.__setbeanEventListener((IEventListener)new BeanEventListener((ServerClusterViewManager)clusterViewManager));
                        CmiServiceImpl.this.__geteventService().registerListener(CmiServiceImpl.this.__getbeanEventListener(), ((BeanEventListener)CmiServiceImpl.this.__getbeanEventListener()).getEventProviderFilter());
                    }
                }
                return clusterViewManager.start();
            }
        };
        ExecutionResult startExecResult = RunnableHelper.execute((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (IExecution)startExec);
        if (startExecResult.hasException()) {
            try {
                ConfigurationRepository.getServerConfiguration().disableCMI();
            }
            catch (Exception e) {
                cmilogger.log(BasicLevel.WARN, (Object)"Cannot disable cmi in Carol", (Throwable)e);
            }
            cmilogger.log(BasicLevel.ERROR, (Object)"Cannot start the server-side manager", (Throwable)startExecResult.getException());
            throw new ServiceException("Cannot start the CMI server", (Throwable)startExecResult.getException());
        }
        if (deployDirectory.exists()) {
            cmilogger.log(BasicLevel.DEBUG, (Object)("Deploy directory of CMI service is: " + deployDirectory.getAbsolutePath()));
            try {
                IServerConfig srvConfig = (IServerConfig)clusterViewManager.getConfig();
                srvConfig.setDeployDirectory(deployDirectory.getAbsolutePath());
            }
            catch (ClassCastException e) {
                cmilogger.log(BasicLevel.DEBUG, (Object)"Set deploy directory only if CMI is server");
            }
            catch (Exception e1) {
                cmilogger.log(BasicLevel.DEBUG, (Object)"Cannot set deploy directory", (Throwable)e1);
            }
        } else {
            cmilogger.log(BasicLevel.DEBUG, (Object)"No deploy directory for CMI service");
        }
        this.__setclusterViewManagerRegistration(this.__getcontext().registerService(ClusterViewManager.class.getName(), (Object)clusterViewManager, null));
        if (clusterViewManager instanceof ServerClusterViewManager) {
            this.__setpolicyStrategyManager(new CmiServicePolicyStrategyManager((ServerClusterViewManager)clusterViewManager));
            this.__setlistener(new LoadBalancingListener(this.__getpolicyStrategyManager()));
            cmilogger.log(BasicLevel.DEBUG, (Object)"Adding listener for load balancing service ");
            try {
                this.__getcontext().addServiceListener((ServiceListener)this.__getlistener(), "(objectClass=" + ILoadBalancingService.class.getName() + ")");
            }
            catch (InvalidSyntaxException e) {
                cmilogger.log(BasicLevel.WARN, (Object)("Unable to add service listener for " + ILoadBalancingService.class.getName() + " because: " + (Object)((Object)e)));
            }
        }
    }

    protected void doStop() throws ServiceException {
        if (!this.__MdoStop) {
            this.__doStop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStop", new Object[0]);
            this.__doStop();
            this.__IM.onExit((Object)this, "doStop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStop", throwable);
            throw throwable;
        }
    }

    private void __doStop() throws ServiceException {
        if (this.__getlistener() != null) {
            this.__getcontext().removeServiceListener((ServiceListener)this.__getlistener());
        }
        if (this.__getclusterViewManagerRegistration() != null) {
            this.__getclusterViewManagerRegistration().unregister();
        }
        try {
            ConfigurationRepository.getServerConfiguration().disableCMI();
        }
        catch (Exception e) {
            cmilogger.log(BasicLevel.WARN, (Object)"Cannot disable cmi in Carol", (Throwable)e);
        }
        if (clusterViewManager != null) {
            try {
                ((AbsServerClusterViewManager)clusterViewManager).stop();
            }
            catch (Exception e) {
                cmilogger.log(BasicLevel.ERROR, (Object)"Cannot stop the server-side manager", (Throwable)e);
                throw new ServiceException("Cannot stop the server-side manager", (Throwable)e);
            }
        }
    }

    protected JmxService getJmxService() {
        JmxService jmxService;
        if (!this.__MgetJmxService) {
            return this.__getJmxService();
        }
        try {
            this.__IM.onEntry((Object)this, "getJmxService", new Object[0]);
            jmxService = this.__getJmxService();
            this.__IM.onExit((Object)this, "getJmxService", (Object)jmxService);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getJmxService", throwable);
            throw throwable;
        }
        return jmxService;
    }

    private JmxService __getJmxService() {
        return this.__getjmxService();
    }

    public void setJmxService(JmxService jmxService) {
        if (!this.__MsetJmxService$org_ow2_jonas_jmx_JmxService) {
            this.__setJmxService(jmxService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setJmxService$org_ow2_jonas_jmx_JmxService", new Object[]{jmxService});
            this.__setJmxService(jmxService);
            this.__IM.onExit((Object)this, "setJmxService$org_ow2_jonas_jmx_JmxService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setJmxService$org_ow2_jonas_jmx_JmxService", throwable);
            throw throwable;
        }
    }

    private void __setJmxService(JmxService jmxService) {
        this.__setjmxService(jmxService);
    }

    public void setEventService(IEventService iEventService) {
        if (!this.__MsetEventService$org_ow2_util_event_api_IEventService) {
            this.__setEventService(iEventService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setEventService$org_ow2_util_event_api_IEventService", new Object[]{iEventService});
            this.__setEventService(iEventService);
            this.__IM.onExit((Object)this, "setEventService$org_ow2_util_event_api_IEventService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setEventService$org_ow2_util_event_api_IEventService", throwable);
            throw throwable;
        }
    }

    private void __setEventService(IEventService eventService) {
        this.__seteventService(eventService);
    }

    public void addClusteredObject(String string, Object object, Class<?> clazz, Class<? extends EJBObject> clazz2, ClassLoader classLoader, boolean bl, boolean bl2) throws Exception {
        if (!this.__MaddClusteredObject$java_lang_String$java_lang_Object$java_lang_Class$java_lang_Class$java_lang_ClassLoader$boolean$boolean) {
            this.__addClusteredObject(string, object, clazz, clazz2, classLoader, bl, bl2);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addClusteredObject$java_lang_String$java_lang_Object$java_lang_Class$java_lang_Class$java_lang_ClassLoader$boolean$boolean", new Object[]{string, object, clazz, clazz2, classLoader, new Boolean(bl), new Boolean(bl2)});
            this.__addClusteredObject(string, object, clazz, clazz2, classLoader, bl, bl2);
            this.__IM.onExit((Object)this, "addClusteredObject$java_lang_String$java_lang_Object$java_lang_Class$java_lang_Class$java_lang_ClassLoader$boolean$boolean", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addClusteredObject$java_lang_String$java_lang_Object$java_lang_Class$java_lang_Class$java_lang_ClassLoader$boolean$boolean", throwable);
            throw throwable;
        }
    }

    private void __addClusteredObject(String jndiName, Object clusterConfig, Class<?> homeClass, Class<? extends EJBObject> remoteClass, ClassLoader classLoader, boolean stateful, boolean clusterReplicated) throws Exception {
        cmilogger.log(BasicLevel.DEBUG, (Object)("Adding clustered object named: " + jndiName));
        ((BeanEventListener)this.__getbeanEventListener()).addClusteredObject(jndiName, clusterConfig, homeClass, remoteClass, classLoader, stateful, clusterReplicated);
    }

    public void removeClusteredObject(String string) throws Exception {
        if (!this.__MremoveClusteredObject$java_lang_String) {
            this.__removeClusteredObject(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeClusteredObject$java_lang_String", new Object[]{string});
            this.__removeClusteredObject(string);
            this.__IM.onExit((Object)this, "removeClusteredObject$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeClusteredObject$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __removeClusteredObject(String jndiName) throws Exception {
        cmilogger.log(BasicLevel.DEBUG, (Object)("Removing clustered object named :" + jndiName));
        ((BeanEventListener)this.__getbeanEventListener()).removeClusteredObject(jndiName);
    }

    public IEventListener getBeanEventListener() {
        IEventListener iEventListener;
        if (!this.__MgetBeanEventListener) {
            return this.__getBeanEventListener();
        }
        try {
            this.__IM.onEntry((Object)this, "getBeanEventListener", new Object[0]);
            iEventListener = this.__getBeanEventListener();
            this.__IM.onExit((Object)this, "getBeanEventListener", (Object)iEventListener);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getBeanEventListener", throwable);
            throw throwable;
        }
        return iEventListener;
    }

    private IEventListener __getBeanEventListener() {
        return this.__getbeanEventListener();
    }

    public void setBeanEventListener(IEventListener iEventListener) {
        if (!this.__MsetBeanEventListener$org_ow2_util_event_api_IEventListener) {
            this.__setBeanEventListener(iEventListener);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setBeanEventListener$org_ow2_util_event_api_IEventListener", new Object[]{iEventListener});
            this.__setBeanEventListener(iEventListener);
            this.__IM.onExit((Object)this, "setBeanEventListener$org_ow2_util_event_api_IEventListener", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setBeanEventListener$org_ow2_util_event_api_IEventListener", throwable);
            throw throwable;
        }
    }

    private void __setBeanEventListener(IEventListener beanEventListener) {
        this.__setbeanEventListener(beanEventListener);
    }

    public static synchronized ClusterViewManager getClusterViewManager() {
        return clusterViewManager;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("clusterViewManagerRegistration")) {
                this.__FclusterViewManagerRegistration = true;
            }
            if (set.contains("beanEventListener")) {
                this.__FbeanEventListener = true;
            }
            if (set.contains("listener")) {
                this.__Flistener = true;
            }
            if (set.contains("context")) {
                this.__Fcontext = true;
            }
            if (set.contains("policyStrategyManager")) {
                this.__FpolicyStrategyManager = true;
            }
            if (set.contains("eventService")) {
                this.__FeventService = true;
            }
            if (set.contains("jmxService")) {
                this.__FjmxService = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("doStart")) {
                this.__MdoStart = true;
            }
            if (set.contains("doStop")) {
                this.__MdoStop = true;
            }
            if (set.contains("getJmxService")) {
                this.__MgetJmxService = true;
            }
            if (set.contains("setJmxService$org_ow2_jonas_jmx_JmxService")) {
                this.__MsetJmxService$org_ow2_jonas_jmx_JmxService = true;
            }
            if (set.contains("setEventService$org_ow2_util_event_api_IEventService")) {
                this.__MsetEventService$org_ow2_util_event_api_IEventService = true;
            }
            if (set.contains("addClusteredObject$java_lang_String$java_lang_Object$java_lang_Class$java_lang_Class$java_lang_ClassLoader$boolean$boolean")) {
                this.__MaddClusteredObject$java_lang_String$java_lang_Object$java_lang_Class$java_lang_Class$java_lang_ClassLoader$boolean$boolean = true;
            }
            if (set.contains("removeClusteredObject$java_lang_String")) {
                this.__MremoveClusteredObject$java_lang_String = true;
            }
            if (set.contains("getBeanEventListener")) {
                this.__MgetBeanEventListener = true;
            }
            if (set.contains("setBeanEventListener$org_ow2_util_event_api_IEventListener")) {
                this.__MsetBeanEventListener$org_ow2_util_event_api_IEventListener = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

