/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.audit.internal.logger.util;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.objectweb.util.monolog.Monolog;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.MonologFactory;

public class LogConfigurator {
    private Properties properties = new Properties();
    private String className;
    private String loggerClassName;
    private int nbHandlers = 0;
    private int nbTopics = 0;
    private MonologFactory factory = null;
    public static final int SYSTEM_OUT = 0;
    public static final int SYSTEM_ERR = 1;
    public static final int SIMPLE_FILE = 0;
    public static final int ROLLING_FILE = 1;
    public static final long UNLIMITED_SIZE = 0L;
    public static final String ROOT_LOGGER = "root";
    public static final int WRAPPER_LOG4J = 0;
    public static final int WRAPPER_JDK = 1;
    public static final int WRAPPER_LOG4J_MINI = 2;
    public static final int WRAPPER_PRINTWRITER = 3;
    private static final String[] WRAPPERS = new String[]{"org.objectweb.util.monolog.wrapper.log4j.MonologLoggerFactory", "org.objectweb.util.monolog.wrapper.javaLog.LoggerFactory", "org.objectweb.util.monolog.wrapper.log4jMini.MonologLoggerFactory", "org.objectweb.util.monolog.wrapper.printwriter.LoggerImpl"};

    public LogConfigurator() {
        this.className = ROOT_LOGGER;
        this.loggerClassName = "logger.root";
    }

    public LogConfigurator(String className) {
        this.className = className;
        this.loggerClassName = "logger." + className;
    }

    public LogConfigurator(String className, String level, boolean inheritance) {
        this.className = className;
        this.loggerClassName = "logger." + className;
        this.setLoggerInheritance(inheritance);
        this.setLoggerLevel(level);
    }

    public Logger apply() {
        if (this.factory == null) {
            this.factory = Monolog.getMonologFactory((Properties)this.properties);
        }
        return this.factory.getLogger(this.className);
    }

    public static Logger apply(String classname, String filename) {
        return Monolog.getMonologFactory((String)filename).getLogger(classname);
    }

    public void createLevel(String levelName, String level) {
        this.putProperty("level." + levelName, level);
    }

    public void setLoggerLevel(String level) {
        this.putProperty(this.loggerClassName + ".level", level);
    }

    public void setLoggerInheritance(boolean inheritance) {
        if (!inheritance) {
            this.putProperty(this.loggerClassName + ".additivity", "false");
        } else if (this.properties.remove(this.loggerClassName + ".additivity") != null) {
            this.factory = null;
        }
    }

    public void setLoggerWrapper(int wrapper) {
        switch (wrapper) {
            case 0: 
            case 1: 
            case 2: {
                this.putProperty("monolog.classname", WRAPPERS[wrapper]);
                break;
            }
            default: {
                this.putProperty("monolog.classname", WRAPPERS[3]);
            }
        }
    }

    public void addLoggerTopic(String name) {
        this.putProperty(this.loggerClassName + ".topic." + String.valueOf(this.nbTopics), name);
        ++this.nbTopics;
    }

    private void setBasicHandler(String type, String handlerName, int output, String pattern, String level) {
        String handlerClassName = "handler." + handlerName;
        this.putProperty(handlerClassName + ".type", type);
        this.putProperty(handlerClassName + ".pattern", pattern);
        if (output == 0) {
            this.putProperty(handlerClassName + ".output", "System.out");
        } else {
            this.putProperty(handlerClassName + ".output", "System.err");
        }
        if (level != null) {
            this.putProperty(handlerClassName + ".level", level);
        }
        this.putProperty(this.loggerClassName + ".handler." + String.valueOf(this.nbHandlers), handlerName);
        ++this.nbHandlers;
    }

    public void setConsoleHandler(String handlerName, int output, String pattern, String level) {
        this.setBasicHandler("Console", handlerName, output, pattern, level);
    }

    public void setJMXHandler(String handlerName, int output, String pattern, String level) {
        this.setBasicHandler("jmx", handlerName, output, pattern, level);
    }

    public void setFileHandler(int type, String handlerName, String output, String pattern, String level, boolean appendMode, int fileNumber, long maxSize) {
        String handlerClassName = "handler." + handlerName;
        this.putProperty(handlerClassName + ".pattern", pattern);
        this.putProperty(handlerClassName + ".output", output);
        if (type == 0) {
            this.putProperty(handlerClassName + ".type", "File");
        } else {
            this.putProperty(handlerClassName + ".type", "Rollingfile");
        }
        if (level != null) {
            this.putProperty(handlerClassName + ".level", level);
        }
        if (appendMode) {
            this.putProperty(handlerClassName + ".appendMode", "");
        } else if (this.properties.remove(handlerClassName + ".appendMode") != null) {
            this.factory = null;
        }
        if (fileNumber > 1) {
            this.putProperty(handlerClassName + ".fileNumber", String.valueOf(fileNumber));
        }
        if (maxSize > 0L) {
            this.putProperty(handlerClassName + ".maxSize", String.valueOf(maxSize));
        }
        this.putProperty(this.loggerClassName + ".handler." + String.valueOf(this.nbHandlers), handlerName);
        ++this.nbHandlers;
    }

    public void setSimpleFileHandler(String handlerName, String output, String pattern, String level, boolean appendMode) {
        this.setFileHandler(0, handlerName, output, pattern, level, appendMode, 1, 0L);
    }

    public void setRollingFileHandler(String handlerName, String output, String pattern, String level, boolean appendMode, int fileNumber, long maxSize) {
        this.setFileHandler(1, handlerName, output, pattern, level, appendMode, fileNumber, maxSize);
    }

    public void changeHandlerOutput(String handlerName, String output) {
        this.putProperty("handler." + handlerName + ".output", output);
    }

    public void changeHandlerLevel(String handlerName, String level) {
        this.putProperty("handler." + handlerName + ".level", level);
    }

    public void changeHandlerPattern(String handlerName, String pattern) {
        this.putProperty("handler." + handlerName + ".pattern", pattern);
    }

    public void changeHandlerAppendMode(String handlerName, boolean appendMode) {
        if (appendMode) {
            this.putProperty("handler." + handlerName + ".appendMode", "");
        } else if (this.properties.remove("handler." + handlerName + ".appendMode") != null) {
            this.factory = null;
        }
    }

    public void changeHandlerFileNumber(String handlerName, int fileNumber) {
        this.putProperty("handler." + handlerName + ".fileNumber", String.valueOf(fileNumber));
    }

    public void changeHandlerFileMaxSize(String handlerName, long maxSize) {
        this.putProperty("handler." + handlerName + ".maxSize", String.valueOf(maxSize));
    }

    private void putProperty(String key, String value) {
        Object last = this.properties.put(key, value);
        if (last == null || !value.equals(last)) {
            this.factory = null;
        }
    }

    public String toString() {
        Set<Map.Entry<Object, Object>> setEnt = this.properties.entrySet();
        StringBuffer buffer = new StringBuffer();
        buffer.append("[\n");
        for (Map.Entry<Object, Object> entry : setEnt) {
            buffer.append("   ");
            buffer.append(entry.getKey().toString());
            buffer.append("  :  ");
            buffer.append(entry.getValue().toString());
            buffer.append("\n");
        }
        buffer.append("]\n");
        return buffer.toString();
    }
}

