/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.spec.ee.jpa;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceProviderResolver;
import javax.persistence.spi.PersistenceProviderResolverHolder;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceProviderActivator
implements BundleActivator,
PersistenceProviderResolver,
ServiceListener {
    private PersistenceProviderResolver previousPersistenceProviderResolver = null;
    private List<PersistenceProvider> persistenceProviders = new ArrayList<PersistenceProvider>();
    private BundleContext bundleContext = null;

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        this.previousPersistenceProviderResolver = PersistenceProviderResolverHolder.getPersistenceProviderResolver();
        PersistenceProviderResolverHolder.setPersistenceProviderResolver(this);
        ServiceReference[] serviceReferences = this.bundleContext.getServiceReferences(PersistenceProvider.class.getName(), null);
        if (serviceReferences != null) {
            for (ServiceReference serviceReference : serviceReferences) {
                PersistenceProvider persistenceProvider = (PersistenceProvider)this.bundleContext.getService(serviceReference);
                this.persistenceProviders.add(persistenceProvider);
            }
        }
        this.bundleContext.addServiceListener((ServiceListener)this, "(objectClass=" + PersistenceProvider.class.getName() + ")");
    }

    public void stop(BundleContext context) throws Exception {
        PersistenceProviderResolverHolder.setPersistenceProviderResolver(this.previousPersistenceProviderResolver);
    }

    @Override
    public void clearCachedProviders() {
        this.persistenceProviders.clear();
    }

    @Override
    public List<PersistenceProvider> getPersistenceProviders() {
        return this.persistenceProviders;
    }

    public void serviceChanged(ServiceEvent event) {
        ServiceReference serviceRef = event.getServiceReference();
        PersistenceProvider persistenceProvider = (PersistenceProvider)this.bundleContext.getService(serviceRef);
        switch (event.getType()) {
            case 1: {
                this.persistenceProviders.add(persistenceProvider);
                break;
            }
            case 4: {
                this.persistenceProviders.remove(persistenceProvider);
                break;
            }
        }
    }
}

