/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.connector;

import javax.jms.ConnectionConsumer;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.XAConnection;
import javax.jms.XATopicConnection;
import org.objectweb.joram.client.connector.AdapterTracing;
import org.objectweb.joram.client.connector.ManagedConnectionImpl;
import org.objectweb.joram.client.connector.OutboundConnection;
import org.objectweb.joram.client.connector.OutboundTopicSession;
import org.objectweb.util.monolog.api.BasicLevel;

public class OutboundTopicConnection
extends OutboundConnection
implements TopicConnection {
    OutboundTopicConnection(ManagedConnectionImpl managedCx, XATopicConnection xac) {
        super(managedCx, (XAConnection)xac);
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)("OutboundTopicConnection(" + managedCx + ", " + xac + ")"));
        }
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        Session sess;
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " createTopicSession(" + transacted + ", " + acknowledgeMode + ")"));
        }
        if (!this.valid) {
            throw new IllegalStateException("Invalid connection handle.");
        }
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " createTopicSession sess = " + this.managedCx.session));
        }
        if ((sess = this.managedCx.session) == null) {
            sess = this.xac.createSession(false, acknowledgeMode);
        }
        return new OutboundTopicSession(sess, this, transacted);
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new IllegalStateException("Forbidden call on a component's connection.");
    }
}

