/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.common;

import org.ow2.jonas.deployment.api.IResourceRefDesc;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.common.xml.JonasResource;
import org.ow2.jonas.deployment.common.xml.ResourceRef;

public class ResourceRefDesc
implements IResourceRefDesc {
    private static final String[] AUTH = new String[]{"APPLICATION_AUTH", "CONTAINER_AUTH"};
    private String name;
    private String typeName;
    private int authentication;
    private String jndiName;

    public ResourceRefDesc(ClassLoader classLoader, ResourceRef res, JonasResource jRes) throws DeploymentDescException {
        this.name = res.getResRefName();
        this.typeName = new String(res.getResType());
        String auth = res.getResAuth();
        if (auth.equals("Application")) {
            this.authentication = 0;
        } else if (auth.equals("Container")) {
            this.authentication = 1;
        } else {
            throw new DeploymentDescException("res-auth not valid for resource-ref " + this.name);
        }
        this.jndiName = jRes.getJndiName();
    }

    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getAuthentication() {
        return this.authentication;
    }

    public boolean isJdbc() {
        return "javax.sql.DataSource".equals(this.typeName);
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("\ngetName()=" + this.getName());
        ret.append("\ngetTypeName()=" + this.getTypeName());
        ret.append("\ngetAuthentication()=" + AUTH[this.getAuthentication()]);
        ret.append("\nisJdbc()=" + new Boolean(this.isJdbc()).toString());
        ret.append("\ngetJndiName()=" + this.getJndiName());
        return ret.toString();
    }
}

