/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.protocols.Discovery;
import org.jgroups.protocols.PingHeader;
import org.jgroups.util.Promise;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FILE_PING
extends Discovery {
    private static final String name = "FILE_PING";
    private static final String SUFFIX = ".node";
    private String location = File.separator + "tmp" + File.separator + "jgroups";
    protected File root_dir = null;
    protected FilenameFilter filter;

    @Override
    public String getName() {
        return name;
    }

    @Override
    public boolean setProperties(Properties props) {
        String str = props.getProperty("location");
        if (str != null) {
            this.location = str;
            props.remove("location");
        }
        return super.setProperties(props);
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.root_dir = new File(this.location);
        if (this.root_dir.exists()) {
            if (!this.root_dir.isDirectory()) {
                throw new IllegalArgumentException("location " + this.root_dir.getPath() + " is not a directory");
            }
        } else {
            this.root_dir.mkdirs();
        }
        if (!this.root_dir.exists()) {
            throw new IllegalArgumentException("location " + this.root_dir.getPath() + " could not be accessed");
        }
        this.filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(FILE_PING.SUFFIX);
            }
        };
    }

    @Override
    public void sendGetMembersRequest(Promise promise) throws Exception {
        String cluster_name = this.group_addr;
        List<Address> existing_mbrs = this.readAll(cluster_name);
        if (existing_mbrs.isEmpty() || existing_mbrs.size() == 1 && existing_mbrs.contains(this.local_addr)) {
            if (promise != null) {
                promise.setResult(null);
            }
        } else {
            for (final Address dest : existing_mbrs) {
                if (dest.equals(this.local_addr)) continue;
                PingHeader hdr = new PingHeader(1, null);
                final Message msg = new Message(dest);
                msg.setFlag((byte)1);
                msg.putHeader(this.getName(), hdr);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("[FIND_INITIAL_MBRS] sending PING request to " + msg.getDest()));
                }
                this.timer.submit(new Runnable(){

                    public void run() {
                        block2: {
                            try {
                                FILE_PING.this.down_prot.down(new Event(1, msg));
                            }
                            catch (Exception ex) {
                                if (!FILE_PING.this.log.isErrorEnabled()) break block2;
                                FILE_PING.this.log.error((Object)("failed sending discovery request to " + dest), (Throwable)ex);
                            }
                        }
                    }
                });
            }
        }
        this.writeToFile(this.local_addr, cluster_name);
    }

    private List<Address> readAll(String clustername) {
        File[] files;
        ArrayList<Address> retval = new ArrayList<Address>();
        File dir = new File(this.root_dir, clustername);
        if (!dir.exists()) {
            dir.mkdir();
        }
        if ((files = dir.listFiles(this.filter)) != null) {
            for (File file : files) {
                retval.add(FILE_PING.readFile(file));
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Address readFile(File file) {
        Address address;
        Address retval = null;
        DataInputStream in = null;
        try {
            in = new DataInputStream(new FileInputStream(file));
            address = Util.readAddress(in);
            Object var5_5 = null;
        }
        catch (Exception exception) {
            try {
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                Util.close(in);
                throw throwable;
            }
            Util.close(in);
            return retval;
        }
        Util.close(in);
        return address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeToFile(Address addr, String clustername) {
        DataOutputStream out = null;
        File dir = new File(this.root_dir, clustername);
        if (!dir.exists()) {
            dir.mkdir();
        }
        File file = new File(dir, addr.toString() + SUFFIX);
        file.deleteOnExit();
        try {
            try {
                out = new DataOutputStream(new FileOutputStream(file));
                Util.writeAddress(addr, out);
            }
            catch (Exception e) {
                Object var8_7 = null;
                Util.close(out);
                return;
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            Util.close(out);
            throw throwable;
        }
        Util.close(out);
    }
}

