/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.annotations.OrderCorrectionType;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.indirection.IndirectCollection;
import org.eclipse.persistence.indirection.IndirectList;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.IndexedObject;
import org.eclipse.persistence.internal.queries.ListContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.CollectionChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.OrderedChangeObject;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedListContainerPolicy
extends ListContainerPolicy {
    protected static final String NOT_SET = "NOT_SET";
    protected DatabaseField listOrderField;
    protected OrderCorrectionType orderCorrectionType;

    public OrderedListContainerPolicy() {
    }

    public OrderedListContainerPolicy(Class containerClass) {
        super(containerClass);
    }

    public OrderedListContainerPolicy(String containerClassName) {
        super(containerClassName);
    }

    @Override
    public boolean addAll(List elements, Object container, AbstractSession session, List<AbstractRecord> dbRows, ObjectBuildingQuery query) {
        if (this.listOrderField == null) {
            return super.addAll(elements, container, session, dbRows, query);
        }
        return this.addAll(elements, container, session, dbRows, (ReadQuery)query);
    }

    @Override
    public boolean addAll(List elements, Object container, AbstractSession session, List<AbstractRecord> dbRows, DataReadQuery query) {
        if (this.listOrderField == null) {
            return super.addAll(elements, container, session, dbRows, query);
        }
        return this.addAll(elements, container, session, dbRows, (ReadQuery)query);
    }

    protected boolean addAll(List elements, Object container, AbstractSession session, List<AbstractRecord> dbRows, ReadQuery query) {
        int i;
        int size = dbRows.size();
        if (this.elementDescriptor != null && this.elementDescriptor.getObjectBuilder().hasWrapperPolicy()) {
            ObjectBuilder objectBuilder = this.elementDescriptor.getObjectBuilder();
            ArrayList<Object> wrappedElements = new ArrayList<Object>(size);
            for (i = 0; i < size; ++i) {
                wrappedElements.add(objectBuilder.wrapObject(elements.get(i), session));
            }
            elements = wrappedElements;
        }
        ConversionManager conversionManager = session.getDatasourcePlatform().getConversionManager();
        for (int i2 = 0; i2 < size; ++i2) {
            ((List)container).add(NOT_SET);
        }
        boolean failed = false;
        for (i = 0; i < size; ++i) {
            AbstractRecord row = dbRows.get(i);
            Object orderValue = row.get(this.listOrderField);
            if (orderValue == null) {
                failed = true;
                break;
            }
            int intOrderValue = (Integer)conversionManager.convertObject(orderValue, Integer.class);
            try {
                if (NOT_SET == ((List)container).set(intOrderValue, elements.get(i))) continue;
                failed = true;
            }
            catch (IndexOutOfBoundsException indexException) {
                failed = true;
            }
            break;
        }
        if (failed) {
            ((List)container).clear();
            ArrayList<Integer> orderList = new ArrayList<Integer>(size);
            for (int i3 = 0; i3 < size; ++i3) {
                AbstractRecord row = dbRows.get(i3);
                Object orderValue = row.get(this.listOrderField);
                if (orderValue == null) {
                    orderList.add(null);
                    continue;
                }
                orderList.add((Integer)conversionManager.convertObject(orderValue, Integer.class));
            }
            if (this.orderCorrectionType == OrderCorrectionType.READ || this.orderCorrectionType == OrderCorrectionType.READ_WRITE) {
                ArrayList<IndexedObject> indexedElements = new ArrayList<IndexedObject>(size);
                for (int i4 = 0; i4 < size; ++i4) {
                    indexedElements.add(new IndexedObject((Integer)orderList.get(i4), elements.get(i4)));
                }
                ((List)container).addAll(this.correctOrderList(indexedElements));
                if (this.orderCorrectionType == OrderCorrectionType.READ_WRITE) {
                    ((IndirectList)container).setIsListOrderBrokenInDb(true);
                }
            } else {
                throw QueryException.listOrderFieldWrongValue(query, this.listOrderField, orderList);
            }
        }
        return size > 0;
    }

    protected void addIntoAtIndex(Integer index, Object object, Object container, AbstractSession session) {
        if (this.hasElementDescriptor()) {
            object = this.getElementDescriptor().getObjectBuilder().wrapObject(object, session);
        }
        try {
            if (index == null || index > this.sizeFor(container)) {
                ((List)container).add(object);
            } else {
                ((List)container).add(index, object);
            }
        }
        catch (ClassCastException ex1) {
            throw QueryException.cannotAddElement(object, container, ex1);
        }
        catch (IllegalArgumentException ex2) {
            throw QueryException.cannotAddElement(object, container, ex2);
        }
        catch (UnsupportedOperationException ex3) {
            throw QueryException.cannotAddElement(object, container, ex3);
        }
    }

    @Override
    public void compareCollectionsForChange(Object oldList, Object newList, CollectionChangeRecord changeRecord, AbstractSession session, ClassDescriptor referenceDescriptor) {
        ListIterator iterator;
        Vector orderedObjectsToAdd = new Vector();
        Hashtable<Integer, Integer> indicesToRemove = new Hashtable<Integer, Integer>();
        Hashtable oldListIndexValue = new Hashtable();
        IdentityHashMap oldListValueIndex = new IdentityHashMap();
        IdentityHashMap objectsToAdd = new IdentityHashMap();
        IdentityHashMap newListValueIndex = new IdentityHashMap();
        if (oldList != null) {
            iterator = (ListIterator)this.iteratorFor(oldList);
            while (iterator.hasNext()) {
                Integer index = iterator.nextIndex();
                Object value = iterator.next();
                oldListValueIndex.put(value, index);
                oldListIndexValue.put(index, value);
                indicesToRemove.put(index, index);
            }
        }
        if (newList != null) {
            iterator = (ListIterator)this.iteratorFor(newList);
            while (iterator.hasNext()) {
                newListValueIndex.put(iterator.next(), iterator.previousIndex());
            }
            int index = 0;
            int offset = 0;
            iterator = (ListIterator)this.iteratorFor(newList);
            while (iterator.hasNext()) {
                index = iterator.nextIndex();
                Object currentObject = iterator.next();
                if (currentObject != null) {
                    if (oldListValueIndex.containsKey(currentObject)) {
                        int oldIndex = (Integer)oldListValueIndex.get(currentObject);
                        oldListValueIndex.remove(currentObject);
                        if (index == oldIndex) {
                            indicesToRemove.remove(oldIndex);
                            offset = 0;
                            continue;
                        }
                        if (index == oldIndex + offset) {
                            indicesToRemove.remove(oldIndex);
                            continue;
                        }
                        int movedObjects = 0;
                        int deletedObjects = 0;
                        boolean moved = true;
                        if (oldIndex < index) {
                            ++offset;
                        } else {
                            for (int i = oldIndex - 1; i >= index; --i) {
                                Object oldObject = oldListIndexValue.get(i);
                                if (newListValueIndex.containsKey(oldObject)) {
                                    ++movedObjects;
                                    continue;
                                }
                                ++deletedObjects;
                            }
                            if (index == oldIndex + offset - deletedObjects) {
                                offset -= deletedObjects;
                                moved = false;
                            } else if (movedObjects > 1) {
                                ++offset;
                            } else {
                                Object oldObject = oldListIndexValue.get(index);
                                if (newListValueIndex.containsKey(oldObject) && (Integer)newListValueIndex.get(oldObject) - index > 1) {
                                    moved = false;
                                    --offset;
                                }
                            }
                        }
                        if (moved) {
                            orderedObjectsToAdd.add(currentObject);
                            continue;
                        }
                        indicesToRemove.remove(oldIndex);
                        continue;
                    }
                    ++offset;
                    objectsToAdd.put(currentObject, currentObject);
                    orderedObjectsToAdd.add(currentObject);
                    continue;
                }
                --offset;
            }
        }
        Vector orderedIndicesToRemove = new Vector(indicesToRemove.values());
        Collections.sort(orderedIndicesToRemove);
        changeRecord.addAdditionChange(objectsToAdd, this, (UnitOfWorkChangeSet)changeRecord.getOwner().getUOWChangeSet(), session);
        changeRecord.addRemoveChange(oldListValueIndex, this, (UnitOfWorkChangeSet)changeRecord.getOwner().getUOWChangeSet(), session);
        changeRecord.addOrderedAdditionChange(orderedObjectsToAdd, newListValueIndex, (UnitOfWorkChangeSet)changeRecord.getOwner().getUOWChangeSet(), session);
        changeRecord.addOrderedRemoveChange(orderedIndicesToRemove, oldListIndexValue, (UnitOfWorkChangeSet)changeRecord.getOwner().getUOWChangeSet(), session);
    }

    public List correctOrderList(List<IndexedObject> indexedObjects) {
        Collections.sort(indexedObjects);
        int size = indexedObjects.size();
        ArrayList<Object> objects = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            objects.add(indexedObjects.get(i).getObject());
        }
        return objects;
    }

    @Override
    public Iterator getChangeValuesFrom(Map map) {
        return map.keySet().iterator();
    }

    public DatabaseField getListOrderField() {
        return this.listOrderField;
    }

    public void setListOrderField(DatabaseField field) {
        this.listOrderField = field;
    }

    public OrderCorrectionType getOrderCorrectionType() {
        return this.orderCorrectionType;
    }

    public void setOrderCorrectionType(OrderCorrectionType orderCorrectionType) {
        if (this.orderCorrectionType == orderCorrectionType) {
            return;
        }
        if (!(orderCorrectionType != OrderCorrectionType.READ_WRITE || this.getContainerClass() != null && IndirectList.class.isAssignableFrom(this.getContainerClass()))) {
            this.setContainerClass(IndirectList.class);
        }
        this.orderCorrectionType = orderCorrectionType;
    }

    @Override
    public Object iteratorFor(Object container) {
        return ((List)container).listIterator();
    }

    @Override
    public boolean isOrderedListPolicy() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void mergeChanges(CollectionChangeRecord changeRecord, Object valueOfTarget, boolean shouldMergeCascadeParts, MergeManager mergeManager, AbstractSession parentSession) {
        Object synchronizedValueOfTarget = valueOfTarget;
        if (valueOfTarget instanceof IndirectCollection) {
            synchronizedValueOfTarget = ((IndirectCollection)valueOfTarget).getDelegateObject();
            if (changeRecord.orderHasBeenRepaired() && valueOfTarget instanceof IndirectList) {
                ((IndirectList)valueOfTarget).setIsListOrderBrokenInDb(false);
            }
        }
        Object object = synchronizedValueOfTarget;
        synchronized (object) {
            ObjectChangeSet objectChanges2;
            block21: {
                Vector removedIndices;
                block20: {
                    block19: {
                        if (!changeRecord.getOrderedChangeObjectList().isEmpty()) break block19;
                        removedIndices = changeRecord.getOrderedRemoveObjectIndices();
                        if (!removedIndices.isEmpty()) break block20;
                        for (ObjectChangeSet objectChanges2 : changeRecord.getRemoveObjectList().keySet()) {
                            this.removeFrom(objectChanges2.getOldKey(), objectChanges2.getTargetVersionOfSourceObject(mergeManager.getSession()), valueOfTarget, parentSession);
                            this.registerRemoveNewObjectIfRequired(objectChanges2, mergeManager);
                        }
                        break block21;
                    }
                    Iterator objects = changeRecord.getOrderedChangeObjectList().iterator();
                    while (objects.hasNext()) {
                        OrderedChangeObject changeObject = (OrderedChangeObject)objects.next();
                        ObjectChangeSet objectChanges3 = changeObject.getChangeSet();
                        if (changeObject.getChangeType() == CollectionChangeEvent.REMOVE) {
                            boolean objectRemoved = changeRecord.getRemoveObjectList().containsKey(objectChanges3);
                            Object objectToRemove = objectChanges3.getTargetVersionOfSourceObject(mergeManager.getSession());
                            if (objectToRemove == null) continue;
                            Integer index = changeObject.getIndex();
                            if (index != null) {
                                if (!objectToRemove.equals(this.get(index, valueOfTarget, mergeManager.getSession()))) {
                                    Object key = changeRecord.getOwner().getId();
                                    parentSession.getIdentityMapAccessor().invalidateObject(key, changeRecord.getOwner().getClassType(parentSession));
                                    return;
                                }
                                this.removeFromAtIndex(index, valueOfTarget);
                            } else {
                                this.removeFrom(objectToRemove, valueOfTarget, parentSession);
                            }
                            if (mergeManager.shouldMergeChangesIntoDistributedCache() || !changeRecord.getMapping().isPrivateOwned() || !objectRemoved) continue;
                            mergeManager.registerRemovedNewObjectIfRequired(objectChanges3.getUnitOfWorkClone());
                            continue;
                        }
                        boolean objectAdded = changeRecord.getAddObjectList().containsKey(objectChanges3);
                        Object object2 = null;
                        if (objectAdded && shouldMergeCascadeParts) {
                            object2 = this.mergeCascadeParts(objectChanges3, mergeManager, parentSession);
                        }
                        if (object2 == null) {
                            object2 = objectChanges3.getTargetVersionOfSourceObject(mergeManager.getSession());
                        }
                        if (objectAdded && mergeManager.shouldMergeChangesIntoDistributedCache()) {
                            if (this.contains(object2, valueOfTarget, mergeManager.getSession())) continue;
                            this.addIntoAtIndex(changeObject.getIndex(), object2, valueOfTarget, mergeManager.getSession());
                            continue;
                        }
                        this.addIntoAtIndex(changeObject.getIndex(), object2, valueOfTarget, mergeManager.getSession());
                    }
                    return;
                }
                for (int i = removedIndices.size() - 1; i >= 0; --i) {
                    Integer index = (int)((Integer)removedIndices.elementAt(i));
                    objectChanges2 = (ObjectChangeSet)changeRecord.getOrderedRemoveObject(index);
                    Object objectToRemove = objectChanges2.getTargetVersionOfSourceObject(mergeManager.getSession());
                    if (objectToRemove != null && objectToRemove.equals(this.get(index, valueOfTarget, mergeManager.getSession()))) {
                        this.removeFromAtIndex(index, valueOfTarget);
                        if (!changeRecord.getRemoveObjectList().containsKey(objectChanges2)) continue;
                        this.registerRemoveNewObjectIfRequired(objectChanges2, mergeManager);
                        continue;
                    }
                    Object key = changeRecord.getOwner().getId();
                    parentSession.getIdentityMapAccessor().invalidateObject(key, changeRecord.getOwner().getClassType(parentSession));
                    return;
                }
            }
            Enumeration addObjects = changeRecord.getOrderedAddObjects().elements();
            while (addObjects.hasMoreElements()) {
                objectChanges2 = (ObjectChangeSet)addObjects.nextElement();
                boolean objectAdded = changeRecord.getAddObjectList().containsKey(objectChanges2);
                Object object3 = null;
                if (objectAdded && shouldMergeCascadeParts) {
                    object3 = this.mergeCascadeParts(objectChanges2, mergeManager, parentSession);
                }
                if (object3 == null) {
                    object3 = objectChanges2.getTargetVersionOfSourceObject(mergeManager.getSession());
                }
                if (objectAdded && mergeManager.shouldMergeChangesIntoDistributedCache()) {
                    if (this.contains(object3, valueOfTarget, mergeManager.getSession())) continue;
                    this.addIntoAtIndex(changeRecord.getOrderedAddObjectIndex(objectChanges2), object3, valueOfTarget, mergeManager.getSession());
                    continue;
                }
                this.addIntoAtIndex(changeRecord.getOrderedAddObjectIndex(objectChanges2), object3, valueOfTarget, mergeManager.getSession());
            }
            return;
        }
    }

    protected void registerRemoveNewObjectIfRequired(ObjectChangeSet objectChanges, MergeManager mergeManager) {
        if (!mergeManager.shouldMergeChangesIntoDistributedCache()) {
            mergeManager.registerRemovedNewObjectIfRequired(objectChanges.getUnitOfWorkClone());
        }
    }

    protected void removeFromAtIndex(int index, Object container) {
        try {
            ((List)container).remove(index);
        }
        catch (ClassCastException ex1) {
            throw QueryException.cannotRemoveFromContainer(index, container, this);
        }
        catch (IllegalArgumentException ex2) {
            throw QueryException.cannotRemoveFromContainer(index, container, this);
        }
        catch (UnsupportedOperationException ex3) {
            throw QueryException.cannotRemoveFromContainer(index, container, this);
        }
    }

    @Override
    public void recordAddToCollectionInChangeRecord(ObjectChangeSet changeSetToAdd, CollectionChangeRecord collectionChangeRecord) {
        OrderedChangeObject orderedChangeObject = new OrderedChangeObject(CollectionChangeEvent.ADD, null, changeSetToAdd);
        collectionChangeRecord.getOrderedChangeObjectList().add(orderedChangeObject);
    }

    @Override
    public void recordRemoveFromCollectionInChangeRecord(ObjectChangeSet changeSetToRemove, CollectionChangeRecord collectionChangeRecord) {
        OrderedChangeObject orderedChangeObject = new OrderedChangeObject(CollectionChangeEvent.REMOVE, null, changeSetToRemove);
        collectionChangeRecord.getOrderedChangeObjectList().add(orderedChangeObject);
    }

    @Override
    public void recordUpdateToCollectionInChangeRecord(CollectionChangeEvent event, ObjectChangeSet changeSet, CollectionChangeRecord collectionChangeRecord) {
        int changeType = event.getChangeType();
        if (changeType == CollectionChangeEvent.ADD) {
            super.recordAddToCollectionInChangeRecord(changeSet, collectionChangeRecord);
        } else if (changeType == CollectionChangeEvent.REMOVE) {
            super.recordRemoveFromCollectionInChangeRecord(changeSet, collectionChangeRecord);
        } else {
            throw ValidationException.wrongCollectionChangeEventType(changeType);
        }
        OrderedChangeObject orderedChangeObject = new OrderedChangeObject(changeType, event.getIndex(), changeSet, event.getNewValue());
        collectionChangeRecord.getOrderedChangeObjectList().add(orderedChangeObject);
    }

    @Override
    public boolean shouldAddAll() {
        return this.listOrderField != null;
    }

    @Override
    public List<DatabaseField> getAdditionalFieldsForJoin(CollectionMapping baseMapping) {
        if (this.listOrderField != null) {
            ArrayList<DatabaseField> fields = new ArrayList<DatabaseField>(1);
            fields.add(this.listOrderField);
            return fields;
        }
        return null;
    }

    @Override
    public int updateJoinedMappingIndexesForMapKey(Map<DatabaseMapping, Object> indexList, int index) {
        if (this.listOrderField != null) {
            return 1;
        }
        return 0;
    }

    @Override
    public List<DatabaseTable> getAdditionalTablesForJoinQuery() {
        if (this.listOrderField != null) {
            ArrayList<DatabaseTable> tables = new ArrayList<DatabaseTable>(1);
            tables.add(this.listOrderField.getTable());
            return tables;
        }
        return null;
    }

    @Override
    public void addAdditionalFieldsToQuery(ReadQuery selectionQuery, Expression baseExpression) {
        if (this.listOrderField != null) {
            if (selectionQuery.isObjectLevelReadQuery()) {
                ((ObjectLevelReadQuery)selectionQuery).addAdditionalField(baseExpression.getField(this.listOrderField));
            } else {
                ((SQLSelectStatement)((DataReadQuery)selectionQuery).getSQLStatement()).addField(baseExpression.getField(this.listOrderField));
            }
        }
    }
}

