/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.JAXBException;
import org.eclipse.persistence.jaxb.TypeMappingInfo;
import org.eclipse.persistence.jaxb.compiler.AnnotationsProcessor;
import org.eclipse.persistence.jaxb.compiler.EnumTypeInfo;
import org.eclipse.persistence.jaxb.compiler.JAXBMetadataLogger;
import org.eclipse.persistence.jaxb.compiler.NamespaceInfo;
import org.eclipse.persistence.jaxb.compiler.Property;
import org.eclipse.persistence.jaxb.compiler.TypeInfo;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaModelInput;
import org.eclipse.persistence.jaxb.xmlmodel.JavaAttribute;
import org.eclipse.persistence.jaxb.xmlmodel.JavaType;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAbstractNullPolicy;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAnyAttribute;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAnyElement;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAttribute;
import org.eclipse.persistence.jaxb.xmlmodel.XmlBindings;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElement;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElementRef;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElementRefs;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElements;
import org.eclipse.persistence.jaxb.xmlmodel.XmlEnum;
import org.eclipse.persistence.jaxb.xmlmodel.XmlEnumValue;
import org.eclipse.persistence.jaxb.xmlmodel.XmlInverseReference;
import org.eclipse.persistence.jaxb.xmlmodel.XmlJavaTypeAdapter;
import org.eclipse.persistence.jaxb.xmlmodel.XmlMap;
import org.eclipse.persistence.jaxb.xmlmodel.XmlNsForm;
import org.eclipse.persistence.jaxb.xmlmodel.XmlRegistry;
import org.eclipse.persistence.jaxb.xmlmodel.XmlSchema;
import org.eclipse.persistence.jaxb.xmlmodel.XmlSchemaType;
import org.eclipse.persistence.jaxb.xmlmodel.XmlSchemaTypes;
import org.eclipse.persistence.jaxb.xmlmodel.XmlTransient;
import org.eclipse.persistence.jaxb.xmlmodel.XmlValue;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLProcessor {
    private Map<String, XmlBindings> xmlBindingMap;
    private JavaModelInput jModelInput;
    private AnnotationsProcessor aProcessor;
    private JAXBMetadataLogger logger;
    private static final String COLON = ":";
    private static final String SLASH = "/";
    private static final String SELF = ".";
    private static final String OPEN_BRACKET = "[";

    public XMLProcessor(Map<String, XmlBindings> bindings) {
        this.xmlBindingMap = bindings;
    }

    public void processXML(AnnotationsProcessor annotationsProcessor, JavaModelInput jModelInput, TypeMappingInfo[] typeMappingInfos, JavaClass[] originalJavaClasses) {
        this.jModelInput = jModelInput;
        this.aProcessor = annotationsProcessor;
        HashMap<String, XmlEnum> xmlEnumMap = new HashMap<String, XmlEnum>();
        annotationsProcessor.init(originalJavaClasses, typeMappingInfos);
        Map<String, ArrayList<JavaClass>> pkgToClassMap = this.buildPackageToJavaClassMap();
        for (String packageName : this.xmlBindingMap.keySet()) {
            XmlBindings.XmlRegistries xmlRegs;
            ArrayList<JavaClass> classesToProcess = pkgToClassMap.get(packageName);
            if (classesToProcess == null) {
                this.getLogger().logWarning("jaxb_metadata_warning_no_classes_to_process", new Object[]{packageName});
                continue;
            }
            XmlBindings xmlBindings = this.xmlBindingMap.get(packageName);
            NamespaceInfo nsInfo = this.processXmlSchema(xmlBindings, packageName);
            if (nsInfo != null) {
                annotationsProcessor.addPackageToNamespaceMapping(packageName, nsInfo);
            }
            if ((xmlRegs = xmlBindings.getXmlRegistries()) != null) {
                for (XmlRegistry xmlReg : xmlRegs.getXmlRegistry()) {
                    this.aProcessor.addXmlRegistry(xmlReg.getName(), xmlReg);
                }
            }
            JavaClass[] javaClasses = classesToProcess.toArray(new JavaClass[classesToProcess.size()]);
            XmlBindings.XmlEnums xmlEnums = xmlBindings.getXmlEnums();
            if (xmlEnums != null) {
                for (XmlEnum xmlEnum : xmlEnums.getXmlEnum()) {
                    xmlEnumMap.put(xmlEnum.getJavaEnum(), xmlEnum);
                }
            }
            Map<String, TypeInfo> typeInfoMap = annotationsProcessor.preBuildTypeInfo(javaClasses);
            List<XmlSchemaType> xmlSchemaTypes = null;
            XmlSchemaTypes sTypes = xmlBindings.getXmlSchemaTypes();
            xmlSchemaTypes = sTypes != null ? sTypes.getXmlSchemaType() : new ArrayList<XmlSchemaType>();
            if (xmlBindings.getXmlSchemaType() != null) {
                xmlSchemaTypes.add(xmlBindings.getXmlSchemaType());
            }
            for (XmlSchemaType sType : xmlSchemaTypes) {
                JavaClass jClass = this.aProcessor.getHelper().getJavaClass(sType.getType());
                if (jClass == null) continue;
                this.aProcessor.processSchemaType(sType.getName(), sType.getNamespace(), jClass.getQualifiedName());
            }
            nsInfo = annotationsProcessor.getPackageToNamespaceMappings().get(packageName);
            XmlBindings.JavaTypes jTypes = xmlBindings.getJavaTypes();
            if (jTypes != null) {
                for (JavaType javaType : jTypes.getJavaType()) {
                    TypeInfo typeInfo = typeInfoMap.get(javaType.getName());
                    if (javaType.getXmlJavaTypeAdapter() != null) {
                        typeInfo.setXmlJavaTypeAdapter(javaType.getXmlJavaTypeAdapter());
                    }
                    if (javaType.isSetXmlAccessorOrder()) {
                        typeInfo.setXmlAccessOrder(javaType.getXmlAccessorOrder());
                    } else if (!typeInfo.isSetXmlAccessOrder()) {
                        if (xmlBindings.isSetXmlAccessorOrder()) {
                            typeInfo.setXmlAccessOrder(xmlBindings.getXmlAccessorOrder());
                        } else {
                            typeInfo.setXmlAccessOrder(nsInfo.getAccessOrder());
                        }
                    }
                    if (javaType.isSetXmlAccessorType()) {
                        typeInfo.setXmlAccessType(javaType.getXmlAccessorType());
                    } else if (!typeInfo.isSetXmlAccessType()) {
                        if (xmlBindings.isSetXmlAccessorType()) {
                            typeInfo.setXmlAccessType(xmlBindings.getXmlAccessorType());
                        } else {
                            typeInfo.setXmlAccessType(nsInfo.getAccessType());
                        }
                    }
                    if (javaType.isSetXmlInlineBinaryData()) {
                        typeInfo.setInlineBinaryData(javaType.isXmlInlineBinaryData());
                    }
                    if (javaType.isSetXmlTransient()) {
                        typeInfo.setXmlTransient(javaType.isXmlTransient());
                    }
                    if (javaType.getXmlRootElement() != null) {
                        typeInfo.setXmlRootElement(javaType.getXmlRootElement());
                    }
                    if (javaType.getXmlSeeAlso() != null && javaType.getXmlSeeAlso().size() > 0) {
                        typeInfo.setXmlSeeAlso(javaType.getXmlSeeAlso());
                    }
                    if (javaType.getXmlType() != null) {
                        typeInfo.setXmlType(javaType.getXmlType());
                    }
                    if (javaType.getXmlCustomizer() == null) continue;
                    typeInfo.setXmlCustomizer(javaType.getXmlCustomizer());
                }
            }
            if (xmlBindings.getXmlJavaTypeAdapters() != null) {
                Map<String, TypeInfo> typeInfos = this.aProcessor.getTypeInfosForPackage(packageName);
                for (TypeInfo typeInfo : typeInfos.values()) {
                    List<XmlJavaTypeAdapter> adapters = xmlBindings.getXmlJavaTypeAdapters().getXmlJavaTypeAdapter();
                    for (XmlJavaTypeAdapter xja : adapters) {
                        try {
                            JavaClass adapterClass = jModelInput.getJavaModel().getClass(xja.getValue());
                            JavaClass boundType = jModelInput.getJavaModel().getClass(xja.getType());
                            if (boundType == null) continue;
                            typeInfo.addPackageLevelAdapterClass(adapterClass, boundType);
                        }
                        catch (JAXBException e) {
                            Object[] messageParams = new String[]{xja.getValue(), packageName};
                            this.getLogger().logWarning("jaxb_metadata_warning_invalid_package_level_xml_java_type_adapter", messageParams);
                        }
                    }
                }
            }
            javaClasses = annotationsProcessor.postBuildTypeInfo(javaClasses);
            annotationsProcessor.processJavaClasses(javaClasses);
            Map<String, TypeInfo> typeInfosForPackage = annotationsProcessor.getTypeInfosForPackage(packageName);
            for (Map.Entry entry : typeInfosForPackage.entrySet()) {
                EnumTypeInfo etInfo;
                XmlEnum xmlEnum;
                TypeInfo tInfo = (TypeInfo)entry.getValue();
                if (!tInfo.isEnumerationType() || (xmlEnum = (XmlEnum)xmlEnumMap.get((etInfo = (EnumTypeInfo)tInfo).getClassName())) == null) continue;
                JavaClass restrictionClass = this.aProcessor.getHelper().getJavaClass(xmlEnum.getValue());
                if (restrictionClass == null) {
                    restrictionClass = jModelInput.getJavaModel().getClass(String.class);
                }
                etInfo.setRestrictionBase(this.aProcessor.getSchemaTypeFor(restrictionClass));
                for (XmlEnumValue xmlEnumValue : xmlEnum.getXmlEnumValue()) {
                    etInfo.addJavaFieldToXmlEnumValuePair(true, xmlEnumValue.getJavaEnumValue(), xmlEnumValue.getValue());
                }
            }
            jTypes = xmlBindings.getJavaTypes();
            if (jTypes != null) {
                for (JavaType javaType : jTypes.getJavaType()) {
                    this.processJavaType(javaType, typeInfosForPackage.get(javaType.getName()), nsInfo);
                }
            }
            pkgToClassMap.remove(packageName);
        }
        for (ArrayList<JavaClass> jClassList : pkgToClassMap.values()) {
            JavaClass[] jClassArray = jClassList.toArray(new JavaClass[jClassList.size()]);
            annotationsProcessor.buildNewTypeInfo(jClassArray);
            annotationsProcessor.processJavaClasses(jClassArray);
        }
        Map typeInfos = (Map)this.aProcessor.getTypeInfo().clone();
        for (Map.Entry entry : typeInfos.entrySet()) {
            for (Property prop : ((TypeInfo)entry.getValue()).getPropertyList()) {
                if (!prop.isSetXmlJavaTypeAdapter()) continue;
                JavaClass[] jClassArray = new JavaClass[]{prop.getActualType()};
                this.aProcessor.buildNewTypeInfo(jClassArray);
            }
        }
        this.aProcessor.finalizeProperties();
        this.aProcessor.createElementsForTypeMappingInfo();
    }

    private void processJavaType(JavaType javaType, TypeInfo typeInfo, NamespaceInfo nsInfo) {
        if (null != javaType.getJavaAttributes()) {
            for (JAXBElement<? extends JavaAttribute> jaxbElement : javaType.getJavaAttributes().getJavaAttribute()) {
                JavaAttribute javaAttribute = (JavaAttribute)jaxbElement.getValue();
                Property oldProperty = typeInfo.getProperties().get(javaAttribute.getJavaAttribute());
                if (oldProperty == null) {
                    this.getLogger().logWarning("jaxb_metadata_warning_ignoring_java_attribute", new Object[]{javaAttribute.getJavaAttribute(), javaType.getName()});
                    continue;
                }
                Property newProperty = this.processJavaAttribute(typeInfo, javaAttribute, oldProperty, nsInfo, javaType);
                typeInfo.getProperties().put(javaAttribute.getJavaAttribute(), newProperty);
            }
        }
    }

    private Property processJavaAttribute(TypeInfo typeInfo, JavaAttribute javaAttribute, Property oldProperty, NamespaceInfo nsInfo, JavaType javaType) {
        if (javaAttribute instanceof XmlAnyAttribute) {
            return this.processXmlAnyAttribute((XmlAnyAttribute)javaAttribute, oldProperty, typeInfo, javaType);
        }
        if (javaAttribute instanceof XmlAnyElement) {
            return this.processXmlAnyElement((XmlAnyElement)javaAttribute, oldProperty, typeInfo, javaType);
        }
        if (javaAttribute instanceof XmlAttribute) {
            return this.processXmlAttribute((XmlAttribute)javaAttribute, oldProperty, typeInfo, nsInfo);
        }
        if (javaAttribute instanceof XmlElement) {
            return this.processXmlElement((XmlElement)javaAttribute, oldProperty, typeInfo, nsInfo, javaType);
        }
        if (javaAttribute instanceof XmlElements) {
            return this.processXmlElements((XmlElements)javaAttribute, oldProperty, typeInfo);
        }
        if (javaAttribute instanceof XmlElementRef) {
            return this.processXmlElementRef((XmlElementRef)javaAttribute, oldProperty, typeInfo);
        }
        if (javaAttribute instanceof XmlElementRefs) {
            return this.processXmlElementRefs((XmlElementRefs)javaAttribute, oldProperty, typeInfo);
        }
        if (javaAttribute instanceof XmlTransient) {
            return this.processXmlTransient((XmlTransient)javaAttribute, oldProperty);
        }
        if (javaAttribute instanceof XmlValue) {
            return this.processXmlValue((XmlValue)javaAttribute, oldProperty, typeInfo, javaType);
        }
        if (javaAttribute instanceof XmlJavaTypeAdapter) {
            return this.processXmlJavaTypeAdapter((XmlJavaTypeAdapter)javaAttribute, oldProperty);
        }
        if (javaAttribute instanceof XmlInverseReference) {
            return this.processXmlInverseReference((XmlInverseReference)javaAttribute, oldProperty);
        }
        this.getLogger().logWarning("jaxb_metadata_warning_invalid_java_attribute", new Object[]{javaAttribute.getClass()});
        return null;
    }

    private Property processXmlJavaTypeAdapter(XmlJavaTypeAdapter xmlAdapter, Property oldProperty) {
        oldProperty.setXmlJavaTypeAdapter(xmlAdapter);
        return oldProperty;
    }

    private Property processXmlInverseReference(XmlInverseReference xmlInverseReference, Property oldProperty) {
        oldProperty.setInverseReference(true);
        oldProperty.setInverseReferencePropertyName(xmlInverseReference.getMappedBy());
        if (xmlInverseReference.getXmlAccessMethods() != null) {
            oldProperty.setInverseReferencePropertyGetMethodName(xmlInverseReference.getXmlAccessMethods().getGetMethod());
            oldProperty.setInverseReferencePropertySetMethodName(xmlInverseReference.getXmlAccessMethods().getSetMethod());
        }
        return oldProperty;
    }

    private Property processXmlAnyAttribute(XmlAnyAttribute xmlAnyAttribute, Property oldProperty, TypeInfo tInfo, JavaType javaType) {
        if (oldProperty.isAnyAttribute()) {
            return oldProperty;
        }
        if (!oldProperty.getType().getName().equals("java.util.Map")) {
            throw JAXBException.anyAttributeOnNonMap(oldProperty.getPropertyName());
        }
        this.resetProperty(oldProperty, tInfo);
        oldProperty.setIsAnyAttribute(true);
        tInfo.setAnyAttributePropertyName(oldProperty.getPropertyName());
        if (xmlAnyAttribute.getXmlPath() != null) {
            oldProperty.setXmlPath(xmlAnyAttribute.getXmlPath());
        }
        if (xmlAnyAttribute.getXmlAccessMethods() != null) {
            oldProperty.setMethodProperty(true);
            oldProperty.setGetMethodName(xmlAnyAttribute.getXmlAccessMethods().getGetMethod());
            oldProperty.setSetMethodName(xmlAnyAttribute.getXmlAccessMethods().getSetMethod());
        }
        if (xmlAnyAttribute.isSetReadOnly()) {
            oldProperty.setReadOnly(xmlAnyAttribute.isReadOnly());
        }
        if (xmlAnyAttribute.isSetWriteOnly()) {
            oldProperty.setWriteOnly(xmlAnyAttribute.isWriteOnly());
        }
        return oldProperty;
    }

    private Property processXmlAnyElement(XmlAnyElement xmlAnyElement, Property oldProperty, TypeInfo tInfo, JavaType javaType) {
        this.resetProperty(oldProperty, tInfo);
        oldProperty.setIsAny(true);
        oldProperty.setDomHandlerClassName(xmlAnyElement.getDomHandler());
        oldProperty.setLax(xmlAnyElement.isLax());
        oldProperty.setMixedContent(xmlAnyElement.isXmlMixed());
        oldProperty.setXmlJavaTypeAdapter(xmlAnyElement.getXmlJavaTypeAdapter());
        tInfo.setMixed(xmlAnyElement.isXmlMixed());
        tInfo.setAnyElementPropertyName(oldProperty.getPropertyName());
        if (xmlAnyElement.getXmlPath() != null) {
            oldProperty.setXmlPath(xmlAnyElement.getXmlPath());
        }
        if (xmlAnyElement.getXmlAccessMethods() != null) {
            oldProperty.setMethodProperty(true);
            oldProperty.setGetMethodName(xmlAnyElement.getXmlAccessMethods().getGetMethod());
            oldProperty.setSetMethodName(xmlAnyElement.getXmlAccessMethods().getSetMethod());
        }
        if (xmlAnyElement.isSetReadOnly()) {
            oldProperty.setReadOnly(xmlAnyElement.isReadOnly());
        }
        if (xmlAnyElement.isSetWriteOnly()) {
            oldProperty.setWriteOnly(xmlAnyElement.isWriteOnly());
        }
        return oldProperty;
    }

    private Property processXmlAttribute(XmlAttribute xmlAttribute, Property oldProperty, TypeInfo typeInfo, NamespaceInfo nsInfo) {
        String namespace;
        String name;
        this.resetProperty(oldProperty, typeInfo);
        if (xmlAttribute.isXmlId()) {
            typeInfo.setIDProperty(oldProperty);
        } else if (oldProperty.isXmlId() && typeInfo.getIDProperty() != null && typeInfo.getIDProperty().getPropertyName().equals(oldProperty.getPropertyName())) {
            typeInfo.setIDProperty(null);
        }
        oldProperty.setIsXmlId(xmlAttribute.isXmlId());
        oldProperty.setIsXmlIdRef(xmlAttribute.isXmlIdref());
        oldProperty.setIsAttribute(true);
        if (xmlAttribute.getXmlJavaTypeAdapter() != null) {
            oldProperty.setXmlJavaTypeAdapter(xmlAttribute.getXmlJavaTypeAdapter());
        }
        if (xmlAttribute.isSetRequired()) {
            oldProperty.setIsRequired(xmlAttribute.isRequired());
        } else if (oldProperty.getActualType().isPrimitive()) {
            oldProperty.setIsRequired(true);
        }
        oldProperty.setisInlineBinaryData(xmlAttribute.isXmlInlineBinaryData());
        if (xmlAttribute.getXmlPath() != null) {
            oldProperty.setXmlPath(xmlAttribute.getXmlPath());
            name = XMLProcessor.getNameFromXPath(xmlAttribute.getXmlPath(), oldProperty.getPropertyName(), true);
            namespace = "##default";
        } else {
            name = xmlAttribute.getName();
            namespace = xmlAttribute.getNamespace();
        }
        if (name.equals("##default")) {
            name = oldProperty.getPropertyName();
        }
        QName qName = namespace.equals("##default") ? (nsInfo.isElementFormQualified() ? new QName(nsInfo.getNamespace(), name) : new QName(name)) : new QName(namespace, name);
        oldProperty.setSchemaName(qName);
        if (xmlAttribute.getXmlMimeType() != null) {
            oldProperty.setMimeType(xmlAttribute.getXmlMimeType());
        }
        if (xmlAttribute.isXmlAttachmentRef()) {
            oldProperty.setIsSwaAttachmentRef(true);
            oldProperty.setSchemaType(XMLConstants.SWA_REF_QNAME);
        }
        if (xmlAttribute.getXmlSchemaType() != null) {
            oldProperty.setSchemaType(new QName(xmlAttribute.getXmlSchemaType().getNamespace(), xmlAttribute.getXmlSchemaType().getName()));
        }
        if (xmlAttribute.getXmlAccessMethods() != null) {
            oldProperty.setMethodProperty(true);
            oldProperty.setGetMethodName(xmlAttribute.getXmlAccessMethods().getGetMethod());
            oldProperty.setSetMethodName(xmlAttribute.getXmlAccessMethods().getSetMethod());
        }
        if (xmlAttribute.isSetReadOnly()) {
            oldProperty.setReadOnly(xmlAttribute.isReadOnly());
        }
        if (xmlAttribute.isSetWriteOnly()) {
            oldProperty.setWriteOnly(xmlAttribute.isWriteOnly());
        }
        if (xmlAttribute.getXmlAbstractNullPolicy() != null) {
            JAXBElement<? extends XmlAbstractNullPolicy> jaxbElt = xmlAttribute.getXmlAbstractNullPolicy();
            oldProperty.setNullPolicy((XmlAbstractNullPolicy)jaxbElt.getValue());
        }
        return oldProperty;
    }

    private Property processXmlElement(XmlElement xmlElement, Property oldProperty, TypeInfo typeInfo, NamespaceInfo nsInfo, JavaType javaType) {
        String namespace;
        String name;
        this.resetProperty(oldProperty, typeInfo);
        if (xmlElement.getXmlMap() != null) {
            this.processXmlMap(xmlElement.getXmlMap(), oldProperty);
        }
        if (xmlElement.isXmlId()) {
            typeInfo.setIDProperty(oldProperty);
        } else if (oldProperty.isXmlId() && typeInfo.getIDProperty() != null && typeInfo.getIDProperty().getPropertyName().equals(oldProperty.getPropertyName())) {
            typeInfo.setIDProperty(null);
        }
        oldProperty.setIsXmlId(xmlElement.isXmlId());
        oldProperty.setIsXmlIdRef(xmlElement.isXmlIdref());
        oldProperty.setIsRequired(xmlElement.isRequired());
        oldProperty.setisInlineBinaryData(xmlElement.isXmlInlineBinaryData());
        oldProperty.setNillable(xmlElement.isNillable());
        if (xmlElement.getDefaultValue().equals("\u0000")) {
            oldProperty.setDefaultValue(null);
        } else {
            oldProperty.setDefaultValue(xmlElement.getDefaultValue());
        }
        if (xmlElement.getXmlPath() != null) {
            oldProperty.setXmlPath(xmlElement.getXmlPath());
            name = XMLProcessor.getNameFromXPath(xmlElement.getXmlPath(), oldProperty.getPropertyName(), false);
            namespace = "##default";
        } else {
            name = xmlElement.getName();
            namespace = xmlElement.getNamespace();
            if (xmlElement.getXmlElementWrapper() != null) {
                oldProperty.setXmlElementWrapper(xmlElement.getXmlElementWrapper());
            }
        }
        if (name.equals("##default")) {
            name = oldProperty.getPropertyName();
        }
        QName qName = namespace.equals("##default") ? (nsInfo.isElementFormQualified() ? new QName(nsInfo.getNamespace(), name) : new QName(name)) : new QName(namespace, name);
        oldProperty.setSchemaName(qName);
        if (xmlElement.getType().equals("javax.xml.bind.annotation.XmlElement.DEFAULT")) {
            if (oldProperty.isXmlElementType()) {
                oldProperty.setType(oldProperty.getOriginalType());
            }
        } else if (xmlElement.getXmlMap() != null) {
            this.getLogger().logWarning("jaxb_metadata_warning_ignoring_type_on_map", new Object[]{xmlElement.getName()});
        } else {
            JavaClass pType = this.jModelInput.getJavaModel().getClass(xmlElement.getType());
            oldProperty.setType(pType);
            if (this.aProcessor.shouldGenerateTypeInfo(pType) && this.aProcessor.getTypeInfo().get(pType.getQualifiedName()) == null) {
                this.aProcessor.buildNewTypeInfo(new JavaClass[]{pType});
            }
        }
        if (xmlElement.getXmlJavaTypeAdapter() != null) {
            try {
                oldProperty.setXmlJavaTypeAdapter(xmlElement.getXmlJavaTypeAdapter());
            }
            catch (JAXBException e) {
                Object[] messageParams = new String[]{xmlElement.getXmlJavaTypeAdapter().getValue(), xmlElement.getJavaAttribute(), javaType.getName()};
                this.getLogger().logWarning("jaxb_metadata_warning_invalid_property_level_xml_java_type_adapter", messageParams);
                oldProperty.setXmlJavaTypeAdapter(null);
            }
        }
        if (!oldProperty.isRequired()) {
            JavaClass ptype = oldProperty.getActualType();
            oldProperty.setIsRequired(ptype.isPrimitive() || ptype.isArray() && ptype.getComponentType().isPrimitive());
        }
        if (xmlElement.isSetXmlList()) {
            if (!this.aProcessor.isCollectionType(oldProperty) && !oldProperty.getType().isArray()) {
                throw JAXBException.invalidList(oldProperty.getPropertyName());
            }
            oldProperty.setIsXmlList(xmlElement.isXmlList());
        }
        if (xmlElement.getXmlMimeType() != null) {
            oldProperty.setMimeType(xmlElement.getXmlMimeType());
        }
        if (xmlElement.isXmlAttachmentRef()) {
            oldProperty.setIsSwaAttachmentRef(true);
            oldProperty.setSchemaType(XMLConstants.SWA_REF_QNAME);
        }
        if (xmlElement.getXmlSchemaType() != null) {
            oldProperty.setSchemaType(new QName(xmlElement.getXmlSchemaType().getNamespace(), xmlElement.getXmlSchemaType().getName()));
        }
        if (xmlElement.getXmlAccessMethods() != null) {
            oldProperty.setMethodProperty(true);
            oldProperty.setGetMethodName(xmlElement.getXmlAccessMethods().getGetMethod());
            oldProperty.setSetMethodName(xmlElement.getXmlAccessMethods().getSetMethod());
        }
        if (xmlElement.isSetReadOnly()) {
            oldProperty.setReadOnly(xmlElement.isReadOnly());
        }
        if (xmlElement.isSetWriteOnly()) {
            oldProperty.setWriteOnly(xmlElement.isWriteOnly());
        }
        if (xmlElement.isSetCdata()) {
            oldProperty.setCdata(xmlElement.isCdata());
        }
        if (xmlElement.getXmlAbstractNullPolicy() != null) {
            JAXBElement<? extends XmlAbstractNullPolicy> jaxbElt = xmlElement.getXmlAbstractNullPolicy();
            oldProperty.setNullPolicy((XmlAbstractNullPolicy)jaxbElt.getValue());
        }
        return oldProperty;
    }

    private Property processXmlMap(XmlMap xmlMap, Property oldProperty) {
        XmlMap.Key mapKey = xmlMap.getKey();
        XmlMap.Value mapValue = xmlMap.getValue();
        if (mapKey != null && mapKey.getType() != null) {
            oldProperty.setKeyType(this.jModelInput.getJavaModel().getClass(mapKey.getType()));
        } else {
            oldProperty.setKeyType(this.jModelInput.getJavaModel().getClass("java.lang.Object"));
        }
        if (mapValue != null && mapValue.getType() != null) {
            oldProperty.setValueType(this.jModelInput.getJavaModel().getClass(mapValue.getType()));
        } else {
            oldProperty.setValueType(this.jModelInput.getJavaModel().getClass("java.lang.Object"));
        }
        return oldProperty;
    }

    private Property processXmlElements(XmlElements xmlElements, Property oldProperty, TypeInfo tInfo) {
        this.resetProperty(oldProperty, tInfo);
        oldProperty.setChoice(true);
        oldProperty.setXmlElements(xmlElements);
        oldProperty.setIsXmlIdRef(xmlElements.isXmlIdref());
        if (xmlElements.getXmlElementWrapper() != null) {
            oldProperty.setXmlElementWrapper(xmlElements.getXmlElementWrapper());
        }
        if (xmlElements.getXmlAccessMethods() != null) {
            oldProperty.setMethodProperty(true);
            oldProperty.setGetMethodName(xmlElements.getXmlAccessMethods().getGetMethod());
            oldProperty.setSetMethodName(xmlElements.getXmlAccessMethods().getSetMethod());
        }
        if (xmlElements.isSetReadOnly()) {
            oldProperty.setReadOnly(xmlElements.isReadOnly());
        }
        if (xmlElements.isSetWriteOnly()) {
            oldProperty.setWriteOnly(xmlElements.isWriteOnly());
        }
        return oldProperty;
    }

    private Property processXmlElementRef(XmlElementRef xmlElementRef, Property oldProperty, TypeInfo info) {
        this.resetProperty(oldProperty, info);
        ArrayList<XmlElementRef> eltRefs = new ArrayList<XmlElementRef>();
        eltRefs.add(xmlElementRef);
        oldProperty.setXmlElementRefs(eltRefs);
        oldProperty.setIsReference(true);
        if (xmlElementRef.getXmlElementWrapper() != null) {
            oldProperty.setXmlElementWrapper(xmlElementRef.getXmlElementWrapper());
        }
        return oldProperty;
    }

    private Property processXmlElementRefs(XmlElementRefs xmlElementRefs, Property oldProperty, TypeInfo info) {
        this.resetProperty(oldProperty, info);
        ArrayList<XmlElementRef> eltRefs = new ArrayList<XmlElementRef>();
        for (XmlElementRef eltRef : xmlElementRefs.getXmlElementRef()) {
            eltRefs.add(eltRef);
        }
        oldProperty.setXmlElementRefs(eltRefs);
        oldProperty.setIsReference(true);
        if (xmlElementRefs.getXmlElementWrapper() != null) {
            oldProperty.setXmlElementWrapper(xmlElementRefs.getXmlElementWrapper());
        }
        return oldProperty;
    }

    private Property processXmlTransient(XmlTransient xmlTransient, Property oldProperty) {
        oldProperty.setTransient(true);
        return oldProperty;
    }

    private Property processXmlValue(XmlValue xmlValue, Property oldProperty, TypeInfo info, JavaType javaType) {
        this.resetProperty(oldProperty, info);
        oldProperty.setIsXmlValue(true);
        info.setXmlValueProperty(oldProperty);
        if (xmlValue.getXmlAccessMethods() != null) {
            oldProperty.setMethodProperty(true);
            oldProperty.setGetMethodName(xmlValue.getXmlAccessMethods().getGetMethod());
            oldProperty.setSetMethodName(xmlValue.getXmlAccessMethods().getSetMethod());
        }
        if (xmlValue.isSetReadOnly()) {
            oldProperty.setReadOnly(xmlValue.isReadOnly());
        }
        if (xmlValue.isSetWriteOnly()) {
            oldProperty.setWriteOnly(xmlValue.isWriteOnly());
        }
        if (xmlValue.isSetCdata()) {
            oldProperty.setCdata(xmlValue.isCdata());
        }
        if (xmlValue.getXmlAbstractNullPolicy() != null) {
            JAXBElement<? extends XmlAbstractNullPolicy> jaxbElt = xmlValue.getXmlAbstractNullPolicy();
            oldProperty.setNullPolicy((XmlAbstractNullPolicy)jaxbElt.getValue());
        }
        return oldProperty;
    }

    private NamespaceInfo processXmlSchema(XmlBindings xmlBindings, String packageName) {
        XmlSchema schema = xmlBindings.getXmlSchema();
        if (schema == null) {
            return null;
        }
        NamespaceInfo nsInfo = new NamespaceInfo();
        XmlNsForm form = schema.getAttributeFormDefault();
        nsInfo.setAttributeFormQualified(form.equals((Object)XmlNsForm.QUALIFIED));
        form = schema.getElementFormDefault();
        nsInfo.setElementFormQualified(form.equals((Object)XmlNsForm.QUALIFIED));
        if (!nsInfo.isElementFormQualified() || nsInfo.isAttributeFormQualified()) {
            this.aProcessor.setDefaultNamespaceAllowed(false);
        }
        nsInfo.setLocation(schema.getLocation() == null ? "##generate" : schema.getLocation());
        String namespace = schema.getNamespace();
        if (namespace == null) {
            namespace = this.aProcessor.getDefaultTargetNamespace();
        }
        nsInfo.setNamespace(namespace == null ? "" : schema.getNamespace());
        NamespaceResolver nsr = new NamespaceResolver();
        for (XmlSchema.XmlNs xmlns : schema.getXmlNs()) {
            nsr.put(xmlns.getPrefix(), xmlns.getNamespaceUri());
        }
        nsInfo.setNamespaceResolver(nsr);
        return nsInfo;
    }

    private Map<String, ArrayList<JavaClass>> buildPackageToJavaClassMap() {
        HashMap<String, ArrayList<JavaClass>> theMap = new HashMap<String, ArrayList<JavaClass>>();
        HashMap xmlBindingsMap = new HashMap();
        for (String packageName : this.xmlBindingMap.keySet()) {
            XmlBindings.XmlEnums xmlEnums;
            XmlBindings xmlBindings = this.xmlBindingMap.get(packageName);
            ArrayList<JavaClass> classes = new ArrayList<JavaClass>();
            XmlBindings.JavaTypes jTypes = xmlBindings.getJavaTypes();
            if (jTypes != null) {
                for (JavaType javaType : jTypes.getJavaType()) {
                    JavaClass nextClass = this.jModelInput.getJavaModel().getClass(javaType.getName());
                    String nextPackageName = nextClass.getPackageName();
                    if (nextPackageName == null || !nextPackageName.equals(packageName)) {
                        throw JAXBException.javaTypeNotAllowedInBindingsFile(nextPackageName, packageName);
                    }
                    classes.add(nextClass);
                }
            }
            if ((xmlEnums = xmlBindings.getXmlEnums()) != null) {
                for (XmlEnum xmlEnum : xmlEnums.getXmlEnum()) {
                    classes.add(this.jModelInput.getJavaModel().getClass(xmlEnum.getJavaEnum()));
                }
            }
            theMap.put(packageName, classes);
            xmlBindingsMap.put(packageName, new ArrayList(classes));
        }
        for (JavaClass jClass : this.jModelInput.getJavaClasses()) {
            String pkg = jClass.getPackageName();
            ArrayList existingXmlBindingsClasses = (ArrayList)xmlBindingsMap.get(pkg);
            ArrayList allExistingClasses = (ArrayList)theMap.get(pkg);
            if (existingXmlBindingsClasses != null) {
                if (this.classExistsInArray(jClass, existingXmlBindingsClasses)) continue;
                allExistingClasses.add(jClass);
                continue;
            }
            if (allExistingClasses != null) {
                allExistingClasses.add(jClass);
                continue;
            }
            ArrayList<JavaClass> classes = new ArrayList<JavaClass>();
            classes.add(jClass);
            theMap.put(pkg, classes);
        }
        return theMap;
    }

    private JAXBMetadataLogger getLogger() {
        if (this.logger == null) {
            this.logger = new JAXBMetadataLogger();
        }
        return this.logger;
    }

    public boolean classExistsInArray(JavaClass theClass, ArrayList<JavaClass> existingClasses) {
        for (JavaClass jClass : existingClasses) {
            if (!this.areClassesEqual(jClass, theClass)) continue;
            return true;
        }
        return false;
    }

    private boolean areClassesEqual(JavaClass classA, JavaClass classB) {
        if (classA == classB) {
            return true;
        }
        if (!classA.getQualifiedName().equals(classB.getQualifiedName())) {
            return false;
        }
        if (classA.getActualTypeArguments() != null) {
            if (classB.getActualTypeArguments() == null) {
                return false;
            }
            if (classA.getActualTypeArguments().size() != classB.getActualTypeArguments().size()) {
                return false;
            }
            for (int i = 0; i < classA.getActualTypeArguments().size(); ++i) {
                JavaClass nestedClassB;
                JavaClass nestedClassA = (JavaClass)classA.getActualTypeArguments().toArray()[i];
                if (this.areClassesEqual(nestedClassA, nestedClassB = (JavaClass)classB.getActualTypeArguments().toArray()[i])) continue;
                return false;
            }
            return true;
        }
        return classB.getActualTypeArguments() == null;
    }

    private Property resetProperty(Property oldProperty, TypeInfo tInfo) {
        oldProperty.setIsAttribute(false);
        oldProperty.setHasXmlElementType(false);
        oldProperty.setIsRequired(false);
        oldProperty.setIsXmlList(false);
        oldProperty.setXmlJavaTypeAdapter(null);
        oldProperty.setInverseReferencePropertyName(null);
        oldProperty.setDefaultValue(null);
        oldProperty.setDomHandlerClassName(null);
        oldProperty.setIsSwaAttachmentRef(false);
        oldProperty.setIsXmlId(false);
        oldProperty.setIsXmlIdRef(false);
        oldProperty.setXmlElementWrapper(null);
        oldProperty.setLax(false);
        oldProperty.setNillable(false);
        oldProperty.setMixedContent(false);
        oldProperty.setMimeType(null);
        oldProperty.setTransient(false);
        oldProperty.setChoice(false);
        oldProperty.setIsReference(false);
        oldProperty.setXmlPath(null);
        this.unsetXmlElementRefs(oldProperty, tInfo);
        this.unsetXmlElements(oldProperty);
        this.unsetXmlAnyAttribute(oldProperty, tInfo);
        this.unsetXmlAnyElement(oldProperty, tInfo);
        this.unsetXmlValue(oldProperty, tInfo);
        return oldProperty;
    }

    private void unsetXmlElementRefs(Property oldProperty, TypeInfo tInfo) {
        if (tInfo.hasElementRefs() && tInfo.getElementRefsPropName().equals(oldProperty.getPropertyName())) {
            tInfo.setElementRefsPropertyName(null);
        }
    }

    private void unsetXmlElements(Property oldProperty) {
        oldProperty.setXmlElements(null);
        oldProperty.setChoiceProperties(null);
    }

    private void unsetXmlAnyAttribute(Property oldProperty, TypeInfo tInfo) {
        oldProperty.setIsAnyAttribute(false);
        if (tInfo.isSetAnyAttributePropertyName() && tInfo.getAnyAttributePropertyName().equals(oldProperty.getPropertyName())) {
            tInfo.setAnyAttributePropertyName(null);
        }
    }

    private void unsetXmlAnyElement(Property oldProperty, TypeInfo tInfo) {
        oldProperty.setIsAny(false);
        if (tInfo.isSetAnyElementPropertyName() && tInfo.getAnyElementPropertyName().equals(oldProperty.getPropertyName())) {
            tInfo.setAnyElementPropertyName(null);
        }
    }

    private void unsetXmlValue(Property oldProperty, TypeInfo tInfo) {
        oldProperty.setIsXmlValue(false);
        if (tInfo.isSetXmlValueProperty() && tInfo.getXmlValueProperty().getPropertyName().equals(oldProperty.getPropertyName())) {
            tInfo.setXmlValueProperty(null);
        }
    }

    public static String getNameFromXPath(String xpath, String propertyName, boolean isAttribute) {
        String name;
        if (xpath.equals(SELF)) {
            return propertyName;
        }
        int idx = xpath.indexOf("/text()");
        String path = idx >= 0 ? xpath.substring(0, idx) : xpath;
        idx = path.lastIndexOf(SLASH);
        if (idx >= 0 && path.length() > 1) {
            name = path.substring(idx + 1);
            StringTokenizer stok = new StringTokenizer(name, COLON);
            if (stok.countTokens() == 2) {
                stok.nextToken();
                name = stok.nextToken();
            }
        } else {
            name = path;
        }
        if (isAttribute) {
            idx = name.indexOf(XMLConstants.ATTRIBUTE.charValue());
            if (idx >= 0 && name.length() > 1) {
                name = name.substring(idx + 1);
            }
        } else {
            idx = name.indexOf(OPEN_BRACKET);
            if (idx != -1) {
                name = name.substring(0, idx);
            }
        }
        return name;
    }
}

