/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.dynamic;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.persistence.jaxb.dynamic.DynamicJAXBContext;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.platform.xml.XMLTransformer;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicJAXBContextFactory {
    public static DynamicJAXBContext createContext(String sessionNames, ClassLoader classLoader, Map<String, ?> properties) throws JAXBException {
        if (sessionNames == null) {
            throw new JAXBException((Throwable)org.eclipse.persistence.exceptions.JAXBException.nullSessionName());
        }
        DynamicJAXBContext dContext = new DynamicJAXBContext();
        dContext.initializeFromSessionsXML(sessionNames, classLoader);
        return dContext;
    }

    public static DynamicJAXBContext createContext(Class<?>[] classes, Map<String, ?> properties) throws JAXBException {
        throw new JAXBException((Throwable)org.eclipse.persistence.exceptions.JAXBException.cannotCreateDynamicContextFromClasses());
    }

    public static DynamicJAXBContext createContextFromXSD(Node schemaDOM, EntityResolver resolver, ClassLoader classLoader, Map<String, ?> properties) throws JAXBException {
        if (schemaDOM == null) {
            throw new JAXBException((Throwable)org.eclipse.persistence.exceptions.JAXBException.nullNode());
        }
        DynamicJAXBContext dContext = new DynamicJAXBContext();
        dContext.initializeFromXSDNode(schemaDOM, classLoader, resolver, properties);
        return dContext;
    }

    public static DynamicJAXBContext createContextFromXSD(InputStream schemaStream, EntityResolver resolver, ClassLoader classLoader, Map<String, ?> properties) throws JAXBException {
        if (schemaStream == null) {
            throw new JAXBException((Throwable)org.eclipse.persistence.exceptions.JAXBException.nullInputStream());
        }
        InputSource schemaSource = new InputSource(schemaStream);
        DynamicJAXBContext dContext = new DynamicJAXBContext();
        dContext.initializeFromXSDInputSource(schemaSource, classLoader, resolver, properties);
        return dContext;
    }

    public static DynamicJAXBContext createContextFromXSD(Source schemaSource, EntityResolver resolver, ClassLoader classLoader, Map<String, ?> properties) throws JAXBException {
        if (schemaSource == null) {
            throw new JAXBException((Throwable)org.eclipse.persistence.exceptions.JAXBException.nullSource());
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(baos);
        XMLTransformer t = XMLPlatformFactory.getInstance().getXMLPlatform().newXMLTransformer();
        t.transform(schemaSource, (Result)result);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        InputSource schemaInputSource = new InputSource(bais);
        schemaInputSource.setSystemId(schemaSource.getSystemId());
        DynamicJAXBContext dContext = new DynamicJAXBContext();
        dContext.initializeFromXSDInputSource(schemaInputSource, classLoader, resolver, properties);
        return dContext;
    }
}

