/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.eclipse.compiler;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilationContext {
    private File sourceDirectory;
    private File outputDirectory;
    private List<String> sources;
    private String encoding;
    private ClassLoader contextualClassLoader;
    private CompilerOptions compilerOptions;

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public void setSourceDirectory(File sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public List<String> getSources() {
        if (this.sources == null) {
            this.sources = new ArrayList<String>();
        }
        return this.sources;
    }

    public void setSources(List<String> sources) {
        this.sources = sources;
    }

    public String getEncoding() {
        if (this.encoding == null) {
            this.encoding = "UTF-8";
        }
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public ClassLoader getContextualClassLoader() {
        if (this.contextualClassLoader == null) {
            this.contextualClassLoader = Thread.currentThread().getContextClassLoader();
        }
        return this.contextualClassLoader;
    }

    public void setContextualClassLoader(ClassLoader contextualClassLoader) {
        this.contextualClassLoader = contextualClassLoader;
    }

    public CompilerOptions getCompilerOptions() {
        if (this.compilerOptions == null) {
            this.compilerOptions = this.getDefaultOptions();
        }
        return this.compilerOptions;
    }

    public void setCompilerOptions(CompilerOptions compilerOptions) {
        this.compilerOptions = compilerOptions;
    }

    public String getAbsolutePath(String filename) {
        File path = new File(this.sourceDirectory, filename);
        return path.getAbsolutePath();
    }

    private CompilerOptions getDefaultOptions() {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
        settings.put("org.eclipse.jdt.core.compiler.source", "1.5");
        settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        settings.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        settings.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
        settings.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
        CompilerOptions options = new CompilerOptions();
        options.set(settings);
        return options;
    }
}

