/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.eclipse.compiler;

import org.eclipse.jdt.core.compiler.IProblem;

public class CompilerError {
    private String message;
    private Exception cause;
    private IProblem problem;

    public CompilerError(String message, Exception exception) {
        this.message = message;
        this.cause = exception;
    }

    public CompilerError(String message, IProblem problem) {
        this.message = message;
        this.problem = problem;
    }

    public String toString() {
        if (this.cause != null) {
            return this.message + ": " + this.cause.toString();
        }
        if (this.problem != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.problem.getOriginatingFileName());
            sb.append("[" + this.problem.getSourceLineNumber() + "]");
            sb.append("\n");
            sb.append(this.problem.getMessage());
            sb.append("[" + this.problem.getSourceStart());
            sb.append("," + this.problem.getSourceEnd());
            sb.append("]\n");
            String[] args = this.problem.getArguments();
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                sb.append("[" + i + "] ");
                sb.append(arg);
                sb.append("\n");
            }
            return sb.toString();
        }
        return this.message;
    }
}

