/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.eclipse.compiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.ow2.jonas.eclipse.compiler.CompilerError;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JOnASCompilerRequestor
implements ICompilerRequestor {
    private static final Log log = LogFactory.getLog(JOnASCompilerRequestor.class);
    private File outputDirectory;
    private List<CompilerError> errors;

    public JOnASCompilerRequestor(File outputDirectory, List<CompilerError> errors) {
        this.outputDirectory = outputDirectory;
        this.errors = errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acceptResult(CompilationResult result) {
        if (result.hasErrors()) {
            CategorizedProblem[] problems = result.getErrors();
            for (int i = 0; i < problems.length; ++i) {
                CategorizedProblem problem = problems[i];
                String name = new String(problems[i].getOriginatingFileName());
                this.errors.add(new CompilerError(name, problem));
            }
        } else {
            ClassFile[] classFiles = result.getClassFiles();
            for (int i = 0; i < classFiles.length; ++i) {
                ClassFile classFile = classFiles[i];
                String className = new String(CharOperation.concatWith(classFile.getCompoundName(), '.'));
                byte[] bytes = classFile.getBytes();
                log.debug((Object)"Storing class: {0}", new Object[]{className});
                File outFile = new File(this.outputDirectory, className.replace('.', File.separatorChar) + ".class");
                if (!outFile.getParentFile().exists()) {
                    outFile.getParentFile().mkdirs();
                }
                FileOutputStream fout = null;
                try {
                    fout = new FileOutputStream(outFile);
                    fout.write(bytes);
                    fout.flush();
                    continue;
                }
                catch (FileNotFoundException e) {
                    this.errors.add(new CompilerError(className, e));
                    continue;
                }
                catch (IOException e) {
                    this.errors.add(new CompilerError(className, e));
                    continue;
                }
                finally {
                    if (fout != null) {
                        try {
                            fout.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }
    }
}

