/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.io.IOException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.Messages;
import org.jacorb.orb.giop.ReplyOutputStream;
import org.jacorb.orb.giop.RequestListener;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INV_POLICY;
import org.omg.GIOP.ReplyStatusType_1_2;

public class NoBiDirClientRequestListener
implements RequestListener {
    private Logger logger;

    public NoBiDirClientRequestListener(Logger logger) {
        this.logger = logger;
    }

    public void requestReceived(byte[] byArray, GIOPConnection gIOPConnection) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("Received a request on a non-bidir connection");
        }
        gIOPConnection.incPendingMessages();
        this.replyException(byArray, gIOPConnection);
    }

    public void locateRequestReceived(byte[] byArray, GIOPConnection gIOPConnection) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("Received a locate request on a non-bidir connection");
        }
        gIOPConnection.incPendingMessages();
        this.replyException(byArray, gIOPConnection);
    }

    public void cancelRequestReceived(byte[] byArray, GIOPConnection gIOPConnection) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("Received a cancel request on a non-bidir connection");
        }
        gIOPConnection.incPendingMessages();
        this.replyException(byArray, gIOPConnection);
    }

    private void replyException(byte[] byArray, GIOPConnection gIOPConnection) {
        block2: {
            int n = Messages.getGIOPMinor(byArray);
            ReplyOutputStream replyOutputStream = new ReplyOutputStream(Messages.getRequestId(byArray), ReplyStatusType_1_2.SYSTEM_EXCEPTION, n, false, this.logger);
            SystemExceptionHelper.write(replyOutputStream, new INV_POLICY(0, CompletionStatus.COMPLETED_NO));
            try {
                gIOPConnection.sendReply(replyOutputStream);
            }
            catch (IOException iOException) {
                if (!this.logger.isErrorEnabled()) break block2;
                this.logger.error("Exception", iOException);
            }
        }
    }
}

