/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.util.List;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.TaggedComponentList;
import org.jacorb.orb.etf.ProfileBase;
import org.jacorb.orb.etf.ProtocolAddressBase;
import org.jacorb.orb.iiop.IIOPAddress;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.TLS_SEC_TRANS;
import org.omg.CSIIOP.TLS_SEC_TRANSHelper;
import org.omg.ETF.Profile;
import org.omg.GIOP.Version;
import org.omg.GIOP.VersionHelper;
import org.omg.IOP.TaggedComponent;
import org.omg.SSLIOP.SSL;
import org.omg.SSLIOP.SSLHelper;

public class IIOPProfile
extends ProfileBase {
    private IIOPAddress primaryAddress = null;
    private Logger logger;
    static /* synthetic */ Class class$org$jacorb$orb$iiop$IIOPAddress;
    static /* synthetic */ Class class$org$omg$SSLIOP$SSLHelper;
    static /* synthetic */ Class class$org$omg$CSIIOP$CompoundSecMechListHelper;

    public IIOPProfile() {
    }

    public IIOPProfile(byte[] byArray) {
        this.initFromProfileData(byArray);
    }

    public IIOPProfile(IIOPAddress iIOPAddress, byte[] byArray) {
        this.version = new Version(1, 2);
        this.primaryAddress = iIOPAddress;
        this.objectKey = byArray;
        this.components = new TaggedComponentList();
    }

    public IIOPProfile(IIOPAddress iIOPAddress, byte[] byArray, int n) {
        this.version = new Version(1, (byte)n);
        this.primaryAddress = iIOPAddress;
        this.objectKey = byArray;
        this.components = new TaggedComponentList();
    }

    public IIOPProfile(String string) {
        this.version = null;
        this.primaryAddress = null;
        this.objectKey = null;
        this.components = null;
        this.corbalocStr = string;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = (org.jacorb.config.Configuration)configuration;
        this.logger = this.configuration.getNamedLogger("jacorb.iiop.profile");
        if (this.primaryAddress != null) {
            this.primaryAddress.configure(configuration);
        }
        if (this.corbalocStr != null) {
            try {
                this.decode_corbaloc(this.corbalocStr);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void decode_corbaloc(String string) {
        String string2;
        block11: {
            String string3 = "127.0.0.1";
            int n = 2809;
            int n2 = 1;
            int n3 = 2;
            String string4 = "Illegal IIOP protocol format in object address format: " + string;
            int n4 = string.indexOf(58);
            string2 = "";
            if (n4 != 0) {
                string2 = string.substring(0, n4);
            }
            if (n4 + 1 == string.length()) {
                throw new IllegalArgumentException(string4);
            }
            if ((n4 = (string = string.substring(n4 + 1)).indexOf(64)) > -1) {
                String string5 = string.substring(0, n4);
                string = string.substring(n4 + 1);
                n4 = string5.indexOf(46);
                if (n4 != -1) {
                    try {
                        n2 = Integer.parseInt(string5.substring(0, n4));
                        n3 = Integer.parseInt(string5.substring(n4 + 1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException(string4);
                    }
                }
            }
            this.version = new Version((byte)n2, (byte)n3);
            n4 = string.indexOf(58);
            if (n4 != -1) {
                try {
                    n = (short)Integer.parseInt(string.substring(n4 + 1));
                    string3 = string.substring(0, n4);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(string4);
                }
            }
            this.primaryAddress = new IIOPAddress(string3, n);
            try {
                this.primaryAddress.configure(this.configuration);
            }
            catch (ConfigurationException configurationException) {
                if (!this.logger.isWarnEnabled()) break block11;
                this.logger.warn("ConfigurationException", configurationException);
            }
        }
        this.decode_extensions(string2.toLowerCase());
    }

    private void decode_extensions(String string) {
        this.components = new TaggedComponentList();
        if (string.equals("ssliop")) {
            SSL sSL = new SSL();
            sSL.port = (short)this.primaryAddress.getPort();
            String string2 = "jacorb.security.ssl.corbaloc_ssliop.supported_options";
            sSL.target_supports = this.get_ssl_options(string2);
            string2 = "jacorb.security.ssl.corbaloc_ssliop.required_options";
            sSL.target_requires = this.get_ssl_options(string2);
            CDROutputStream cDROutputStream = new CDROutputStream();
            cDROutputStream.beginEncapsulatedArray();
            SSLHelper.write(cDROutputStream, sSL);
            this.components.addComponent(new TaggedComponent(20, cDROutputStream.getBufferCopy()));
        }
    }

    private short get_ssl_options(String string) {
        short s = (short)this.configuration.getAttributeAsInteger(string, 32);
        return s;
    }

    public void writeAddressProfile(CDROutputStream cDROutputStream) {
        VersionHelper.write(cDROutputStream, this.version);
        this.primaryAddress.write(cDROutputStream);
    }

    public void readAddressProfile(CDRInputStream cDRInputStream) {
        block3: {
            this.version = VersionHelper.read(cDRInputStream);
            this.primaryAddress = IIOPAddress.read(cDRInputStream);
            if (this.configuration != null) {
                try {
                    this.primaryAddress.configure(this.configuration);
                }
                catch (ConfigurationException configurationException) {
                    if (!this.logger.isWarnEnabled()) break block3;
                    this.logger.warn("ConfigurationException", configurationException);
                }
            }
        }
    }

    public int hash() {
        return this.hashCode();
    }

    public Object clone() throws CloneNotSupportedException {
        IIOPProfile iIOPProfile = (IIOPProfile)super.clone();
        iIOPProfile.primaryAddress = new IIOPAddress(this.primaryAddress.getHostname(), this.primaryAddress.getPort());
        iIOPProfile.version = new Version(this.version.major, this.version.minor);
        if (this.objectKey != null) {
            iIOPProfile.objectKey = new byte[this.objectKey.length];
            System.arraycopy(this.objectKey, 0, iIOPProfile.objectKey, 0, this.objectKey.length);
        }
        if (this.components != null) {
            iIOPProfile.components = (TaggedComponentList)this.components.clone();
        }
        return iIOPProfile;
    }

    public boolean is_match(Profile profile) {
        if (profile instanceof IIOPProfile) {
            IIOPProfile iIOPProfile = (IIOPProfile)profile;
            return this.primaryAddress.equals(iIOPProfile.primaryAddress) && ((Object)this.getAlternateAddresses()).equals(iIOPProfile.getAlternateAddresses()) && this.getSSLPort() == iIOPProfile.getSSLPort();
        }
        return false;
    }

    public int tag() {
        return 0;
    }

    public ProtocolAddressBase getAddress() {
        return this.primaryAddress;
    }

    public void patchPrimaryAddress(ProtocolAddressBase protocolAddressBase) {
        if (protocolAddressBase instanceof IIOPAddress) {
            this.primaryAddress.replaceFrom((IIOPAddress)protocolAddressBase);
        }
    }

    public List getAlternateAddresses() {
        return this.components.getComponents(3, class$org$jacorb$orb$iiop$IIOPAddress == null ? (class$org$jacorb$orb$iiop$IIOPAddress = IIOPProfile.class$("org.jacorb.orb.iiop.IIOPAddress")) : class$org$jacorb$orb$iiop$IIOPAddress);
    }

    public SSL getSSL() {
        return (SSL)this.components.getComponent(20, class$org$omg$SSLIOP$SSLHelper == null ? (class$org$omg$SSLIOP$SSLHelper = IIOPProfile.class$("org.omg.SSLIOP.SSLHelper")) : class$org$omg$SSLIOP$SSLHelper);
    }

    public int getTLSPortFromCSIComponent() {
        CompoundSecMechList compoundSecMechList = (CompoundSecMechList)this.components.getComponent(33, class$org$omg$CSIIOP$CompoundSecMechListHelper == null ? (class$org$omg$CSIIOP$CompoundSecMechListHelper = IIOPProfile.class$("org.omg.CSIIOP.CompoundSecMechListHelper")) : class$org$omg$CSIIOP$CompoundSecMechListHelper);
        if (compoundSecMechList != null && compoundSecMechList.mechanism_list.length > 0) {
            byte[] byArray = compoundSecMechList.mechanism_list[0].transport_mech.component_data;
            CDRInputStream cDRInputStream = new CDRInputStream(null, byArray);
            try {
                int n;
                cDRInputStream.openEncapsulatedArray();
                TLS_SEC_TRANS tLS_SEC_TRANS = TLS_SEC_TRANSHelper.read(cDRInputStream);
                if (tLS_SEC_TRANS.addresses.length > 0 && (n = tLS_SEC_TRANS.addresses[0].port) != 0) {
                    if (n < 0) {
                        n += 65536;
                    }
                    return n;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }

    public int getSSLPort() {
        SSL sSL = this.getSSL();
        if (sSL == null) {
            return this.getTLSPortFromCSIComponent();
        }
        int n = sSL.port;
        if (n < 0) {
            n += 65536;
        }
        return n;
    }

    public IIOPProfile to_GIOP_1_0() {
        IIOPProfile iIOPProfile = new IIOPProfile(this.primaryAddress, this.objectKey);
        iIOPProfile.version.minor = 0;
        return iIOPProfile;
    }

    public boolean equals(Object object) {
        if (object instanceof Profile) {
            return this.is_match((Profile)object);
        }
        return false;
    }

    public int hashCode() {
        return this.primaryAddress.hashCode();
    }

    public String toString() {
        return this.primaryAddress.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

