/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.util;

import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.jacorb.orb.ORB;
import org.jacorb.orb.iiop.IIOPProfile;
import org.omg.ETF.Factories;
import org.omg.ETF.Profile;

public class CorbaLoc {
    private ORB orb;
    private String keyString;
    private byte[] key;
    private String bodyString;
    private boolean is_rir;
    public Profile[] profileList;

    public CorbaLoc(ORB oRB, String string) {
        this.orb = oRB;
        this.is_rir = false;
        this.parse(string);
    }

    public boolean rir() {
        return this.is_rir;
    }

    public String toString() {
        return "corbaloc:" + this.body();
    }

    public String body() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.bodyString);
        if (this.keyString != null) {
            stringBuffer.append("/" + this.keyString);
        }
        return stringBuffer.toString();
    }

    public String getKeyString() {
        return this.keyString;
    }

    public byte[] getKey() {
        return this.key;
    }

    public void defaultKeyString(String string) {
        if (this.keyString != null) {
            throw new RuntimeException("KeyString not empty, cannot default to " + string);
        }
        this.keyString = string;
    }

    public String toCorbaName(String string) {
        if (this.getKeyString() == null) {
            this.defaultKeyString("NameService");
        }
        if (string != null && string.length() > 0) {
            try {
                return "corbaname:" + this.body() + "#" + string;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return "corbaname:" + this.body();
    }

    private void parse(String string) {
        String string2;
        if (string == null || !string.startsWith("corbaloc:")) {
            throw new IllegalArgumentException("URL must start with 'corbaloc:'");
        }
        if (string.indexOf(47) == -1) {
            string2 = string.substring(string.indexOf(58) + 1);
            if (string.startsWith("corbaloc:rir:")) {
                this.is_rir = true;
                this.keyString = "NameService";
            } else {
                this.keyString = null;
            }
            this.key = new byte[0];
        } else {
            string2 = string.substring(string.indexOf(58) + 1, string.indexOf(47));
            this.keyString = string.substring(string.indexOf(47) + 1);
            this.key = CorbaLoc.parseKey(this.keyString);
        }
        if (string2.indexOf(44) > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            this.profileList = new Profile[stringTokenizer.countTokens()];
            int n = 0;
            for (int i = 0; i < this.profileList.length; ++i) {
                Profile profile = this.parseAddress(stringTokenizer.nextToken());
                if (profile == null) continue;
                this.profileList[n] = profile;
                ++n;
            }
            while (n < this.profileList.length) {
                this.profileList[n] = null;
                ++n;
            }
        } else {
            this.profileList = new Profile[]{this.parseAddress(string2)};
        }
        this.bodyString = string2;
    }

    private Profile parseAddress(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            throw new IllegalArgumentException("Illegal object address format: " + string);
        }
        if (string.equals("rir:")) {
            this.is_rir = true;
            return null;
        }
        Profile profile = null;
        if (this.orb == null && (n == 0 || string.startsWith("iiop:") || string.startsWith("ssliop:"))) {
            profile = new IIOPProfile(string);
        } else if (this.orb != null) {
            String string2 = string.substring(0, n);
            List list = this.orb.getTransportManager().getFactoriesList();
            Iterator iterator = list.iterator();
            while (profile == null && iterator.hasNext()) {
                Factories factories = (Factories)iterator.next();
                profile = factories.decode_corbaloc(string);
            }
        }
        if (profile == null) {
            throw new IllegalArgumentException("Unknown protocol in object address format: " + string);
        }
        return profile;
    }

    private static boolean legalChar(char c) {
        if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
            return true;
        }
        return c == ';' || c == '/' || c == ':' || c == '?' || c == '@' || c == '&' || c == '=' || c == '+' || c == '$' || c == ',' || c == '_' || c == '.' || c == '!' || c == '~' || c == '*' || c == '\'' || c == '-' || c == '(' || c == ')';
    }

    private static byte hexValue(char c) {
        return (byte)(c >= 'a' ? 10 + c - 97 : (c >= 'A' ? 10 + c - 65 : c - 48));
    }

    private static char hexDigit(byte by) {
        if ((by & 0xF0) != 0) {
            throw new IllegalArgumentException("Hex digit out of range " + by);
        }
        return (char)(by < 10 ? 48 + (char)by : 65 + (char)by - 10);
    }

    private static boolean isHex(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    public static byte[] parseKey(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < cArray.length; ++i) {
            if (CorbaLoc.legalChar(cArray[i])) continue;
            if (cArray[i] == '%') {
                if (CorbaLoc.isHex(cArray[i + 1]) && CorbaLoc.isHex(cArray[i + 2])) {
                    n -= 2;
                    i += 2;
                    continue;
                }
                throw new IllegalArgumentException("Illegal escape in URL character");
            }
            throw new IllegalArgumentException("URL character out of range: " + cArray[i]);
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (CorbaLoc.legalChar(cArray[n2])) {
                byArray[i] = (byte)cArray[n2++];
                continue;
            }
            byArray[i] = (byte)(CorbaLoc.hexValue(cArray[n2 + 1]) << 4 | CorbaLoc.hexValue(cArray[n2 + 2]));
            n2 += 3;
        }
        return byArray;
    }

    public static String parseKey(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            if (!CorbaLoc.legalChar((char)byArray[i])) {
                stringBuffer.append('%');
                stringBuffer.append(CorbaLoc.hexDigit((byte)((byArray[i] & 0xFF) >> 4)));
                stringBuffer.append(CorbaLoc.hexDigit((byte)(byArray[i] & 0xF)));
                continue;
            }
            stringBuffer.append((char)byArray[i]);
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{};
        ORB oRB = (ORB)ORB.init(stringArray2, null);
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println(new CorbaLoc(oRB, stringArray[i]).toString());
        }
    }
}

