/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.db.simple.types;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.jacorb.trading.db.simple.types.Incarnation;
import org.jacorb.trading.db.simple.types.TypeProperty;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.IncarnationNumber;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.PropStruct;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.TypeStruct;

public class Type
implements Serializable {
    private String m_name;
    private String m_interfaceName;
    private Vector m_properties;
    private String[] m_superTypes;
    private Incarnation m_incarnation;
    private boolean m_masked;
    private transient TypeStruct m_description;
    static final long serialVersionUID = -4144073280876434847L;

    public Type() {
    }

    public Type(String string, String string2, PropStruct[] propStructArray, String[] stringArray, IncarnationNumber incarnationNumber) {
        int n;
        this.m_name = string;
        this.m_interfaceName = string2;
        this.m_incarnation = new Incarnation(incarnationNumber);
        this.m_masked = false;
        this.m_superTypes = new String[stringArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            this.m_superTypes[n] = stringArray[n];
        }
        this.m_properties = new Vector();
        for (n = 0; n < propStructArray.length; ++n) {
            TypeProperty typeProperty = new TypeProperty(propStructArray[n]);
            this.m_properties.addElement(typeProperty);
        }
        this.createDescription();
    }

    public TypeStruct describe() {
        return this.m_description;
    }

    public PropStruct getPropertyInfo(String string) {
        PropStruct propStruct = null;
        for (int i = 0; i < this.m_description.props.length && propStruct == null; ++i) {
            if (!string.equals(this.m_description.props[i].name)) continue;
            propStruct = this.m_description.props[i];
        }
        return propStruct;
    }

    public String getName() {
        return this.m_name;
    }

    public String getInterfaceName() {
        return this.m_interfaceName;
    }

    public boolean getMasked() {
        return this.m_masked;
    }

    public String[] getSuperTypes() {
        return this.m_description.super_types;
    }

    public void mask() {
        this.m_masked = true;
        this.m_description.masked = true;
    }

    public void unmask() {
        this.m_masked = false;
        this.m_description.masked = false;
    }

    public Incarnation getIncarnation() {
        return this.m_incarnation;
    }

    public int hashCode() {
        return this.m_name.hashCode();
    }

    public boolean equals(Object object) {
        Type type = (Type)object;
        return this.m_name.equals(type.getName());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.createDescription();
    }

    private void createDescription() {
        this.m_description = new TypeStruct();
        this.m_description.if_name = this.m_interfaceName;
        this.m_description.masked = this.m_masked;
        this.m_description.incarnation = this.m_incarnation.getIncarnationNumber();
        this.m_description.props = new PropStruct[this.m_properties.size()];
        int n = 0;
        Enumeration enumeration = this.m_properties.elements();
        while (enumeration.hasMoreElements()) {
            TypeProperty typeProperty = (TypeProperty)enumeration.nextElement();
            this.m_description.props[n] = typeProperty.describe();
            ++n;
        }
        this.m_description.super_types = new String[this.m_superTypes.length];
        for (int i = 0; i < this.m_superTypes.length; ++i) {
            this.m_description.super_types[i] = this.m_superTypes[i];
        }
    }
}

