/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.cmi.internal;

import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.ow2.cmi.osgi.ILoadBalancingService;
import org.ow2.jonas.cmi.internal.CmiServiceException;
import org.ow2.jonas.cmi.internal.CmiServicePolicyStrategyManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class LoadBalancingListener
implements ServiceListener {
    private static final Log LOGGER = LogFactory.getLog(LoadBalancingListener.class);
    private CmiServicePolicyStrategyManager policyStrategyManager = null;

    public LoadBalancingListener() {
    }

    public LoadBalancingListener(CmiServicePolicyStrategyManager cmiPolicyStrategyManager) {
        this.policyStrategyManager = cmiPolicyStrategyManager;
    }

    public void serviceChanged(ServiceEvent arg0) {
        ServiceReference srvRef = arg0.getServiceReference();
        String location = srvRef.getBundle().getLocation();
        switch (arg0.getType()) {
            case 1: {
                ILoadBalancingService loadBalancingService = (ILoadBalancingService)srvRef.getBundle().getBundleContext().getService(srvRef);
                LOGGER.debug((Object)"Sending new load balancing archive '{0}' step 1: handling new archive registration.", new Object[]{location});
                try {
                    this.policyStrategyManager.addPolicyStrategyBundle(location, loadBalancingService.getPolicies(), loadBalancingService.getStrategies());
                }
                catch (CmiServiceException e) {
                    LOGGER.error((Object)"Unable to load archive for load balacing policies/strategies located at {0} because: {1}", new Object[]{location, e});
                }
                break;
            }
            case 2: {
                LOGGER.debug((Object)"Registering modifications for load balacing policies/strategies archive located at: {0}", new Object[]{location});
                break;
            }
            case 4: {
                LOGGER.debug((Object)"Unregistering load balacing policies/strategies archive located on: {0}", new Object[]{location});
                try {
                    this.policyStrategyManager.removePolicyStrategyBundle(srvRef.getBundle().getLocation());
                    break;
                }
                catch (Exception e) {
                    LOGGER.error((Object)("Unable to unload archive for load balacing policies/strategies located at '" + location + "' because " + e), new Object[0]);
                }
            }
        }
    }
}

