/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.pool.impl.enhanced;

import java.util.concurrent.Executor;
import javax.resource.spi.work.WorkManager;
import org.ow2.util.pool.impl.enhanced.api.IPool;
import org.ow2.util.pool.impl.enhanced.api.thread.IReusableThread;
import org.ow2.util.pool.impl.enhanced.impl.basic.BasicPool;
import org.ow2.util.pool.impl.enhanced.impl.basic.accessmanager.LastUsedAccessManager;
import org.ow2.util.pool.impl.enhanced.impl.thread.managementthread.ManagementThreadReusableThreadFactory;
import org.ow2.util.pool.impl.enhanced.impl.thread.threadpoolexecutor.ExecutorReusableThreadFactory;
import org.ow2.util.pool.impl.enhanced.impl.thread.workmanager.WorkManagerReusableThreadFactory;
import org.ow2.util.pool.impl.enhanced.impl.util.ExecutorProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReusableThreadPoolFactory {
    private ReusableThreadPoolFactory() {
    }

    public static IPool<IReusableThread> createManagementThreadPool(int poolSize) {
        return new BasicPool<IReusableThread>(new ManagementThreadReusableThreadFactory(true), poolSize, new LastUsedAccessManager(), ExecutorProvider.SELF_THREAD_EXECUTOR, null, null);
    }

    public static IPool<IReusableThread> createWorkManagerThreadPool(WorkManager workManager, int limit) {
        return new BasicPool<IReusableThread>(new WorkManagerReusableThreadFactory(workManager), limit, new LastUsedAccessManager(), ExecutorProvider.SELF_THREAD_EXECUTOR, null, null);
    }

    public static IPool<IReusableThread> createExecutorThreadPool(Executor executor, int limit) {
        return new BasicPool<IReusableThread>(new ExecutorReusableThreadFactory(executor), limit, new LastUsedAccessManager(), ExecutorProvider.SELF_THREAD_EXECUTOR, null, null);
    }
}

