/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.pool.impl.enhanced.impl.basic.accessmanager.clue;

import java.util.List;
import org.ow2.util.pool.impl.enhanced.api.basic.clue.accessmanager.IClueAccessManager;
import org.ow2.util.pool.impl.enhanced.api.clue.IClueManager;
import org.ow2.util.pool.impl.enhanced.impl.basic.accessmanager.RoundAccessManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoundClueAccessManager<E, C>
extends RoundAccessManager<E>
implements IClueAccessManager<E, C> {
    private IClueManager<E, C> clueManager;

    public RoundClueAccessManager(IClueManager<E, C> clueManager) {
        this.clueManager = clueManager;
    }

    @Override
    public int choosePoolItemToGet(List<? extends E> poolItemList, C clue) {
        int size = poolItemList.size();
        for (int index = 0; index < size; ++index) {
            if (!this.clueManager.tryMatch(poolItemList.get(index), clue)) continue;
            return index;
        }
        return -1;
    }

    @Override
    public void removePoolItem(E poolItem) {
        super.removePoolItem(poolItem);
        this.clueManager.unMatch(poolItem);
    }

    @Override
    public int putPoolItem(List<? extends E> poolItemList, E poolItem) {
        int pos = super.putPoolItem(poolItemList, poolItem);
        this.clueManager.unMatch(poolItem);
        return pos;
    }
}

