/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.pool.impl.enhanced.impl.listener.clue;

import java.util.ArrayList;
import java.util.List;
import org.ow2.util.pool.impl.enhanced.api.IWaitControl;
import org.ow2.util.pool.impl.enhanced.api.PoolException;
import org.ow2.util.pool.impl.enhanced.api.clue.ICluePool;
import org.ow2.util.pool.impl.enhanced.api.listener.clue.ICluePoolListener;
import org.ow2.util.pool.impl.enhanced.impl.listener.PoolListenerDispatcherPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CluePoolListenerDispatcherPool<E, C>
extends PoolListenerDispatcherPool<E>
implements ICluePool<E, C> {
    private ICluePool<E, C> cluePool;
    private List<ICluePoolListener<E, C>> cluePoolListenerList;

    public CluePoolListenerDispatcherPool(ICluePool<E, C> cluePool) {
        super(cluePool);
        this.cluePool = cluePool;
        this.cluePoolListenerList = new ArrayList<ICluePoolListener<E, C>>();
    }

    @Override
    public E get(C clue, IWaitControl timeout) throws PoolException, InterruptedException {
        for (ICluePoolListener<E, C> poolListener : this.cluePoolListenerList) {
            poolListener.getMethodCalled(clue, timeout);
        }
        try {
            E result = this.cluePool.get(clue, timeout);
            for (ICluePoolListener<E, C> poolListener : this.cluePoolListenerList) {
                poolListener.getMethodReturned(result, clue, timeout);
            }
            return result;
        }
        catch (PoolException poolException) {
            for (ICluePoolListener<E, C> poolListener : this.cluePoolListenerList) {
                poolListener.getMethodFailed(poolException, clue, timeout);
            }
            throw poolException;
        }
    }

    public void addCluePoolListener(ICluePoolListener<E, C> poolListener) {
        this.cluePoolListenerList.add(poolListener);
        this.addPoolListener(poolListener);
    }

    public void removeCluePoolListener(ICluePoolListener<E, C> poolListener) {
        this.cluePoolListenerList.remove(poolListener);
        this.removePoolListener(poolListener);
    }
}

