/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.analysis.EnglishPorterFilter;
import org.apache.solr.core.Config;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnglishPorterFilterFactory
extends BaseTokenFilterFactory {
    private Set protectedWords = null;

    @Override
    public void init(Map<String, String> args) {
        super.init(args);
        String wordFile = args.get("protected");
        if (wordFile != null) {
            try {
                List<String> wlist = Config.getLines(wordFile);
                this.protectedWords = StopFilter.makeStopSet(wlist.toArray(new String[0]));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new EnglishPorterFilter(input, this.protectedWords);
    }
}

