/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.hibernate.EntityMode;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.RowSelection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.TypedValue;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.Type;
import org.hibernate.util.CollectionHelper;
import org.hibernate.util.EqualsHelper;

public class QueryKey
implements Serializable {
    private final String sqlQueryString;
    private final Type[] positionalParameterTypes;
    private final Object[] positionalParameterValues;
    private final Map namedParameters;
    private final Integer firstRow;
    private final Integer maxRows;
    private final EntityMode entityMode;
    private final Set filterKeys;
    private final ResultTransformer customTransformer;
    private transient int hashCode;

    public static QueryKey generateQueryKey(String queryString, QueryParameters queryParameters, Set filterKeys, SessionImplementor session, ResultTransformer customTransformer) {
        Integer maxRows;
        Integer firstRow;
        Map namedParameters;
        int positionalParameterCount = queryParameters.getPositionalParameterTypes().length;
        Type[] types = new Type[positionalParameterCount];
        Object[] values = new Object[positionalParameterCount];
        for (int i = 0; i < positionalParameterCount; ++i) {
            types[i] = queryParameters.getPositionalParameterTypes()[i];
            values[i] = types[i].disassemble(queryParameters.getPositionalParameterValues()[i], session, null);
        }
        if (queryParameters.getNamedParameters() == null) {
            namedParameters = null;
        } else {
            namedParameters = CollectionHelper.mapOfSize(queryParameters.getNamedParameters().size());
            Iterator itr = queryParameters.getNamedParameters().entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry namedParameterEntry = itr.next();
                TypedValue original = (TypedValue)namedParameterEntry.getValue();
                namedParameters.put(namedParameterEntry.getKey(), new TypedValue(original.getType(), original.getType().disassemble(original.getValue(), session, null), session.getEntityMode()));
            }
        }
        RowSelection selection = queryParameters.getRowSelection();
        if (selection != null) {
            firstRow = selection.getFirstRow();
            maxRows = selection.getMaxRows();
        } else {
            firstRow = null;
            maxRows = null;
        }
        return new QueryKey(queryString, types, values, namedParameters, firstRow, maxRows, filterKeys, session.getEntityMode(), customTransformer);
    }

    QueryKey(String sqlQueryString, Type[] positionalParameterTypes, Object[] positionalParameterValues, Map namedParameters, Integer firstRow, Integer maxRows, Set filterKeys, EntityMode entityMode, ResultTransformer customTransformer) {
        this.sqlQueryString = sqlQueryString;
        this.positionalParameterTypes = positionalParameterTypes;
        this.positionalParameterValues = positionalParameterValues;
        this.namedParameters = namedParameters;
        this.firstRow = firstRow;
        this.maxRows = maxRows;
        this.entityMode = entityMode;
        this.filterKeys = filterKeys;
        this.customTransformer = customTransformer;
        this.hashCode = this.generateHashCode();
    }

    public ResultTransformer getResultTransformer() {
        return this.customTransformer;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.hashCode = this.generateHashCode();
    }

    private int generateHashCode() {
        int result = 13;
        result = 37 * result + (this.firstRow == null ? 0 : this.firstRow.hashCode());
        result = 37 * result + (this.maxRows == null ? 0 : this.maxRows.hashCode());
        for (int i = 0; i < this.positionalParameterValues.length; ++i) {
            result = 37 * result + (this.positionalParameterValues[i] == null ? 0 : this.positionalParameterTypes[i].getHashCode(this.positionalParameterValues[i], this.entityMode));
        }
        result = 37 * result + (this.namedParameters == null ? 0 : ((Object)this.namedParameters).hashCode());
        result = 37 * result + (this.filterKeys == null ? 0 : ((Object)this.filterKeys).hashCode());
        result = 37 * result + (this.customTransformer == null ? 0 : this.customTransformer.hashCode());
        result = 37 * result + this.sqlQueryString.hashCode();
        return result;
    }

    public boolean equals(Object other) {
        if (!(other instanceof QueryKey)) {
            return false;
        }
        QueryKey that = (QueryKey)other;
        if (!this.sqlQueryString.equals(that.sqlQueryString)) {
            return false;
        }
        if (!EqualsHelper.equals(this.firstRow, that.firstRow) || !EqualsHelper.equals(this.maxRows, that.maxRows)) {
            return false;
        }
        if (!EqualsHelper.equals(this.customTransformer, that.customTransformer)) {
            return false;
        }
        if (this.positionalParameterTypes == null) {
            if (that.positionalParameterTypes != null) {
                return false;
            }
        } else {
            if (that.positionalParameterTypes == null) {
                return false;
            }
            if (this.positionalParameterTypes.length != that.positionalParameterTypes.length) {
                return false;
            }
            for (int i = 0; i < this.positionalParameterTypes.length; ++i) {
                if (this.positionalParameterTypes[i].getReturnedClass() != that.positionalParameterTypes[i].getReturnedClass()) {
                    return false;
                }
                if (this.positionalParameterTypes[i].isEqual(this.positionalParameterValues[i], that.positionalParameterValues[i], this.entityMode)) continue;
                return false;
            }
        }
        return EqualsHelper.equals(this.filterKeys, that.filterKeys) && EqualsHelper.equals(this.namedParameters, that.namedParameters);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer().append("sql: ").append(this.sqlQueryString);
        if (this.positionalParameterValues != null) {
            buf.append("; parameters: ");
            for (int i = 0; i < this.positionalParameterValues.length; ++i) {
                buf.append(this.positionalParameterValues[i]).append(", ");
            }
        }
        if (this.namedParameters != null) {
            buf.append("; named parameters: ").append(this.namedParameters);
        }
        if (this.filterKeys != null) {
            buf.append("; filterKeys: ").append(this.filterKeys);
        }
        if (this.firstRow != null) {
            buf.append("; first row: ").append(this.firstRow);
        }
        if (this.maxRows != null) {
            buf.append("; max rows: ").append(this.maxRows);
        }
        if (this.customTransformer != null) {
            buf.append("; transformer: ").append(this.customTransformer);
        }
        return buf.toString();
    }
}

