/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.servlet;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.util.IO;
import org.mortbay.util.URIUtil;

public class RestFilter
implements Filter {
    private static final String HTTP_METHOD_PUT = "PUT";
    private static final String HTTP_METHOD_GET = "GET";
    private static final String HTTP_METHOD_DELETE = "DELETE";
    private FilterConfig filterConfig;
    private long _maxPutSize;

    public void init(FilterConfig filterConfig) throws UnavailableException {
        this.filterConfig = filterConfig;
        String tmp = filterConfig.getInitParameter("maxPutSize");
        if (tmp != null) {
            this._maxPutSize = Long.parseLong(tmp);
        }
    }

    private File locateFile(HttpServletRequest request) {
        return new File(this.filterConfig.getServletContext().getRealPath(URIUtil.addPaths(request.getServletPath(), request.getPathInfo())));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (httpRequest.getMethod().equals(HTTP_METHOD_GET)) {
            chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        } else if (httpRequest.getMethod().equals(HTTP_METHOD_PUT)) {
            this.doPut(httpRequest, httpResponse);
        } else if (httpRequest.getMethod().equals(HTTP_METHOD_DELETE)) {
            this.doDelete(httpRequest, httpResponse);
        } else {
            chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean success;
        File file = this.locateFile(request);
        if (file.exists() && !(success = file.delete())) {
            response.sendError(403);
            return;
        }
        FileOutputStream out = new FileOutputStream(file);
        try {
            if (this._maxPutSize > 0L) {
                int length = request.getContentLength();
                if ((long)length > this._maxPutSize) {
                    response.sendError(403);
                    return;
                }
                IO.copy((InputStream)request.getInputStream(), out, this._maxPutSize);
            } else {
                IO.copy((InputStream)request.getInputStream(), out);
            }
        }
        finally {
            out.close();
        }
        response.setStatus(204);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        File file = this.locateFile(request);
        if (!file.exists()) {
            response.sendError(404);
            return;
        }
        boolean success = IO.delete(file);
        if (success) {
            response.setStatus(204);
        } else {
            response.sendError(500);
        }
    }

    public void destroy() {
    }
}

