/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handlers.providedservice;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.IPOJOServiceFactory;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.handlers.providedservice.CreationStrategy;
import org.apache.felix.ipojo.handlers.providedservice.ProvidedServiceHandler;
import org.apache.felix.ipojo.util.Callback;
import org.apache.felix.ipojo.util.Property;
import org.apache.felix.ipojo.util.SecurityHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ProvidedService
implements ServiceFactory {
    public static final int REGISTERED = 1;
    public static final int UNREGISTERED = 0;
    public static final int SINGLETON_STRATEGY = 0;
    public static final int SERVICE_STRATEGY = 1;
    public static final int STATIC_STRATEGY = 2;
    public static final int INSTANCE_STRATEGY = 3;
    private String[] m_serviceSpecifications = new String[0];
    private ServiceRegistration m_serviceRegistration;
    private ProvidedServiceHandler m_handler;
    private Property[] m_properties;
    private CreationStrategy m_strategy;
    private volatile boolean m_wasUpdated;
    private Map m_controllers = new HashMap();
    private Callback m_postRegistration;
    private Callback m_postUnregistration;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$felix$ipojo$IPOJOServiceFactory;

    public ProvidedService(ProvidedServiceHandler handler, String[] specification, int factoryPolicy, Class creationStrategyClass, Dictionary conf) {
        this.m_handler = handler;
        this.m_serviceSpecifications = specification;
        try {
            this.addProperty(new Property("instance.name", null, null, handler.getInstanceManager().getInstanceName(), (class$java$lang$String == null ? (class$java$lang$String = ProvidedService.class$("java.lang.String")) : class$java$lang$String).getName(), handler.getInstanceManager(), handler));
            this.addProperty(new Property("factory.name", null, null, handler.getInstanceManager().getFactory().getFactoryName(), (class$java$lang$String == null ? (class$java$lang$String = ProvidedService.class$("java.lang.String")) : class$java$lang$String).getName(), handler.getInstanceManager(), handler));
            if (handler.getInstanceManager().getFactory().getVersion() != null) {
                this.addProperty(new Property("factory.version", null, null, handler.getInstanceManager().getFactory().getVersion(), (class$java$lang$String == null ? (class$java$lang$String = ProvidedService.class$("java.lang.String")) : class$java$lang$String).getName(), handler.getInstanceManager(), handler));
            }
            if (conf.get("service.pid") != null) {
                this.addProperty(new Property("service.pid", null, null, (String)conf.get("service.pid"), (class$java$lang$String == null ? (class$java$lang$String = ProvidedService.class$("java.lang.String")) : class$java$lang$String).getName(), handler.getInstanceManager(), handler));
            }
            if (conf.get("service.ranking") != null) {
                this.addProperty(new Property("service.ranking", null, null, (String)conf.get("service.ranking"), "int", handler.getInstanceManager(), handler));
            }
            if (conf.get("service.vendor") != null) {
                this.addProperty(new Property("service.vendor", null, null, (String)conf.get("service.vendor"), (class$java$lang$String == null ? (class$java$lang$String = ProvidedService.class$("java.lang.String")) : class$java$lang$String).getName(), handler.getInstanceManager(), handler));
            }
            if (conf.get("service.description") != null) {
                this.addProperty(new Property("service.description", null, null, (String)conf.get("service.description"), (class$java$lang$String == null ? (class$java$lang$String = ProvidedService.class$("java.lang.String")) : class$java$lang$String).getName(), handler.getInstanceManager(), handler));
            }
        }
        catch (ConfigurationException e) {
            this.m_handler.error("An exception occurs when adding instance.name and factory.name property : " + e.getMessage());
        }
        if (creationStrategyClass != null) {
            try {
                this.m_strategy = (CreationStrategy)creationStrategyClass.newInstance();
            }
            catch (IllegalAccessException e) {
                this.m_handler.error("[" + this.m_handler.getInstanceManager().getInstanceName() + "] The customized service object creation policy " + "(" + creationStrategyClass.getName() + ") is not accessible: " + e.getMessage());
                this.getInstanceManager().stop();
                return;
            }
            catch (InstantiationException e) {
                this.m_handler.error("[" + this.m_handler.getInstanceManager().getInstanceName() + "] The customized service object creation policy " + "(" + creationStrategyClass.getName() + ") cannot be instantiated: " + e.getMessage());
                this.getInstanceManager().stop();
                return;
            }
        } else {
            switch (factoryPolicy) {
                case 0: {
                    this.m_strategy = new SingletonStrategy();
                    break;
                }
                case 1: 
                case 2: {
                    this.m_strategy = new FactoryStrategy();
                    break;
                }
                case 3: {
                    this.m_strategy = new PerInstanceStrategy();
                    break;
                }
                default: {
                    List<String> specs = Arrays.asList(this.m_serviceSpecifications);
                    this.m_handler.error("[" + this.m_handler.getInstanceManager().getInstanceName() + "] Unknown creation policy for " + specs + " : " + factoryPolicy);
                    this.getInstanceManager().stop();
                }
            }
        }
    }

    protected void setProperties(Property[] props) {
        for (int i = 0; i < props.length; ++i) {
            this.addProperty(props[i]);
        }
    }

    private synchronized void addProperty(Property prop) {
        for (int i = 0; this.m_properties != null && i < this.m_properties.length; ++i) {
            if (this.m_properties[i] != prop) continue;
            return;
        }
        if (this.m_properties == null) {
            this.m_properties = new Property[]{prop};
        } else {
            Property[] newProp = new Property[this.m_properties.length + 1];
            System.arraycopy(this.m_properties, 0, newProp, 0, this.m_properties.length);
            newProp[this.m_properties.length] = prop;
            this.m_properties = newProp;
        }
    }

    private synchronized void removeProperty(String name) {
        int idx = -1;
        for (int i = 0; i < this.m_properties.length; ++i) {
            if (!this.m_properties[i].getName().equals(name)) continue;
            idx = i;
            break;
        }
        if (idx >= 0) {
            if (this.m_properties.length - 1 == 0) {
                this.m_properties = null;
            } else {
                Property[] newPropertiesList = new Property[this.m_properties.length - 1];
                System.arraycopy(this.m_properties, 0, newPropertiesList, 0, idx);
                if (idx < newPropertiesList.length) {
                    System.arraycopy(this.m_properties, idx + 1, newPropertiesList, idx, newPropertiesList.length - idx);
                }
                this.m_properties = newPropertiesList;
            }
        }
    }

    public ServiceReference getServiceReference() {
        if (this.m_serviceRegistration == null) {
            return null;
        }
        return this.m_serviceRegistration.getReference();
    }

    public Object getService(Bundle bundle, ServiceRegistration registration) {
        if (this.getInstanceManager().getState() == 2) {
            return this.m_strategy.getService(bundle, registration);
        }
        return null;
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
        this.m_strategy.ungetService(bundle, registration, service);
    }

    protected synchronized void registerService() {
        if (this.m_serviceRegistration != null) {
            this.unregisterService();
        }
        if (this.m_handler.getInstanceManager().getState() == 2 && this.m_serviceRegistration == null && this.isAtLeastAServiceControllerValid()) {
            BundleContext bc = this.m_handler.getInstanceManager().getContext();
            if (SecurityHelper.hasPermissionToRegisterServices(this.m_serviceSpecifications, bc)) {
                Properties serviceProperties = this.getServiceProperties();
                this.m_strategy.onPublication(this.getInstanceManager(), this.getServiceSpecificationsToRegister(), serviceProperties);
                this.m_serviceRegistration = bc.registerService(this.getServiceSpecificationsToRegister(), (Object)this, (Dictionary)serviceProperties);
                if (this.m_wasUpdated) {
                    this.m_serviceRegistration.setProperties((Dictionary)this.getServiceProperties());
                    this.m_wasUpdated = false;
                }
                if (this.m_postRegistration != null) {
                    try {
                        this.m_postRegistration.call(new Object[]{this.m_serviceRegistration.getReference()});
                    }
                    catch (Exception e) {
                        this.m_handler.error("Cannot invoke the post-registration callback " + this.m_postRegistration.getMethod(), e);
                    }
                }
            } else {
                throw new SecurityException("The bundle " + bc.getBundle().getBundleId() + " does not have the" + " permission to register the services " + Arrays.asList(this.m_serviceSpecifications));
            }
        }
    }

    protected synchronized void unregisterService() {
        ServiceReference ref = null;
        if (this.m_serviceRegistration != null) {
            ref = this.m_serviceRegistration.getReference();
            this.m_serviceRegistration.unregister();
            this.m_serviceRegistration = null;
        }
        this.m_strategy.onUnpublication();
        if (this.m_postUnregistration != null && ref != null) {
            try {
                this.m_postUnregistration.call(new Object[]{ref});
            }
            catch (Exception e) {
                this.m_handler.error("Cannot invoke the post-unregistration callback " + this.m_postUnregistration.getMethod(), e);
            }
        }
    }

    public int getState() {
        if (this.m_serviceRegistration == null) {
            return 0;
        }
        return 1;
    }

    protected InstanceManager getInstanceManager() {
        return this.m_handler.getInstanceManager();
    }

    private Properties getServiceProperties() {
        Properties serviceProperties = new Properties();
        for (int i = 0; i < this.m_properties.length; ++i) {
            Object value = this.m_properties[i].getValue();
            if (value == null || value == Property.NO_VALUE) continue;
            serviceProperties.put(this.m_properties[i].getName(), value);
        }
        return serviceProperties;
    }

    public Property[] getProperties() {
        return this.m_properties;
    }

    public synchronized void update() {
        if (this.m_serviceRegistration != null) {
            this.m_serviceRegistration.setProperties((Dictionary)this.getServiceProperties());
        } else {
            this.m_wasUpdated = true;
        }
    }

    protected void addProperties(Dictionary props) {
        Enumeration keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object value = props.get(key);
            try {
                Property prop = new Property(key, null, null, value.toString(), value.getClass().getName(), this.getInstanceManager(), this.m_handler);
                this.addProperty(prop);
            }
            catch (ConfigurationException e) {
                this.m_handler.error("The propagated property " + key + " cannot be created correctly : " + e.getMessage());
            }
        }
    }

    protected void deleteProperties(Dictionary props) {
        Enumeration keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.removeProperty(key);
        }
    }

    public String[] getServiceSpecifications() {
        return this.m_serviceSpecifications;
    }

    public ServiceRegistration getServiceRegistration() {
        return this.m_serviceRegistration;
    }

    public void setController(String field, boolean value, String specification) {
        if (specification == null) {
            this.m_controllers.put("ALL", new ServiceController(field, value));
        } else {
            this.m_controllers.put(specification, new ServiceController(field, value));
        }
    }

    public ServiceController getController(String field) {
        Collection controllers = this.m_controllers.values();
        Iterator iterator = controllers.iterator();
        while (iterator.hasNext()) {
            ServiceController controller = (ServiceController)iterator.next();
            if (!field.equals(controller.m_field)) continue;
            return controller;
        }
        return null;
    }

    public ServiceController getControllerBySpecification(String spec) {
        return (ServiceController)this.m_controllers.get(spec);
    }

    private boolean isAtLeastAServiceControllerValid() {
        Collection controllers = this.m_controllers.values();
        if (controllers.isEmpty()) {
            return true;
        }
        Iterator iterator = controllers.iterator();
        while (iterator.hasNext()) {
            ServiceController controller = (ServiceController)iterator.next();
            if (!controller.getValue()) continue;
            return true;
        }
        return false;
    }

    private String[] getServiceSpecificationsToRegister() {
        ServiceController ctrl;
        if (this.m_controllers.isEmpty()) {
            return this.m_serviceSpecifications;
        }
        ArrayList<String> l = new ArrayList<String>();
        if (this.m_controllers.containsKey("ALL") && (ctrl = (ServiceController)this.m_controllers.get("ALL")).m_value) {
            l.addAll(Arrays.asList(this.m_serviceSpecifications));
        }
        Iterator iterator = this.m_controllers.keySet().iterator();
        while (iterator.hasNext()) {
            String spec = (String)iterator.next();
            ServiceController ctrl2 = (ServiceController)this.m_controllers.get(spec);
            if (ctrl2.m_value) {
                if ("ALL".equals(spec) || l.contains(spec)) continue;
                l.add(spec);
                continue;
            }
            l.remove(spec);
        }
        return l.toArray(new String[l.size()]);
    }

    public void setPostRegistrationCallback(Callback cb) {
        this.m_postRegistration = cb;
    }

    public void setPostUnregistrationCallback(Callback cb) {
        this.m_postUnregistration = cb;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class PerInstanceStrategy
    extends CreationStrategy
    implements IPOJOServiceFactory,
    InvocationHandler {
        private Map m_instances = new HashMap();

        private PerInstanceStrategy() {
        }

        public Object invoke(Object arg0, Method arg1, Object[] arg2) {
            if (PerInstanceStrategy.isGetServiceMethod(arg1)) {
                return this.getService((ComponentInstance)arg2[0]);
            }
            if (PerInstanceStrategy.isUngetServiceMethod(arg1)) {
                this.ungetService((ComponentInstance)arg2[0], arg2[1]);
                return null;
            }
            throw new UnsupportedOperationException("This service requires an advanced creation policy. Before calling the service, call the getService(ComponentInstance) method to get the service object. ");
        }

        public Object getService(ComponentInstance instance) {
            Object obj = this.m_instances.get(instance);
            if (obj == null) {
                obj = ProvidedService.this.m_handler.getInstanceManager().createPojoObject();
                this.m_instances.put(instance, obj);
            }
            return obj;
        }

        public void ungetService(ComponentInstance instance, Object svcObject) {
            Object pojo = this.m_instances.remove(instance);
            ProvidedService.this.m_handler.getInstanceManager().deletePojoObject(pojo);
        }

        public void onPublication(InstanceManager instance, String[] interfaces, Properties props) {
        }

        public void onUnpublication() {
            Collection col = this.m_instances.values();
            Iterator it = col.iterator();
            while (it.hasNext()) {
                ProvidedService.this.m_handler.getInstanceManager().deletePojoObject(it.next());
            }
            this.m_instances.clear();
        }

        public Object getService(Bundle arg0, ServiceRegistration arg1) {
            Object proxy = Proxy.newProxyInstance(ProvidedService.this.getInstanceManager().getClazz().getClassLoader(), this.getSpecificationsWithIPOJOServiceFactory(ProvidedService.this.m_serviceSpecifications, ProvidedService.this.m_handler.getInstanceManager().getContext()), (InvocationHandler)this);
            return proxy;
        }

        public void ungetService(Bundle arg0, ServiceRegistration arg1, Object arg2) {
        }

        private Class[] getSpecificationsWithIPOJOServiceFactory(String[] specs, BundleContext bc) {
            Class[] classes = new Class[specs.length + 1];
            int i = 0;
            for (i = 0; i < specs.length; ++i) {
                try {
                    classes[i] = bc.getBundle().loadClass(specs[i]);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            classes[i] = class$org$apache$felix$ipojo$IPOJOServiceFactory == null ? (class$org$apache$felix$ipojo$IPOJOServiceFactory = ProvidedService.class$("org.apache.felix.ipojo.IPOJOServiceFactory")) : class$org$apache$felix$ipojo$IPOJOServiceFactory;
            return classes;
        }
    }

    private class FactoryStrategy
    extends CreationStrategy {
        private FactoryStrategy() {
        }

        public void onPublication(InstanceManager instance, String[] interfaces, Properties props) {
        }

        public void onUnpublication() {
        }

        public Object getService(Bundle arg0, ServiceRegistration arg1) {
            return ProvidedService.this.m_handler.getInstanceManager().createPojoObject();
        }

        public void ungetService(Bundle arg0, ServiceRegistration arg1, Object arg2) {
            ProvidedService.this.m_handler.getInstanceManager().deletePojoObject(arg2);
        }
    }

    private class SingletonStrategy
    extends CreationStrategy {
        private SingletonStrategy() {
        }

        public void onPublication(InstanceManager instance, String[] interfaces, Properties props) {
        }

        public void onUnpublication() {
        }

        public Object getService(Bundle arg0, ServiceRegistration arg1) {
            return ProvidedService.this.m_handler.getInstanceManager().getPojoObject();
        }

        public void ungetService(Bundle arg0, ServiceRegistration arg1, Object arg2) {
        }
    }

    class ServiceController {
        private volatile boolean m_value;
        private final String m_field;

        public ServiceController(String field, boolean value) {
            this.m_field = field;
            this.m_value = value;
        }

        public String getField() {
            return this.m_field;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean getValue() {
            ProvidedService providedService = ProvidedService.this;
            synchronized (providedService) {
                return this.m_value;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(Boolean value) {
            ProvidedService providedService = ProvidedService.this;
            synchronized (providedService) {
                if (value != this.m_value) {
                    this.m_value = value;
                    if (this.m_value) {
                        ProvidedService.this.registerService();
                    } else if (ProvidedService.this.getServiceSpecificationsToRegister().length != 0) {
                        ProvidedService.this.registerService();
                    } else {
                        ProvidedService.this.unregisterService();
                    }
                }
            }
        }
    }
}

