/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.security.context;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.ow2.jonas.lib.security.mapping.JPolicyUserRoleMapping;

public class SecurityContext
implements Serializable {
    private String principalName = null;
    private static final String PRINCIPAL_NAME = "ANONYMOUS";
    private Principal defaultPrincipal = null;
    private Principal runAsPrincipal = null;
    private final String[] roles;
    private List runAsRoleStack = null;
    private List runAsPrincipalStack = null;
    private List runAsPrincipalRolesStack = null;
    private byte[] signedData = null;

    public SecurityContext() {
        this(PRINCIPAL_NAME);
    }

    public SecurityContext(String principalName) {
        this(principalName, new String[]{"JOnAS"});
    }

    public SecurityContext(String principalName, String[] roles) {
        this(principalName, Arrays.asList(roles));
    }

    public SecurityContext(String principalName, List arrayRoles) {
        this(principalName, arrayRoles, null, null, null);
    }

    protected SecurityContext(String principalName, List arrayRoles, List arrayRunas, List arrayRunasPrincipal, List arrayRunasPrincipalRoles) {
        this.principalName = principalName;
        String[] overridedRoles = JPolicyUserRoleMapping.getGlobalMappingForPrincipal(principalName);
        if (overridedRoles != null) {
            this.roles = overridedRoles;
        } else if (arrayRoles != null) {
            String[] r = new String[arrayRoles.size()];
            r = arrayRoles.toArray(r);
            this.roles = r;
        } else {
            this.roles = null;
        }
        this.runAsRoleStack = arrayRunas;
        this.runAsPrincipalStack = arrayRunasPrincipal;
        this.runAsPrincipalRolesStack = arrayRunasPrincipalRoles;
        this.defaultPrincipal = new InternalPrincipal(false);
        this.runAsPrincipal = new InternalPrincipal(true);
    }

    public Principal getCallerPrincipal(boolean inRunAs) {
        if (inRunAs) {
            return this.runAsPrincipal;
        }
        return this.defaultPrincipal;
    }

    public byte[] getSignature() {
        return this.signedData;
    }

    public void setSignature(byte[] signedData) {
        this.signedData = signedData;
    }

    public String[] getCallerPrincipalRoles(boolean inRunAs) {
        String[] runAsRoles = null;
        runAsRoles = inRunAs ? this.peekLastRunAsPrincipalRoles() : this.peekRunAsPrincipalRoles();
        if (runAsRoles != null) {
            return runAsRoles;
        }
        return this.roles;
    }

    public synchronized void pushRunAs(String role, String principalName, String[] roles) {
        this.getRunAsRoleStack().add(role);
        this.getRunAsPrincipalStack().add(principalName);
        this.getRunAsPrincipalRolesStack().add(roles);
    }

    public synchronized void popRunAs() {
        if (!this.getRunAsRoleStack().isEmpty()) {
            this.getRunAsRoleStack().remove(this.getRunAsRoleStack().size() - 1);
        }
        if (!this.getRunAsPrincipalStack().isEmpty()) {
            this.getRunAsPrincipalStack().remove(this.getRunAsPrincipalStack().size() - 1);
        }
        if (!this.getRunAsPrincipalRolesStack().isEmpty()) {
            this.getRunAsPrincipalRolesStack().remove(this.getRunAsPrincipalRolesStack().size() - 1);
        }
    }

    public synchronized String peekRunAsRole() {
        if (this.getRunAsRoleStack().isEmpty()) {
            return null;
        }
        return (String)this.getRunAsRoleStack().get(this.getRunAsRoleStack().size() - 1);
    }

    public synchronized String peekRunAsPrincipal() {
        if (this.getRunAsPrincipalStack().isEmpty()) {
            return null;
        }
        return (String)this.getRunAsPrincipalStack().get(this.getRunAsPrincipalStack().size() - 1);
    }

    public synchronized String peekLastRunAsPrincipal() {
        if (this.getRunAsPrincipalStack().size() < 2) {
            return null;
        }
        return (String)this.getRunAsPrincipalStack().get(this.getRunAsPrincipalStack().size() - 2);
    }

    public synchronized String[] peekRunAsPrincipalRoles() {
        if (this.getRunAsPrincipalRolesStack().isEmpty()) {
            return null;
        }
        return (String[])this.getRunAsPrincipalRolesStack().get(this.getRunAsPrincipalRolesStack().size() - 1);
    }

    public synchronized String[] peekLastRunAsPrincipalRoles() {
        if (this.getRunAsPrincipalRolesStack().size() < 2) {
            return null;
        }
        return (String[])this.getRunAsPrincipalRolesStack().get(this.getRunAsPrincipalRolesStack().size() - 2);
    }

    public synchronized List getRunAsRoleStack() {
        if (this.runAsRoleStack == null) {
            this.runAsRoleStack = Collections.synchronizedList(new ArrayList());
        }
        return this.runAsRoleStack;
    }

    public synchronized List getRunAsPrincipalRolesStack() {
        if (this.runAsPrincipalRolesStack == null) {
            this.runAsPrincipalRolesStack = Collections.synchronizedList(new ArrayList());
        }
        return this.runAsPrincipalRolesStack;
    }

    public synchronized List getRunAsPrincipalStack() {
        if (this.runAsPrincipalStack == null) {
            this.runAsPrincipalStack = Collections.synchronizedList(new ArrayList());
        }
        return this.runAsPrincipalStack;
    }

    public String toString() {
        String txt = "principal : name = " + this.principalName + "\n";
        if (this.roles != null) {
            for (int i = 0; i < this.roles.length; ++i) {
                txt = txt + "role[" + i + "] = " + this.roles[i] + "\n";
            }
        }
        if (this.runAsRoleStack != null) {
            Iterator iRunas = this.runAsRoleStack.iterator();
            int i = 0;
            while (iRunas.hasNext()) {
                txt = txt + "runas[" + i + "] = " + (String)iRunas.next() + "\n";
            }
        }
        return txt;
    }

    protected String getPrincipalName(boolean runningRunAs) {
        String principal = null;
        principal = runningRunAs ? this.peekLastRunAsPrincipal() : this.peekRunAsPrincipal();
        if (principal != null) {
            return principal;
        }
        return this.principalName;
    }

    public String getPrincipalName() {
        return this.principalName;
    }

    public String[] getRoles() {
        return this.roles;
    }

    class InternalPrincipal
    implements Principal,
    Serializable {
        private boolean inRunAs = false;

        public InternalPrincipal(boolean inRunAs) {
            this.inRunAs = inRunAs;
        }

        public String getName() {
            return SecurityContext.this.getPrincipalName(this.inRunAs);
        }

        public boolean equals(Object o) {
            if (o instanceof Principal) {
                return SecurityContext.this.getPrincipalName(this.inRunAs).equals(((Principal)o).getName());
            }
            return false;
        }

        public int hashCode() {
            return SecurityContext.this.getPrincipalName(this.inRunAs).hashCode();
        }

        public String toString() {
            return "name = " + SecurityContext.this.getPrincipalName(this.inRunAs);
        }
    }
}

