/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.jmbeans;

import java.util.Properties;
import java.util.TreeSet;
import org.objectweb.util.monolog.api.Level;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.management.javaee.J2EEManagedObject;
import org.ow2.jonas.lib.management.reconfig.PropertiesConfigurationData;
import org.ow2.jonas.lib.util.Log;

public class LogManager
extends J2EEManagedObject {
    private static String SERVICE_NAME = "log";
    private long sequenceNumber = 0L;
    private Properties props = null;
    private String configFile = null;

    public LogManager(String objectName) {
        super(objectName);
    }

    public String[] getTopics() {
        Logger[] logs = Log.getLoggerFactory().getLoggers();
        TreeSet<String> tset = new TreeSet<String>();
        for (int i = 0; i < logs.length; ++i) {
            tset.add(logs[i].getName());
        }
        return tset.toArray(new String[0]);
    }

    public String getTopicLevel(String topic) {
        Logger topicLogger = Log.getLoggerFactory().getLogger(topic);
        Level lev = topicLogger.getCurrentLevel();
        return lev.getName();
    }

    public void setTopicLevel(String topic, String level) {
        Logger topicLogger = Log.getLoggerFactory().getLogger(topic);
        Level lev = Log.getLevelFactory().getLevel(level);
        if (lev == null) {
            throw new RuntimeException("Unknown level " + level);
        }
        topicLogger.setLevel(lev);
        String propName = "logger." + topic + ".level";
        this.sendReconfigNotification(++this.sequenceNumber, SERVICE_NAME, new PropertiesConfigurationData(propName, level));
    }

    public void saveConfig() {
        this.sendSaveNotification(++this.sequenceNumber, SERVICE_NAME);
    }

    public Properties getProps() {
        return this.props;
    }

    public void setProps(Properties props) {
        this.props = props;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }
}

