/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.cxf.jaxws;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.wsdl.WSDLException;
import org.apache.cxf.Bus;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.wsdl.WSDLManager;
import org.apache.cxf.wsdl11.ServiceWSDLBuilder;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Level;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.ws.cxf.BusCreator;
import org.ow2.jonas.ws.cxf.http.JOnASDestination;
import org.ow2.jonas.ws.cxf.jaxws.CXFWSEndpoint;
import org.ow2.jonas.ws.cxf.util.WSDLUtils;
import org.ow2.jonas.ws.jaxws.IWebServiceEndpoint;
import org.ow2.jonas.ws.jaxws.base.JAXWSWebservicesContainer;
import org.ow2.jonas.ws.publish.PublicationInfo;
import org.ow2.jonas.ws.publish.PublishableDefinition;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebservicesContainer<T extends IWebServiceEndpoint>
extends JAXWSWebservicesContainer<T> {
    private static org.ow2.util.log.Log logger = LogFactory.getLog(WebservicesContainer.class);
    private Bus bus;

    public WebservicesContainer(String name) {
        super(name);
        BusCreator creator = new BusCreator();
        this.bus = creator.initBus();
    }

    public Bus getBus() {
        return this.bus;
    }

    public void stop() {
        super.stop();
        Level old = Log.setComponentLogLevel((String)"org.apache.cxf", (Level)BasicLevel.LEVEL_ERROR);
        Level old2 = Log.setComponentLogLevel((String)"org.springframework", (Level)BasicLevel.LEVEL_ERROR);
        this.bus.shutdown(true);
        Log.setComponentLogLevel((String)"org.apache.cxf", (Level)old);
        Log.setComponentLogLevel((String)"org.springframework", (Level)old2);
    }

    public List<PublishableDefinition> getPublishableDefinitions() {
        String directory;
        String wsdlLocation = this.getName();
        ArrayList<PublishableDefinition> publishableDefinitionList = new ArrayList<PublishableDefinition>();
        if (wsdlLocation != null && !"".equals(wsdlLocation)) {
            PublishableDefinition publishableDefinition = new PublishableDefinition();
            publishableDefinitionList.add(publishableDefinition);
            PublicationInfo publicationInfo = new PublicationInfo();
            publicationInfo.setOriginalWsdlFilename(wsdlLocation);
            publishableDefinition.setPublicationInfo(publicationInfo);
            WSDLManager wsdlManager = (WSDLManager)this.bus.getExtension(WSDLManager.class);
            try {
                publishableDefinition.setDefinition(wsdlManager.getDefinition(wsdlLocation));
            }
            catch (WSDLException e) {
                logger.error((Object)"Unable to load WSDL ''{0}''", new Object[]{wsdlLocation, e});
            }
        } else {
            Collection endPoints = this.getEndpoints();
            if (endPoints != null) {
                for (IWebServiceEndpoint endpoint : endPoints) {
                    if (!(endpoint instanceof CXFWSEndpoint)) continue;
                    CXFWSEndpoint cxfEndPoint = (CXFWSEndpoint)endpoint;
                    PublishableDefinition publishableDefinition = new PublishableDefinition();
                    JOnASDestination destination = cxfEndPoint.getDestination();
                    ServiceInfo serviceInfo = destination.getEndpointInfo().getService();
                    PublicationInfo publicationInfo = new PublicationInfo();
                    publishableDefinition.setPublicationInfo(publicationInfo);
                    publicationInfo.setOriginalWsdlFilename(serviceInfo.getName().getLocalPart() + ".wsdl");
                    try {
                        ServiceWSDLBuilder builder = new ServiceWSDLBuilder(this.bus, new ServiceInfo[]{serviceInfo});
                        publishableDefinition.setDefinition(builder.build());
                    }
                    catch (WSDLException e) {
                        logger.error((Object)"Unable to load WSDL ''{0}''", new Object[]{wsdlLocation, e});
                    }
                }
            }
        }
        if ((directory = this.getWsdlPublicationDirectory()) != null) {
            File dir = new File(directory);
            for (PublishableDefinition publishableDefinition : publishableDefinitionList) {
                publishableDefinition.getPublicationInfo().setPublicationDirectory(dir);
            }
        }
        for (PublishableDefinition publishableDefinition : publishableDefinitionList) {
            WSDLUtils.updateEndpointAddresses(publishableDefinition.getDefinition(), this);
        }
        return publishableDefinitionList;
    }
}

