/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ow2.easybeans.api.components.EZBComponentRegistry;
import org.ow2.easybeans.component.api.EZBComponent;
import org.ow2.easybeans.component.api.EZBComponentException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentRegistry
implements EZBComponentRegistry {
    private Log logger = LogFactory.getLog(ComponentRegistry.class);
    private Map<String, EZBComponent> components = new HashMap<String, EZBComponent>();

    public void register(String componentName, EZBComponent component) throws EZBComponentException {
        if (this.components.containsKey(componentName)) {
            throw new EZBComponentException("Cannot register the component with the name '" + componentName + "'. There is an existing component with this name.");
        }
        this.logger.debug((Object)"Registering component with name {0}.", new Object[]{componentName});
        this.components.put(componentName, component);
    }

    public void unregister(String componentName) throws EZBComponentException {
        if (!this.components.containsKey(componentName)) {
            throw new EZBComponentException("No component with the name '" + componentName + "' found. Component not unregistered");
        }
        this.logger.info((Object)"Unregistering component with name {0}.", new Object[]{componentName});
        this.components.remove(componentName);
    }

    public void unregister(EZBComponent component) throws EZBComponentException {
        String name = null;
        Set<String> keys = this.components.keySet();
        for (String key : keys) {
            EZBComponent foundComponent = this.components.get(key);
            if (!foundComponent.equals(component)) continue;
            name = key;
            break;
        }
        if (name != null) {
            this.unregister(name);
        }
        throw new EZBComponentException("No component found in the registry with the given component '" + component + "'.");
    }

    public EZBComponent getComponent(String componentName) {
        return this.components.get(componentName);
    }

    public String getComponentName(EZBComponent component) {
        String match = null;
        Iterator<String> i = this.components.keySet().iterator();
        while (i.hasNext() && match == null) {
            String key = i.next();
            EZBComponent candidate = this.components.get(key);
            if (!component.equals(candidate)) continue;
            match = key;
            break;
        }
        if (match == null) {
            throw new IllegalStateException("Each component should be registered in the registry. No component found for '" + component + "'.");
        }
        return match;
    }

    public <T extends EZBComponent> List<T> getComponents(Class<T> itf) {
        if (itf == null) {
            throw new IllegalArgumentException("Cannot find component with a null interface");
        }
        if (!itf.isInterface()) {
            throw new IllegalArgumentException("The given class '" + itf + "' is not an interface");
        }
        ArrayList<EZBComponent> matchComponents = new ArrayList<EZBComponent>();
        for (EZBComponent component : this.components.values()) {
            if (!Arrays.asList(component.getClass().getInterfaces()).contains(itf)) continue;
            matchComponents.add(component);
        }
        return matchComponents;
    }
}

