/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.event;

import java.util.LinkedList;
import java.util.List;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.EZBJ2EEManagedObject;
import org.ow2.easybeans.api.EZBServer;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.api.event.EZBEventListener;
import org.ow2.easybeans.component.api.EZBComponentException;
import org.ow2.easybeans.component.itf.EZBEventComponent;
import org.ow2.easybeans.naming.J2EEManagedObjectNamingHelper;
import org.ow2.util.event.api.IEventDispatcher;
import org.ow2.util.event.api.IEventListener;
import org.ow2.util.event.api.IEventService;
import org.ow2.util.event.impl.EventDispatcher;
import org.ow2.util.event.impl.EventService;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventComponent
implements EZBEventComponent {
    private static Log logger = LogFactory.getLog(EventComponent.class);
    private IEventService service;
    private LinkedList<IEventListener> listeners = new LinkedList();
    private LinkedList<EZBJ2EEManagedObject> objects = new LinkedList();

    public synchronized void init() throws EZBComponentException {
        if (this.service == null) {
            this.service = new EventService();
            this.service.start();
        }
    }

    public synchronized void start() throws EZBComponentException {
        logger.info((Object)"started.", new Object[0]);
    }

    public synchronized void stop() throws EZBComponentException {
        for (IEventListener listener : this.listeners) {
            this.service.unregisterListener(listener);
        }
        for (EZBJ2EEManagedObject object : this.objects) {
            this.service.unregisterDispatcher(object.getJ2EEManagedObjectId());
        }
        this.listeners.clear();
        this.objects.clear();
        logger.info((Object)"stopped.", new Object[0]);
    }

    public synchronized void setEventService(IEventService service) {
        this.service = service;
    }

    public synchronized IEventService getEventService() {
        return this.service;
    }

    public synchronized void registerJ2EEManagedObject(EZBJ2EEManagedObject object, IEventDispatcher dispatcher) {
        if (EZBServer.class.isAssignableFrom(object.getClass())) {
            this.registerEZBServer((EZBServer)object, dispatcher);
        } else if (EZBContainer.class.isAssignableFrom(object.getClass())) {
            this.registerEZBContainer((EZBContainer)object, dispatcher);
        } else if (Factory.class.isAssignableFrom(object.getClass())) {
            this.registerEZBFactory((Factory)object, dispatcher);
        }
    }

    public synchronized void unregisterJ2EEManagedObject(EZBJ2EEManagedObject object) {
        if (EZBServer.class.isAssignableFrom(object.getClass())) {
            this.unregisterEZBServer((EZBServer)object);
        } else if (EZBContainer.class.isAssignableFrom(object.getClass())) {
            this.unregisterEZBContainer((EZBContainer)object);
        } else if (Factory.class.isAssignableFrom(object.getClass())) {
            this.unregisterEZBFactory((Factory)object);
        }
    }

    public synchronized void registerEventListener(EZBEventListener eventListener) {
        this.service.registerListener((IEventListener)eventListener, eventListener.getEventProviderFilter());
        this.listeners.add((IEventListener)eventListener);
    }

    public synchronized void unregisterEventListener(EZBEventListener eventListener) {
        this.service.unregisterListener((IEventListener)eventListener);
        this.listeners.remove(eventListener);
    }

    public IEventDispatcher createEventDispatcher() {
        return new EventDispatcher();
    }

    private void registerEZBServer(EZBServer server, IEventDispatcher dispatcher) {
        this.service.registerDispatcher(server.getJ2EEManagedObjectId(), dispatcher);
        this.objects.add((EZBJ2EEManagedObject)server);
    }

    private void unregisterEZBServer(EZBServer server) {
        this.service.unregisterDispatcher(server.getJ2EEManagedObjectId());
        this.objects.remove(server);
    }

    private void registerEZBContainer(EZBContainer container, IEventDispatcher dispatcher) {
        this.service.registerDispatcher(container.getJ2EEManagedObjectId(), dispatcher);
        this.objects.add((EZBJ2EEManagedObject)container);
    }

    private void unregisterEZBContainer(EZBContainer container) {
        this.service.unregisterDispatcher(container.getJ2EEManagedObjectId());
        this.objects.remove(container);
    }

    private void registerEZBFactory(Factory<?, ?> factory, IEventDispatcher dispatcher) {
        this.service.registerDispatcher(factory.getJ2EEManagedObjectId(), dispatcher);
        this.objects.add((EZBJ2EEManagedObject)factory);
        List<String> methods = J2EEManagedObjectNamingHelper.getBeanMethodsManagedObjectIds(factory);
        for (String method : methods) {
            this.service.registerDispatcher(method, dispatcher);
        }
    }

    private void unregisterEZBFactory(Factory<?, ?> factory) {
        this.service.unregisterDispatcher(factory.getJ2EEManagedObjectId());
        this.objects.remove(factory);
        List<String> methods = J2EEManagedObjectNamingHelper.getBeanMethodsManagedObjectIds(factory);
        for (String method : methods) {
            this.service.unregisterDispatcher(method);
        }
    }
}

