/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.container.mdb;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.ejb.Timer;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.ow2.easybeans.api.bean.EasyBeansMDB;
import org.ow2.easybeans.api.event.bean.EZBEventBeanInvocationBegin;
import org.ow2.easybeans.container.mdb.MDBMessageEndPoint;
import org.ow2.easybeans.container.mdb.MDBMessageEndPointFactory;
import org.ow2.easybeans.event.bean.AbstractEventBeanInvocation;
import org.ow2.easybeans.event.bean.EventBeanInvocationEnd;
import org.ow2.easybeans.event.bean.EventBeanInvocationError;
import org.ow2.easybeans.naming.J2EEManagedObjectNamingHelper;
import org.ow2.util.auditreport.api.IAuditID;
import org.ow2.util.auditreport.api.ICurrentInvocationID;
import org.ow2.util.auditreport.impl.AuditIDImpl;
import org.ow2.util.event.api.IEvent;
import org.ow2.util.event.api.IEventDispatcher;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MDBListenerEndpointInvocationHandler
extends MDBMessageEndPoint
implements InvocationHandler {
    private static Log logger = LogFactory.getLog(MDBListenerEndpointInvocationHandler.class);
    private IEventDispatcher eventDispatcher = null;
    private Class<?> listenerInterface = null;

    public MDBListenerEndpointInvocationHandler(MDBMessageEndPointFactory mdbMessageEndPointFactory, EasyBeansMDB easyBeansMDB, Class<?> listenerInterface) {
        super(mdbMessageEndPointFactory, easyBeansMDB);
        this.listenerInterface = listenerInterface;
        this.eventDispatcher = ((MDBMessageEndPointFactory)this.getEasyBeansFactory()).getEventDispatcher();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if ("getEasyBeansFactory".equals(methodName)) {
            return this.getEasyBeansFactory();
        }
        if ("getMDBMessageEndPointFactory".equals(methodName)) {
            return this.getMDBMessageEndPointFactory();
        }
        if ("getEasyBeansMDB".equals(methodName)) {
            return this.getEasyBeansMDB();
        }
        if ("notifyTimeout".equals(methodName)) {
            this.notifyTimeout((Timer)args[0]);
            return null;
        }
        if ("release".equals(methodName)) {
            this.release();
            return null;
        }
        return this.invokeMethodOnMDB(method, args);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object invokeMethodOnMDB(Method method, Object[] args) {
        Object result;
        AbstractEventBeanInvocation endEvent;
        block18: {
            ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getEasyBeansFactory().getContainer().getClassLoader());
            ICurrentInvocationID currentInvocationID = this.getMDBMessageEndPointFactory().getCurrentInvocationID();
            if (currentInvocationID != null && MessageListener.class.equals(this.listenerInterface)) {
                String auditIDString = null;
                try {
                    auditIDString = ((Message)args[0]).getStringProperty(IAuditID.class.getName());
                }
                catch (JMSException e) {
                    logger.error((Object)"Unable to get the ID in the JMS message", new Object[]{e});
                }
                if (auditIDString != null) {
                    AuditIDImpl callerID = new AuditIDImpl(auditIDString);
                    AuditIDImpl newID = new AuditIDImpl();
                    newID.generate();
                    newID.setParentID(callerID.getLocalID());
                    currentInvocationID.setAuditID((IAuditID)newID);
                } else {
                    currentInvocationID.init(null);
                }
            }
            String methodEventProviderId = this.getMDBMessageEndPointFactory().getJ2EEManagedObjectId() + "/" + J2EEManagedObjectNamingHelper.getMethodSignature(method);
            EZBEventBeanInvocationBegin event = this.getMDBMessageEndPointFactory().getInvocationEventBegin(methodEventProviderId, args);
            long number = event.getInvocationNumber();
            this.eventDispatcher.dispatch((IEvent)event);
            endEvent = null;
            Method mdbMethod = null;
            if (this.listenerInterface.isInstance(this.getEasyBeansMDB())) {
                mdbMethod = method;
            } else {
                try {
                    mdbMethod = this.getEasyBeansMDB().getClass().getMethod(method.getName(), method.getParameterTypes());
                }
                catch (SecurityException e) {
                    throw new IllegalStateException("Cannot deliver the message", e);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalStateException("Cannot deliver the message", e);
                }
            }
            result = null;
            try {
                try {
                    result = mdbMethod.invoke((Object)this.getEasyBeansMDB(), args);
                    endEvent = new EventBeanInvocationEnd(methodEventProviderId, number, null);
                }
                catch (IllegalArgumentException e) {
                    logger.error((Object)"Cannot deliver the message", new Object[]{e});
                    endEvent = new EventBeanInvocationError(methodEventProviderId, number, e);
                    throw new IllegalStateException("Cannot deliver the message", e);
                }
                catch (IllegalAccessException e) {
                    logger.error((Object)"Cannot deliver the message", new Object[]{e});
                    endEvent = new EventBeanInvocationError(methodEventProviderId, number, e);
                    throw new IllegalStateException("Cannot deliver the message", e);
                }
                catch (InvocationTargetException e) {
                    endEvent = new EventBeanInvocationError(methodEventProviderId, number, e);
                    logger.error((Object)"Cannot deliver the message", new Object[]{e.getTargetException()});
                    throw new IllegalStateException("Cannot deliver the message", e.getTargetException());
                }
                Object var14_15 = null;
                Thread.currentThread().setContextClassLoader(oldCL);
                if (currentInvocationID == null) break block18;
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                Thread.currentThread().setContextClassLoader(oldCL);
                if (currentInvocationID != null) {
                    currentInvocationID.setAuditID(null);
                }
                if (endEvent == null) throw throwable;
                this.eventDispatcher.dispatch((IEvent)endEvent);
                throw throwable;
            }
            currentInvocationID.setAuditID(null);
        }
        if (endEvent == null) return result;
        this.eventDispatcher.dispatch((IEvent)endEvent);
        return result;
    }
}

