/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.enhancer.bean;

import javax.transaction.xa.XAResource;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.api.bean.EasyBeansBean;
import org.ow2.easybeans.api.bean.EasyBeansMDB;
import org.ow2.easybeans.api.bean.EasyBeansSFSB;
import org.ow2.easybeans.api.bean.EasyBeansSLSB;
import org.ow2.easybeans.api.bean.EasyBeansSingletonSB;
import org.ow2.easybeans.api.container.EZBEJBContext;
import org.ow2.easybeans.api.interceptor.EZBInterceptorManager;
import org.ow2.easybeans.api.interceptor.EZBInvocationContextFactory;
import org.ow2.easybeans.asm.ClassAdapter;
import org.ow2.easybeans.asm.ClassVisitor;
import org.ow2.easybeans.asm.MethodAdapter;
import org.ow2.easybeans.asm.MethodVisitor;
import org.ow2.easybeans.asm.Opcodes;
import org.ow2.easybeans.asm.Type;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarClassMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarMethodMetadata;
import org.ow2.easybeans.enhancer.CommonClassGenerator;
import org.ow2.easybeans.enhancer.lib.MethodRenamer;
import org.ow2.util.scan.api.metadata.structures.JMethod;

public class BeanClassAdapter
extends ClassAdapter
implements Opcodes {
    private EasyBeansEjbJarClassMetadata classAnnotationMetadata = null;
    public static final String TIMER_METHOD = "timeoutCallByEasyBeans";
    public static final String CLEANUP_METHOD = "easyBeansCleanup";
    public static final JMethod TIMER_JMETHOD = new JMethod(1, MethodRenamer.encode("timeoutCallByEasyBeans"), "(Ljavax/ejb/Timer;)V", null, null);

    public BeanClassAdapter(EasyBeansEjbJarClassMetadata classAnnotationMetadata, ClassVisitor cv) {
        super(cv);
        this.classAnnotationMetadata = classAnnotationMetadata;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        String[] newInterfaces = null;
        if (this.classAnnotationMetadata.isBean()) {
            newInterfaces = new String[interfaces.length + 1];
            System.arraycopy(interfaces, 0, newInterfaces, 0, interfaces.length);
            int indexElement = newInterfaces.length - 1;
            newInterfaces[indexElement] = this.classAnnotationMetadata.isStateless() ? Type.getInternalName(EasyBeansSLSB.class) : (this.classAnnotationMetadata.isStateful() ? Type.getInternalName(EasyBeansSFSB.class) : (this.classAnnotationMetadata.isMdb() ? Type.getInternalName(EasyBeansMDB.class) : (this.classAnnotationMetadata.isSingleton() ? Type.getInternalName(EasyBeansSingletonSB.class) : Type.getInternalName(EasyBeansBean.class))));
        } else {
            newInterfaces = interfaces;
        }
        super.visit(version, access, name, signature, superName, newInterfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ("<init>".equals(name) && "()V".equals(desc)) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            return new AddMethodConstructorAdapter(mv);
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    public void visitEnd() {
        super.visitEnd();
        CommonClassGenerator.addFieldGettersSetters(this.cv, this.classAnnotationMetadata.getClassName(), "easyBeansFactory", Factory.class);
        if (this.classAnnotationMetadata.isBean()) {
            CommonClassGenerator.addFieldGettersSetters(this.cv, this.classAnnotationMetadata.getClassName(), "easyBeansInterceptorManager", "L" + this.classAnnotationMetadata.getClassName() + "InterceptorManager" + ";");
            CommonClassGenerator.addFieldGettersSetters(this.cv, this.classAnnotationMetadata.getClassName(), "easyBeansInvocationContextFactory", EZBInvocationContextFactory.class);
            CommonClassGenerator.addFieldGettersSetters(this.cv, this.classAnnotationMetadata.getClassName(), "easyBeansDynamicInterceptorManager", EZBInterceptorManager.class);
            CommonClassGenerator.addFieldGettersSetters(this.cv, this.classAnnotationMetadata.getClassName(), "easyBeansContext", EZBEJBContext.class);
            if (this.classAnnotationMetadata.isSession()) {
                CommonClassGenerator.addFieldGettersSetters(this.cv, this.classAnnotationMetadata.getClassName(), "easyBeansRemoved", Boolean.TYPE);
            }
            if (this.classAnnotationMetadata.isStateful()) {
                CommonClassGenerator.addFieldGettersSetters(this.cv, this.classAnnotationMetadata.getClassName(), "easyBeansStatefulID", Long.class);
            }
            if (this.classAnnotationMetadata.isMdb()) {
                CommonClassGenerator.addFieldGettersSetters(this.cv, this.classAnnotationMetadata.getClassName(), "xaResource", XAResource.class);
            }
            this.addTimerMethod(this.cv);
            this.addCleanupMethod(this.cv);
        }
    }

    private void addCleanupMethod(ClassVisitor cv) {
        MethodVisitor mv = cv.visitMethod(1, CLEANUP_METHOD, "()V", null, null);
        CommonClassGenerator.addAnnotationsOnGeneratedMethod(mv);
        mv.visitCode();
        CommonClassGenerator.nullifyField(mv, this.classAnnotationMetadata.getClassName(), "easyBeansFactory", Factory.class);
        CommonClassGenerator.nullifyField(mv, this.classAnnotationMetadata.getClassName(), "easyBeansInterceptorManager", "L" + this.classAnnotationMetadata.getClassName() + "InterceptorManager" + ";");
        CommonClassGenerator.nullifyField(mv, this.classAnnotationMetadata.getClassName(), "easyBeansInvocationContextFactory", EZBInvocationContextFactory.class);
        CommonClassGenerator.nullifyField(mv, this.classAnnotationMetadata.getClassName(), "easyBeansDynamicInterceptorManager", EZBInterceptorManager.class);
        CommonClassGenerator.nullifyField(mv, this.classAnnotationMetadata.getClassName(), "easyBeansContext", EZBEJBContext.class);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void addTimerMethod(ClassVisitor cv) {
        MethodVisitor mv = cv.visitMethod(1, MethodRenamer.encode(TIMER_METHOD), "(Ljavax/ejb/Timer;)V", null, null);
        CommonClassGenerator.addAnnotationsOnGeneratedMethod(mv);
        mv.visitCode();
        boolean found = false;
        for (EasyBeansEjbJarMethodMetadata method : this.classAnnotationMetadata.getMethodMetadataCollection()) {
            if (!method.isTimeout()) continue;
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            String className = this.classAnnotationMetadata.getClassName();
            if (method.isInherited()) {
                className = method.getOriginalClassMetadata().getClassName();
            }
            mv.visitMethodInsn(183, className, method.getMethodName(), "(Ljavax/ejb/Timer;)V");
            found = true;
            break;
        }
        if (!found) {
            mv.visitTypeInsn(187, "javax/ejb/EJBException");
            mv.visitInsn(89);
            mv.visitLdcInsn("No timeout method has been defined on this bean");
            mv.visitMethodInsn(183, "javax/ejb/EJBException", "<init>", "(Ljava/lang/String;)V");
            mv.visitInsn(191);
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    public class AddMethodConstructorAdapter
    extends MethodAdapter {
        public AddMethodConstructorAdapter(MethodVisitor mv) {
            super(mv);
        }

        public void visitCode() {
            super.visitCode();
            String clManager = BeanClassAdapter.this.classAnnotationMetadata.getClassName() + "InterceptorManager";
            this.mv.visitVarInsn(25, 0);
            this.mv.visitTypeInsn(187, clManager);
            this.mv.visitInsn(89);
            this.mv.visitMethodInsn(183, clManager, "<init>", "()V");
            this.mv.visitFieldInsn(181, BeanClassAdapter.this.classAnnotationMetadata.getClassName(), "easyBeansInterceptorManager", "L" + clManager + ";");
        }
    }
}

