/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.security.interceptors;

import java.util.Arrays;
import javax.ejb.EJBAccessException;
import javax.security.jacc.PolicyContext;
import org.ow2.easybeans.api.EZBPermissionManager;
import org.ow2.easybeans.api.EasyBeansInterceptor;
import org.ow2.easybeans.api.EasyBeansInvocationContext;
import org.ow2.easybeans.security.propagation.context.SecurityCurrent;

public class AccessInterceptor
implements EasyBeansInterceptor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(EasyBeansInvocationContext invocationContext) throws Exception {
        String oldContextId = PolicyContext.getContextID();
        boolean accessGranted = true;
        boolean runAsBean = invocationContext.getFactory().getBeanInfo().getSecurityInfo().getRunAsRole() != null;
        try {
            EZBPermissionManager permissionManager = invocationContext.getFactory().getContainer().getPermissionManager();
            if (permissionManager != null) {
                accessGranted = permissionManager.checkSecurity(invocationContext, runAsBean);
            }
        }
        finally {
            PolicyContext.setContextID((String)oldContextId);
        }
        if (!accessGranted) {
            StringBuffer errMsg = new StringBuffer("Access Denied on bean '");
            errMsg.append(invocationContext.getFactory().getBeanInfo().getName());
            errMsg.append("' contained in the URL '");
            errMsg.append(invocationContext.getFactory().getContainer().getArchive());
            errMsg.append("'. ");
            errMsg.append(" Method = '");
            errMsg.append(invocationContext.getMethod());
            errMsg.append("'. ");
            errMsg.append("Current caller's principal is '");
            errMsg.append(SecurityCurrent.getCurrent().getSecurityContext().getCallerPrincipal(runAsBean));
            errMsg.append("' with roles '");
            errMsg.append(Arrays.asList(SecurityCurrent.getCurrent().getSecurityContext().getCallerRoles(runAsBean)));
            errMsg.append("'.");
            throw new EJBAccessException(errMsg.toString());
        }
        return invocationContext.proceed();
    }
}

