/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.security.jacc.provider;

import java.io.FilePermission;
import java.lang.reflect.ReflectPermission;
import java.net.SocketPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.PropertyPermission;
import javax.management.MBeanPermission;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;
import org.ow2.easybeans.security.jacc.provider.JPolicyConfiguration;
import org.ow2.easybeans.security.jacc.provider.JPolicyConfigurationKeeper;
import org.ow2.easybeans.security.jacc.provider.JPolicyException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public final class JPolicy
extends Policy {
    private static Log logger = LogFactory.getLog(JPolicy.class);
    private static JPolicy unique = null;
    private static Policy initialPolicy = null;
    private static PolicyConfigurationFactory policyConfigurationFactory = null;

    private JPolicy() {
        initialPolicy = Policy.getPolicy();
    }

    private void initPolicyConfigurationFactory() throws JPolicyException {
        try {
            policyConfigurationFactory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
        }
        catch (ClassNotFoundException cnfe) {
            throw new JPolicyException("PolicyConfigurationFactory class implementation was not found", cnfe);
        }
        catch (PolicyContextException pce) {
            throw new JPolicyException("PolicyContextException in PolicyConfigurationFactory", pce);
        }
        if (policyConfigurationFactory == null) {
            throw new JPolicyException("policyConfigurationFactory object hasn't be initialized");
        }
    }

    public static JPolicy getInstance() {
        if (unique == null) {
            unique = new JPolicy();
        }
        return unique;
    }

    public boolean implies(ProtectionDomain domain, Permission permission) {
        if (initialPolicy == null) {
            return false;
        }
        if (permission instanceof RuntimePermission || permission instanceof SocketPermission || permission instanceof PropertyPermission || permission instanceof FilePermission || permission instanceof MBeanPermission || permission instanceof ReflectPermission) {
            return initialPolicy.implies(domain, permission);
        }
        String contextID = PolicyContext.getContextID();
        if (contextID == null) {
            return initialPolicy.implies(domain, permission);
        }
        if (!(permission instanceof EJBMethodPermission || permission instanceof EJBRoleRefPermission || permission instanceof WebUserDataPermission || permission instanceof WebRoleRefPermission || permission instanceof WebResourcePermission)) {
            return initialPolicy.implies(domain, permission);
        }
        logger.debug((Object)"Permission being checked = ''{0}''", new Object[]{permission});
        try {
            if (policyConfigurationFactory == null) {
                this.initPolicyConfigurationFactory();
            }
            if (!policyConfigurationFactory.inService(contextID)) {
                logger.debug((Object)"Policy configuration factory not in service, return false", new Object[0]);
                return false;
            }
        }
        catch (JPolicyException jpe) {
            logger.error((Object)"JPolicy.implies.canNotCheck", new Object[]{jpe});
            return false;
        }
        catch (PolicyContextException pce) {
            logger.error((Object)"JPolicy.implies.canNotCheck", new Object[]{pce});
            return false;
        }
        JPolicyConfiguration jPolicyConfiguration = null;
        try {
            PolicyConfiguration pc = policyConfigurationFactory.getPolicyConfiguration(contextID, false);
            if (pc instanceof JPolicyConfiguration) {
                jPolicyConfiguration = (JPolicyConfiguration)pc;
            } else {
                jPolicyConfiguration = JPolicyConfigurationKeeper.getConfiguration(contextID);
                if (jPolicyConfiguration == null) {
                    throw new RuntimeException("This policy provider can only manage JPolicyConfiguration objects");
                }
            }
        }
        catch (PolicyContextException pce) {
            logger.error((Object)"JPolicy.implies.canNotRetrieve", new Object[]{contextID, pce});
            return false;
        }
        PermissionCollection excludedPermissions = jPolicyConfiguration.getExcludedPermissions();
        PermissionCollection uncheckedPermissions = jPolicyConfiguration.getUncheckedPermissions();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Check permission", new Object[0]);
            logger.debug((Object)("Excluded permissions = " + excludedPermissions), new Object[0]);
            logger.debug((Object)("unchecked permissions = " + uncheckedPermissions), new Object[0]);
        }
        if (excludedPermissions.implies(permission)) {
            logger.debug((Object)"Permission ''{0}'' is excluded, return false", new Object[]{permission});
            return false;
        }
        if (uncheckedPermissions.implies(permission)) {
            logger.debug((Object)"Permission ''{0}'' is unchecked, return true", new Object[]{permission});
            return true;
        }
        if (domain.getPrincipals().length > 0) {
            logger.debug((Object)"There are principals, checking principals...", new Object[0]);
            return this.isImpliedPermissionForPrincipals(jPolicyConfiguration, permission, domain.getPrincipals());
        }
        logger.debug((Object)"Principals length = 0, there is no principal on this domain", new Object[0]);
        logger.debug((Object)"Permission ''{0}'' not found, return false", new Object[]{permission});
        return false;
    }

    public PermissionCollection getPermissions(ProtectionDomain domain) {
        return initialPolicy.getPermissions(domain);
    }

    public PermissionCollection getPermissions(CodeSource codeSource) {
        return initialPolicy.getPermissions(codeSource);
    }

    public void refresh() {
        initialPolicy.refresh();
    }

    private boolean isImpliedPermissionForPrincipals(JPolicyConfiguration jPolicyConfiguration, Permission permission, Principal[] principals) {
        PermissionCollection permissions = null;
        boolean implied = false;
        for (int i = 0; i < principals.length && !implied; ++i) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Checking permission ''{0}'' with permissions of Principal ''{1}''.", new Object[]{permission, principals[i].getName()});
            }
            if (!(permissions = jPolicyConfiguration.getPermissionsForPrincipal(principals[i])).implies(permission)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Permission implied with principal ''{0}''.", new Object[]{principals[i].getName()});
            }
            implied = true;
        }
        if (!implied) {
            logger.debug((Object)"Permission ''{0}'' was not found in each permissions of the given roles, return false", new Object[]{permission});
        }
        return implied;
    }
}

