/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.statistic;

import java.util.LinkedList;
import java.util.List;
import org.ow2.easybeans.api.event.EZBEventListener;
import org.ow2.easybeans.api.event.EZBEventManager;
import org.ow2.easybeans.api.jmx.EZBMBeanAttribute;
import org.ow2.easybeans.api.jmx.EZBMBeanOperation;
import org.ow2.easybeans.api.statistic.EZBStatistic;
import org.ow2.easybeans.component.itf.EZBEventComponent;
import org.ow2.easybeans.component.itf.EZBJmxComponent;
import org.ow2.easybeans.statistic.StatisticEventManager;

public abstract class AbstractStatistic
implements EZBStatistic {
    private String name;
    private String description;
    private String unit;
    private long startTime;
    private long lastTime;
    private boolean available;
    private String statisticFactoryId;
    private String statisticProviderId;
    private EZBJmxComponent jmxComponent;
    private EZBEventManager eventManager = null;
    private List<EZBMBeanAttribute> mbeanAttributes;
    private List<EZBMBeanOperation> mbeanOperations;

    public AbstractStatistic(String name, String description, String unit, String statisticFactoryId, String statisticProviderId, EZBEventComponent eventComponent, EZBJmxComponent jmxComponent) {
        this.name = name;
        this.description = description;
        this.unit = unit;
        this.startTime = System.currentTimeMillis();
        this.lastTime = System.currentTimeMillis();
        this.available = false;
        this.statisticFactoryId = statisticFactoryId;
        this.statisticProviderId = statisticProviderId;
        this.jmxComponent = jmxComponent;
        this.eventManager = new StatisticEventManager(eventComponent);
        this.mbeanAttributes = new LinkedList<EZBMBeanAttribute>();
        this.mbeanOperations = new LinkedList<EZBMBeanOperation>();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUnit() {
        return this.unit;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getLastSampleTime() {
        return this.lastTime;
    }

    public void setLastSampleTime(long lastTime) {
        this.lastTime = lastTime;
    }

    public String getStatisticId() {
        return this.getStatisticProviderId().replace(":", "\\:") + "::" + this.getStatisticFactoryId().replace(":", "\\:");
    }

    public String getStatisticFactoryId() {
        return this.statisticFactoryId;
    }

    public String getStatisticProviderId() {
        return this.statisticProviderId;
    }

    public synchronized void reset() {
        this.startTime = System.currentTimeMillis();
        this.lastTime = System.currentTimeMillis();
    }

    public synchronized void activate() {
        if (!this.available) {
            this.available = true;
            for (EZBEventListener eventListener : this.eventManager.getEventListeners()) {
                this.eventManager.getEventComponent().registerEventListener(eventListener);
            }
            for (EZBMBeanAttribute mbeanAttribute : this.mbeanAttributes) {
                this.jmxComponent.registerMBeanAttribute(mbeanAttribute);
            }
            for (EZBMBeanOperation mbeanOperation : this.mbeanOperations) {
                this.jmxComponent.registerMBeanOperation(mbeanOperation);
            }
        }
    }

    public synchronized void deactivate() {
        if (this.available) {
            this.available = false;
            for (EZBEventListener eventListener : this.eventManager.getEventListeners()) {
                this.eventManager.getEventComponent().unregisterEventListener(eventListener);
            }
            for (EZBMBeanAttribute mbeanAttribute : this.mbeanAttributes) {
                this.jmxComponent.unregisterMBeanAttribute(mbeanAttribute);
            }
            for (EZBMBeanOperation mbeanOperation : this.mbeanOperations) {
                this.jmxComponent.unregisterMBeanOperation(mbeanOperation);
            }
        }
    }

    public synchronized boolean isAvailable() {
        return this.available;
    }

    protected EZBEventComponent getEventComponent() {
        return this.eventManager.getEventComponent();
    }

    protected EZBJmxComponent getJmxComponent() {
        return this.jmxComponent;
    }

    protected synchronized void addEventListener(EZBEventListener eventListener) {
        this.eventManager.addEventListener(eventListener);
        if (this.available) {
            this.eventManager.getEventComponent().registerEventListener(eventListener);
        }
    }

    protected synchronized void removeEventListener(EZBEventListener eventListener) {
        this.eventManager.getEventListeners().remove(eventListener);
        if (this.available) {
            this.eventManager.getEventComponent().unregisterEventListener(eventListener);
        }
    }

    protected synchronized void addMBeanAttribute(EZBMBeanAttribute mbeanAttribute) {
        this.mbeanAttributes.add(mbeanAttribute);
        if (this.available) {
            this.jmxComponent.registerMBeanAttribute(mbeanAttribute);
        }
    }

    protected synchronized void removeMBeanAttribute(EZBMBeanAttribute mbeanAttribute) {
        this.mbeanAttributes.remove(mbeanAttribute);
        if (this.available) {
            this.jmxComponent.unregisterMBeanAttribute(mbeanAttribute);
        }
    }

    protected synchronized void addMBeanOperation(EZBMBeanOperation mbeanOperation) {
        this.mbeanOperations.add(mbeanOperation);
        if (this.available) {
            this.jmxComponent.registerMBeanOperation(mbeanOperation);
        }
    }

    protected synchronized void removeMBeanOperation(EZBMBeanOperation mbeanOperation) {
        this.mbeanOperations.remove(mbeanOperation);
        if (this.available) {
            this.jmxComponent.unregisterMBeanOperation(mbeanOperation);
        }
    }

    public EZBEventManager getEventManager() {
        return this.eventManager;
    }

    public void setEventManager(EZBEventManager eventManager) {
        this.eventManager = eventManager;
    }
}

