/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.statistic;

import javax.management.j2ee.statistics.CountStatistic;
import org.ow2.easybeans.api.event.EZBEventListener;
import org.ow2.easybeans.api.event.bean.EZBEventBeanInvocationEnd;
import org.ow2.easybeans.api.jmx.EZBMBeanAttribute;
import org.ow2.easybeans.api.statistic.EZBStatistic;
import org.ow2.easybeans.component.itf.EZBEventComponent;
import org.ow2.easybeans.component.itf.EZBJmxComponent;
import org.ow2.easybeans.naming.J2EEManagedObjectNamingHelper;
import org.ow2.easybeans.statistic.AbstractStatistic;
import org.ow2.easybeans.statistic.AbstractStatisticFactory;
import org.ow2.util.event.api.EventPriority;
import org.ow2.util.event.api.IEvent;
import org.ow2.util.jmx.impl.AbstractMBeanAttribute;

public class CallCountStatisticFactory
extends AbstractStatisticFactory {
    public CallCountStatisticFactory(EZBEventComponent eventComponent, EZBJmxComponent jmxComponent) {
        super(J2EEManagedObjectNamingHelper.getAllJ2EEManagedObjectsFilter(), eventComponent, jmxComponent);
    }

    public EZBStatistic createStatistic(String statisticProviderId) {
        return new CallCountStatistic(statisticProviderId);
    }

    public class CallCountStatistic
    extends AbstractStatistic {
        private long count;

        public CallCountStatistic(String statisticProviderId) {
            super(statisticProviderId.matches(J2EEManagedObjectNamingHelper.getAllMethodsFilter()) ? "numberOfCalls_" + statisticProviderId.substring(statisticProviderId.lastIndexOf("/") + 1) : "numberOfCalls", "The number of calls", "", CallCountStatisticFactory.this.getStatisticFactoryId(), statisticProviderId, CallCountStatisticFactory.this.getEventComponent(), CallCountStatisticFactory.this.getJmxComponent());
            this.addEventListener(new CallCountEventListener());
            this.addMBeanAttribute(new CallCountMBeanAttribute());
        }

        public synchronized void reset() {
            super.reset();
            this.count = 0L;
        }

        public synchronized String getValue() {
            return this.count + this.getUnit();
        }

        public synchronized CountStatistic getJSR77Statistic() {
            return new CountStatistic(){

                public String getName() {
                    return CallCountStatistic.this.getName();
                }

                public String getDescription() {
                    return CallCountStatistic.this.getDescription();
                }

                public String getUnit() {
                    return CallCountStatistic.this.getUnit();
                }

                public long getStartTime() {
                    return CallCountStatistic.this.getStartTime();
                }

                public long getLastSampleTime() {
                    return CallCountStatistic.this.getLastSampleTime();
                }

                public long getCount() {
                    return CallCountStatistic.this.count;
                }
            };
        }

        private class CallCountMBeanAttribute
        extends AbstractMBeanAttribute
        implements EZBMBeanAttribute {
            public String getMBeanProviderFilter() {
                return J2EEManagedObjectNamingHelper.encodeJ2EEManagedObjectFilter(CallCountStatistic.this.getStatisticProviderId());
            }

            public CallCountMBeanAttribute() {
                super(CallCountStatistic.this.getName(), CallCountStatistic.this.getUnit(), CallCountStatistic.this.getDescription(), true, false, false);
            }

            public Object getValue(String id) {
                return CallCountStatistic.this.count;
            }

            public void setValue(String id, Object value) {
            }
        }

        private class CallCountEventListener
        implements EZBEventListener {
            private String eventProviderFilter;

            public CallCountEventListener() {
                this.eventProviderFilter = J2EEManagedObjectNamingHelper.getAllRelativeMethodsFilter(CallCountStatistic.this.getStatisticProviderId());
            }

            public String getEventProviderFilter() {
                return this.eventProviderFilter;
            }

            public boolean accept(IEvent event) {
                try {
                    return ((EZBEventBeanInvocationEnd)event).getEventProviderId().matches(this.getEventProviderFilter());
                }
                catch (Throwable error) {
                    return false;
                }
            }

            public EventPriority getPriority() {
                return EventPriority.ASYNC_LOW;
            }

            public synchronized void handle(IEvent event) {
                CallCountStatistic.this.count++;
                CallCountStatistic.this.setLastSampleTime(System.currentTimeMillis());
            }
        }
    }
}

