/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.transaction;

import java.rmi.RemoteException;
import javax.ejb.EJBException;
import javax.ejb.SessionSynchronization;
import javax.transaction.Synchronization;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.api.OperationState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionSynchronizationListener
implements Synchronization {
    private SessionSynchronization synchronizedBean = null;
    private Factory<?, ?> factory = null;
    private boolean ready = true;

    public SessionSynchronizationListener(SessionSynchronization synchronizedBean, Factory<?, ?> factory) {
        this.synchronizedBean = synchronizedBean;
        this.factory = factory;
    }

    public void beforeCompletion() {
        OperationState oldState = this.factory.getOperationState();
        this.factory.getOperationStateThreadLocal().set(OperationState.BEFORE_COMPLETION);
        try {
            try {
                this.synchronizedBean.beforeCompletion();
            }
            catch (EJBException e) {
                throw e;
            }
            catch (RemoteException e) {
                throw new EJBException("Error in beforeCompletion()", (Exception)e);
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.factory.getOperationStateThreadLocal().set(oldState);
            throw throwable;
        }
        this.factory.getOperationStateThreadLocal().set(oldState);
    }

    public void afterCompletion(int status) {
        OperationState oldState = this.factory.getOperationState();
        this.factory.getOperationStateThreadLocal().set(OperationState.AFTER_COMPLETION);
        try {
            try {
                this.synchronizedBean.afterCompletion(status == 3);
            }
            catch (EJBException e) {
                throw e;
            }
            catch (RemoteException e) {
                throw new EJBException("Error in afterCompletion()", (Exception)e);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.factory.getOperationStateThreadLocal().set(oldState);
            this.ready = true;
            throw throwable;
        }
        this.factory.getOperationStateThreadLocal().set(oldState);
        this.ready = true;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void inTX() {
        this.ready = false;
    }
}

