/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.transaction.interceptors;

import javax.ejb.EJBException;
import javax.ejb.EJBTransactionRequiredException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.ow2.easybeans.api.EasyBeansInvocationContext;
import org.ow2.easybeans.transaction.interceptors.AbsTransactionInterceptor;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class CMTMandatoryTransactionInterceptor
extends AbsTransactionInterceptor {
    private Log logger = LogFactory.getLog(CMTMandatoryTransactionInterceptor.class);

    public Object intercept(EasyBeansInvocationContext invocationContext) throws Exception {
        Transaction transaction;
        this.logger.debug((Object)"Calling Mandatory TX interceptor", new Object[0]);
        try {
            transaction = this.getTransactionManager().getTransaction();
        }
        catch (SystemException se) {
            throw new EJBException("Cannot get the current transaction on transaction manager.", (Exception)((Object)se));
        }
        this.logger.debug((Object)"Transaction found = {0}", new Object[]{transaction});
        if (transaction == null) {
            this.logger.warn((Object)"Mandatory as transaction attribute and not in transaction", new Object[0]);
            throw new EJBTransactionRequiredException("Client should call with a transaction context in MANDATORY mode.");
        }
        try {
            return invocationContext.proceed();
        }
        catch (Exception e) {
            this.handleContextClientTransaction(invocationContext, e);
            return null;
        }
    }
}

