/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.make.component;

import aQute.bnd.annotation.component.Activate;
import aQute.bnd.annotation.component.Component;
import aQute.bnd.annotation.component.Deactivate;
import aQute.bnd.annotation.component.Modified;
import aQute.bnd.annotation.component.Reference;
import aQute.lib.osgi.Annotation;
import aQute.lib.osgi.ClassDataCollector;
import aQute.lib.osgi.Clazz;
import aQute.lib.osgi.Processor;
import aQute.lib.osgi.Verifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentAnnotationReader
extends ClassDataCollector {
    static Pattern BINDDESCRIPTOR = Pattern.compile("\\(L(.*);\\)V");
    static Pattern BINDMETHOD = Pattern.compile("(set|bind|add)(.)(.*)");
    String method;
    String methodDescriptor;
    String className;
    Clazz clazz;
    String[] interfaces;
    Set<String> multiple = new HashSet<String>();
    Set<String> optional = new HashSet<String>();
    Set<String> dynamic = new HashSet<String>();
    Map<String, String> map = new HashMap<String, String>();
    List<String> properties = new ArrayList<String>();
    static Pattern PROPERTY_PATTERN = Pattern.compile("[^=]+=.+");

    ComponentAnnotationReader(Clazz clazz) {
        this.clazz = clazz;
    }

    public static Map<String, String> getDefiniton(Clazz c) throws Exception {
        ComponentAnnotationReader r = new ComponentAnnotationReader(c);
        c.parseClassFileWithCollector(r);
        r.finish();
        return r.map;
    }

    @Override
    public void annotation(Annotation annotation) {
        if (annotation.getName().equals(Component.RNAME)) {
            String[] p;
            this.set("name:", annotation.get("name"), "<>");
            this.setBoolean("factory:", annotation.get("factory"), false);
            this.setBoolean("enabled:", annotation.get("enabled"), true);
            this.setBoolean("immediate:", annotation.get("immediate"), false);
            this.setBoolean("servicefactory:", annotation.get("servicefactory"), false);
            this.set("configuration-policy:", annotation.get("configurationPolicy"), "<>");
            this.doProperties(annotation);
            Object[] provides = (Object[])annotation.get("provide");
            if (provides == null) {
                if (this.interfaces != null) {
                    p = new String[this.interfaces.length];
                    int i = 0;
                    while (i < this.interfaces.length) {
                        p[i] = this.interfaces[i].replace('/', '.');
                        ++i;
                    }
                } else {
                    p = new String[]{};
                }
            } else {
                p = new String[provides.length];
                int i = 0;
                while (i < provides.length) {
                    p[i] = this.descriptorToFQN(provides[i].toString());
                    ++i;
                }
            }
            if (p.length > 0) {
                this.set("provide:", Processor.join(Arrays.asList(p)), "<>");
            }
        } else if (annotation.getName().equals(Activate.RNAME)) {
            this.set("activate:", this.method, "<>");
        } else if (annotation.getName().equals(Deactivate.RNAME)) {
            this.set("deactivate:", this.method, "<>");
        } else if (annotation.getName().equals(Modified.RNAME)) {
            this.set("modified:", this.method, "<>");
        } else if (annotation.getName().equals(Reference.RNAME)) {
            Integer c;
            String service;
            String name = (String)annotation.get("name");
            String bind = this.method;
            String unbind = null;
            if (name == null) {
                Matcher m = BINDMETHOD.matcher(this.method);
                if (m.matches()) {
                    name = String.valueOf(m.group(2).toLowerCase()) + m.group(3);
                    if (m.group(1).equals("set")) {
                        bind = null;
                    }
                } else {
                    name = this.method.toLowerCase();
                }
            }
            unbind = (String)annotation.get("unbind");
            if (bind != null) {
                name = String.valueOf(name) + "/" + bind;
                if (unbind != null) {
                    name = String.valueOf(name) + "/" + unbind;
                }
            }
            if ((service = (String)annotation.get("service")) != null) {
                service = service.substring(1, service.length() - 1).replace('/', '.');
            } else {
                Matcher m = BINDDESCRIPTOR.matcher(this.methodDescriptor);
                if (m.matches()) {
                    service = m.group(1).replace('/', '.');
                } else {
                    throw new IllegalArgumentException("Cannot detect the type of a Component Reference from the descriptor: " + this.methodDescriptor);
                }
            }
            String target = (String)annotation.get("target");
            if (target != null) {
                Verifier.verifyFilter(target, 0);
                service = String.valueOf(service) + target;
            }
            if ((c = (Integer)annotation.get("type")) != null && !c.equals(0) && !c.equals(49)) {
                service = String.valueOf(service) + (char)c.intValue();
            }
            this.map.put(name, service);
            if (this.isTrue(annotation.get("multiple"))) {
                this.multiple.add(name);
            }
            if (this.isTrue(annotation.get("optional"))) {
                this.optional.add(name);
            }
            if (this.isTrue(annotation.get("dynamic"))) {
                this.dynamic.add(name);
            }
        }
    }

    private void doProperties(Annotation annotation) {
        Object[] properties = (Object[])annotation.get("properties");
        if (properties != null) {
            Object[] objectArray = properties;
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                String p = (String)o;
                if (!PROPERTY_PATTERN.matcher(p).matches()) {
                    throw new IllegalArgumentException("Malformed property '" + p + "' on: " + annotation.get("name"));
                }
                this.properties.add(p);
                ++n2;
            }
        }
    }

    private boolean isTrue(Object object) {
        if (object == null) {
            return false;
        }
        return (Boolean)object;
    }

    private void setBoolean(String string, Object object, boolean b) {
        Boolean bb;
        if (object == null) {
            object = b;
        }
        if ((bb = (Boolean)object) == b) {
            return;
        }
        this.map.put(string, bb.toString());
    }

    private void set(String string, Object object, Object deflt) {
        if (object == null || object.equals(deflt)) {
            return;
        }
        this.map.put(string, object.toString());
    }

    private String descriptorToFQN(String string) {
        StringBuilder sb = new StringBuilder();
        int i = 1;
        while (i < string.length() - 1) {
            char c = string.charAt(i);
            if (c == '/') {
                c = '.';
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    @Override
    public void classBegin(int access, String name) {
        this.className = name;
    }

    @Override
    public void implementsInterfaces(String[] interfaces) {
        this.interfaces = interfaces;
    }

    @Override
    public void method(int access, String name, String descriptor) {
        this.method = name;
        this.methodDescriptor = descriptor;
    }

    void set(String name, Collection<String> l) {
        if (l.size() == 0) {
            return;
        }
        this.set(name, Processor.join(l), "<>");
    }

    public void finish() {
        this.set("multiple:", this.multiple);
        this.set("dynamic:", this.dynamic);
        this.set("optional:", this.optional);
        this.set("implementation:", this.clazz.getFQN(), "<>");
        this.set("properties:", this.properties);
    }
}

