/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.plugin;

import aQute.bnd.build.Project;
import aQute.bnd.build.Workspace;
import aQute.bnd.classpath.ModelListener;
import aQute.bnd.plugin.Activator;
import aQute.bnd.service.Refreshable;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.osgi.framework.BundleContext;

public class Central
implements IResourceChangeListener {
    static IWorkspace iworkspace;
    final Map<IJavaProject, Project> javaProjectToModel = new HashMap<IJavaProject, Project>();
    final List<ModelListener> listeners = new CopyOnWriteArrayList<ModelListener>();
    static Workspace workspace;
    final BundleContext context;
    final Workspace ws;

    Central(BundleContext context) throws Exception {
        this.context = context;
        iworkspace = ResourcesPlugin.getWorkspace();
        iworkspace.addResourceChangeListener((IResourceChangeListener)this);
        this.ws = Central.getWorkspace();
        context.registerService(Workspace.class.getName(), (Object)this.ws, null);
    }

    public Project getModel(IJavaProject project) {
        try {
            Project model = this.javaProjectToModel.get(project);
            if (model == null) {
                File projectDir = project.getProject().getLocation().makeAbsolute().toFile();
                model = Workspace.getProject(projectDir);
                if (workspace == null) {
                    model.getWorkspace();
                }
                if (model != null) {
                    this.javaProjectToModel.put(project, model);
                }
            }
            return model;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() != 1) {
            return;
        }
        IResourceDelta rootDelta = event.getDelta();
        try {
            final HashSet changed = new HashSet();
            rootDelta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    block6: {
                        File file;
                        block7: {
                            try {
                                IPath location = delta.getResource().getLocation();
                                if (location == null) {
                                    System.out.println("Cannot convert resource to file: " + delta.getResource());
                                    break block6;
                                }
                                file = location.toFile();
                                File parent = file.getParentFile();
                                boolean parentIsWorkspace = parent.equals(Central.getWorkspace().getBase());
                                if (parent == null || !parentIsWorkspace) break block6;
                                if (!file.getName().equals("cnf")) break block7;
                                if (workspace.refresh()) {
                                    changed.addAll(workspace.getCurrentProjects());
                                }
                                return false;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                throw new CoreException((IStatus)new Status(4, "aQute.bmaker", "During checking project changes", (Throwable)e));
                            }
                        }
                        if (workspace.isPresent(file.getName())) {
                            Project project = workspace.getProject(file.getName());
                            changed.add(project);
                        }
                        return false;
                    }
                    return true;
                }
            });
            for (Project p : changed) {
                p.refresh();
                this.changed(p);
            }
        }
        catch (CoreException e) {
            Activator.getDefault().error("While handling changes", e);
            e.printStackTrace();
        }
    }

    public static Workspace getWorkspace() throws Exception {
        IPath path;
        if (workspace != null) {
            return workspace;
        }
        IResource resource = iworkspace.getRoot().findMember("/cnf/build.bnd");
        if (resource != null && (path = resource.getLocation()) != null) {
            File f = path.toFile();
            workspace = Workspace.getWorkspace(f.getAbsoluteFile().getParentFile().getParentFile().getAbsoluteFile());
            return workspace;
        }
        workspace = Workspace.getWorkspace(iworkspace.getRoot().getLocation().toFile());
        return workspace;
    }

    public void changed(Project model) {
        model.setChanged();
        for (ModelListener m : this.listeners) {
            try {
                m.modelChanged(model);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void addModelListener(ModelListener m) {
        if (!this.listeners.contains(m)) {
            this.listeners.add(m);
        }
    }

    public void removeModelListener(ModelListener m) {
        this.listeners.remove(m);
    }

    public IJavaProject getJavaProject(Project model) {
        IProject[] iProjectArray = iworkspace.getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject ij;
            IProject iproj = iProjectArray[n2];
            if (iproj.getName().equals(model.getName()) && (ij = JavaCore.create((IProject)iproj)) != null && ij.exists()) {
                return ij;
            }
            ++n2;
        }
        return null;
    }

    public static IPath toPath(Project project, File file) {
        String workspace;
        String path = file.getAbsolutePath();
        if (!path.startsWith(workspace = project.getWorkspace().getBase().getAbsolutePath())) {
            return null;
        }
        path = path.substring(workspace.length());
        Path p = new Path(path);
        return p;
    }

    public static void refresh(IPath path) {
        try {
            IResource r = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            if (r != null) {
                return;
            }
            IPath p = (IPath)path.clone();
            while (p.segmentCount() > 0) {
                p = p.removeLastSegments(1);
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(p);
                if (resource == null) continue;
                resource.refreshLocal(2, null);
                return;
            }
        }
        catch (ResourceException re) {
            System.out.println("Ignoring resource exception: " + (Object)((Object)re));
        }
        catch (Exception e) {
            Activator.getDefault().error("While refreshing path " + path, e);
        }
        System.out.println("Unexpectedly could not find path in workspace: " + path);
    }

    public void refreshPlugins() throws Exception {
        List<Refreshable> rps = Central.getWorkspace().getPlugins(Refreshable.class);
        for (Refreshable rp : rps) {
            if (!rp.refresh()) continue;
            File dir = rp.getRoot();
            this.refreshFile(dir);
        }
    }

    public void refreshFile(File f) throws Exception {
        String path = this.toLocal(f);
        IResource r = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (r != null) {
            r.refreshLocal(2, null);
        }
    }

    public void refresh(Project p) throws Exception {
        IJavaProject jp = this.getJavaProject(p);
        if (jp != null) {
            jp.getProject().refreshLocal(2, null);
        }
    }

    private String toLocal(File f) throws Exception {
        String root = Central.getWorkspace().getBase().getAbsolutePath();
        String path = f.getAbsolutePath().substring(root.length());
        return path;
    }

    public void close() {
    }
}

