/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.jndi.spi;

import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.ow2.carol.rmi.exception.NamingExceptionHelper;
import org.ow2.carol.util.configuration.ConfigurationRepository;
import org.ow2.carol.util.configuration.ProtocolConfiguration;
import org.ow2.carol.util.configuration.TraceCarol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiContext
implements Context {
    private Map<ProtocolConfiguration, Context> contextsOfConfigurations = null;
    private Context currentInitialContext = null;
    private Hashtable<Object, Object> environment = null;

    public MultiContext(Hashtable<?, ?> env) throws NamingException {
        this.environment = new Hashtable(env);
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiContext.MultiContext(env), env = " + env);
        }
        String activeConfigName = null;
        try {
            activeConfigName = ConfigurationRepository.getCurrentConfiguration().getName();
        }
        catch (Error err) {
            throw NamingExceptionHelper.create("Could not get a configuration", err);
        }
        ProtocolConfiguration[] protocolConfigurations = ConfigurationRepository.getConfigurations();
        this.contextsOfConfigurations = new LinkedHashMap<ProtocolConfiguration, Context>();
        for (ProtocolConfiguration protocolConfiguration : protocolConfigurations) {
            Context ctx = protocolConfiguration.getInitialContext(env);
            if (protocolConfiguration.getName().equals(activeConfigName)) {
                this.currentInitialContext = ctx;
            }
            this.contextsOfConfigurations.put(protocolConfiguration, ctx);
        }
        if (this.currentInitialContext == null) {
            throw new NamingException("No current initial context was set. Active environment was '" + activeConfigName + "'. Error in carol with environment = " + env);
        }
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.currentInitialContext.lookup(name);
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.currentInitialContext.lookup(name);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        for (ProtocolConfiguration protocolConfiguration : this.contextsOfConfigurations.keySet()) {
            ProtocolConfiguration old = ConfigurationRepository.setCurrentConfiguration(protocolConfiguration);
            this.contextsOfConfigurations.get(protocolConfiguration).bind(name, obj);
            ConfigurationRepository.setCurrentConfiguration(old);
        }
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        for (ProtocolConfiguration protocolConfiguration : this.contextsOfConfigurations.keySet()) {
            ProtocolConfiguration old = ConfigurationRepository.setCurrentConfiguration(protocolConfiguration);
            this.contextsOfConfigurations.get(protocolConfiguration).bind(name, obj);
            ConfigurationRepository.setCurrentConfiguration(old);
        }
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        for (ProtocolConfiguration protocolConfiguration : this.contextsOfConfigurations.keySet()) {
            ProtocolConfiguration old = ConfigurationRepository.setCurrentConfiguration(protocolConfiguration);
            this.contextsOfConfigurations.get(protocolConfiguration).rebind(name, obj);
            ConfigurationRepository.setCurrentConfiguration(old);
        }
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        for (ProtocolConfiguration protocolConfiguration : this.contextsOfConfigurations.keySet()) {
            ProtocolConfiguration old = ConfigurationRepository.setCurrentConfiguration(protocolConfiguration);
            this.contextsOfConfigurations.get(protocolConfiguration).rebind(name, obj);
            ConfigurationRepository.setCurrentConfiguration(old);
        }
    }

    @Override
    public void unbind(String name) throws NamingException {
        for (ProtocolConfiguration protocolConfiguration : this.contextsOfConfigurations.keySet()) {
            ProtocolConfiguration old = ConfigurationRepository.setCurrentConfiguration(protocolConfiguration);
            this.contextsOfConfigurations.get(protocolConfiguration).unbind(name);
            ConfigurationRepository.setCurrentConfiguration(old);
        }
    }

    @Override
    public void unbind(Name name) throws NamingException {
        for (ProtocolConfiguration protocolConfiguration : this.contextsOfConfigurations.keySet()) {
            ProtocolConfiguration old = ConfigurationRepository.setCurrentConfiguration(protocolConfiguration);
            this.contextsOfConfigurations.get(protocolConfiguration).unbind(name);
            ConfigurationRepository.setCurrentConfiguration(old);
        }
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        for (ProtocolConfiguration protocolConfiguration : this.contextsOfConfigurations.keySet()) {
            ProtocolConfiguration old = ConfigurationRepository.setCurrentConfiguration(protocolConfiguration);
            this.contextsOfConfigurations.get(protocolConfiguration).rename(oldName, newName);
            ConfigurationRepository.setCurrentConfiguration(old);
        }
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        for (ProtocolConfiguration protocolConfiguration : this.contextsOfConfigurations.keySet()) {
            ProtocolConfiguration old = ConfigurationRepository.setCurrentConfiguration(protocolConfiguration);
            this.contextsOfConfigurations.get(protocolConfiguration).rename(oldName, newName);
            ConfigurationRepository.setCurrentConfiguration(old);
        }
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        return this.currentInitialContext.list(name);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.currentInitialContext.list(name);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        return this.currentInitialContext.listBindings(name);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.currentInitialContext.listBindings(name);
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        for (ProtocolConfiguration protocolConfiguration : this.contextsOfConfigurations.keySet()) {
            ProtocolConfiguration old = ConfigurationRepository.setCurrentConfiguration(protocolConfiguration);
            this.contextsOfConfigurations.get(protocolConfiguration).destroySubcontext(name);
            ConfigurationRepository.setCurrentConfiguration(old);
        }
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        for (ProtocolConfiguration protocolConfiguration : this.contextsOfConfigurations.keySet()) {
            ProtocolConfiguration old = ConfigurationRepository.setCurrentConfiguration(protocolConfiguration);
            this.contextsOfConfigurations.get(protocolConfiguration).destroySubcontext(name);
            ConfigurationRepository.setCurrentConfiguration(old);
        }
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.currentInitialContext.createSubcontext(name);
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.currentInitialContext.createSubcontext(name);
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.currentInitialContext.lookupLink(name);
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.currentInitialContext.lookupLink(name);
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return this.currentInitialContext.getNameParser(name);
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.currentInitialContext.getNameParser(name);
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return name;
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        return this.currentInitialContext.composeName(name, prefix);
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        if (ConfigurationRepository.isMultiEnvironment()) {
            return this.environment.put(propName, propVal);
        }
        return this.currentInitialContext.addToEnvironment(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        if (ConfigurationRepository.isMultiEnvironment()) {
            return this.environment.remove(propName);
        }
        return this.currentInitialContext.removeFromEnvironment(propName);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        if (ConfigurationRepository.isMultiEnvironment()) {
            return this.environment;
        }
        return this.currentInitialContext.getEnvironment();
    }

    @Override
    public void close() throws NamingException {
        for (ProtocolConfiguration protocolConfiguration : this.contextsOfConfigurations.keySet()) {
            ProtocolConfiguration old = ConfigurationRepository.setCurrentConfiguration(protocolConfiguration);
            this.contextsOfConfigurations.get(protocolConfiguration).close();
            ConfigurationRepository.setCurrentConfiguration(old);
        }
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.currentInitialContext.getNameInNamespace();
    }
}

