/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.util.configuration;

import org.ow2.carol.util.configuration.ConfigurationException;

public class ConfigurationUtil {
    private ConfigurationUtil() {
    }

    public static int getPortOfUrl(String url) throws ConfigurationException {
        int portNumber = 0;
        int closingBrac = -1;
        String hostPort = ConfigurationUtil.extractHostPort(url);
        if (hostPort.startsWith("[") && (closingBrac = hostPort.indexOf(93, 1)) < 0) {
            throw new ConfigurationException("Missing the closing bracket in the following IPv6 address: " + hostPort);
        }
        int m = hostPort.indexOf(58, closingBrac + 1);
        try {
            if (m > -1) {
                if (m == 0) {
                    if (hostPort.length() > 1) {
                        portNumber = Integer.parseInt(hostPort.substring(1));
                    }
                } else if (hostPort.length() > m + 1) {
                    portNumber = Integer.parseInt(hostPort.substring(m + 1));
                }
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("Invalid URL '" + url + "'. It should be on the format <protocol>://<hostname>:<port>");
        }
        return portNumber;
    }

    public static String getHostOfUrl(String url) throws ConfigurationException {
        String host = null;
        int closingBrac = -1;
        String hostPort = ConfigurationUtil.extractHostPort(url);
        if (hostPort.startsWith("[") && (closingBrac = hostPort.indexOf(93, 1)) < 0) {
            throw new ConfigurationException("Missing the closing bracket in the following IPv6 address: " + hostPort);
        }
        int m = hostPort.indexOf(58, closingBrac + 1);
        try {
            if (m > 0) {
                host = hostPort.substring(0, m);
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("Invalid URL '" + url + "'. It should be on the format <protocol>://<hostname>:<port>");
        }
        return host;
    }

    private static String extractHostPort(String url) throws ConfigurationException {
        int comma;
        String hostPort = url.substring(url.indexOf("://") + 3);
        int slash = hostPort.indexOf("/");
        if (slash > -1) {
            hostPort = hostPort.substring(0, slash);
        }
        if ((comma = hostPort.indexOf(",")) > -1) {
            hostPort = hostPort.substring(0, comma);
        }
        return hostPort;
    }
}

