/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.cluster.daemon;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.util.Properties;
import org.ow2.carol.rmi.util.PortNumber;
import org.ow2.carol.util.configuration.ConfigurationRepository;
import org.ow2.carol.util.configuration.ProtocolConfiguration;
import org.ow2.jonas.cluster.daemon.ClusterDaemonException;
import org.ow2.jonas.deployment.clusterd.ClusterDaemonConfiguration;
import org.ow2.jonas.deployment.clusterd.ClusterDaemonConfigurationException;
import org.ow2.jonas.deployment.clusterd.lib.ClusterDaemonConfigurationManager;
import org.ow2.jonas.lib.bootstrap.JProp;

public class ClusterDaemonTools {
    public static Long ONE_MEGA = new Long(1024L);
    private static ClusterDaemonConfiguration currentConfiguration = null;
    private static String currentConfigurationFileName = null;

    private ClusterDaemonTools() {
    }

    public static String initCarol() throws ClusterDaemonException {
        System.setProperty("carol.server.mode", "true");
        String carolFile = null;
        try {
            File fConf = null;
            if (carolFile == null) {
                File jonasBaseConf = new File(JProp.getJonasBase(), "conf");
                URL myCarolFile = new File(jonasBaseConf, "carol.properties").toURI().toURL();
                if (myCarolFile == null) {
                    fConf = new File(System.getProperty("java.io.tmpdir") + File.separator + "cs-carol.properties");
                    try {
                        FileWriter fw = new FileWriter(fConf);
                        fw.write("carol.protocols=irmi\n");
                        fw.write("carol.irmi.url=rmi://localhost:1806\n");
                        ((Writer)fw).close();
                    }
                    catch (IOException e) {
                        throw new ClusterDaemonException("Cannot initialize carol", e);
                    }
                } else {
                    fConf = new File(myCarolFile.getFile());
                }
            } else {
                fConf = new File(carolFile);
            }
            ConfigurationRepository.init((URL)fConf.toURL());
        }
        catch (Exception e) {
            throw new ClusterDaemonException("Cannot initialize carol", e);
        }
        return carolFile;
    }

    public static String getJmxUrl(String cdName) throws ClusterDaemonException {
        String serviceURL = null;
        try {
            ClusterDaemonTools.initCarol();
            ProtocolConfiguration protocolConfiguration = ConfigurationRepository.getCurrentConfiguration();
            ConfigurationRepository.setCurrentConfiguration((ProtocolConfiguration)protocolConfiguration);
            String carolProtocol = protocolConfiguration.getName();
            String providerUrl = protocolConfiguration.getProviderURL();
            URI carolURL = new URI(providerUrl);
            String host = carolURL.getHost();
            String port = String.valueOf(carolURL.getPort());
            String scheme = carolURL.getScheme();
            if (scheme.equals("rmi") && carolProtocol.equals("jrmp")) {
                String myName = "jrmpconnector_" + cdName;
                serviceURL = "service:jmx:rmi://" + host;
                int jrmpExportedPort = 0;
                String propertyName = "carol.jrmp.server.port";
                Properties p = ConfigurationRepository.getProperties();
                if (p != null) {
                    jrmpExportedPort = PortNumber.strToint((String)p.getProperty(propertyName, "0"), (String)propertyName);
                }
                if (jrmpExportedPort > 0) {
                    serviceURL = serviceURL + ":" + jrmpExportedPort;
                }
                serviceURL = serviceURL + "/jndi/rmi://" + host + ":" + port + "/" + myName;
            } else if (scheme.equals("rmi") && carolProtocol.equals("irmi")) {
                String myName = "irmiconnector_" + cdName;
                serviceURL = "service:jmx:rmi://" + host;
                int irmiExportedPort = 0;
                String propertyName = "carol.irmi.server.port";
                Properties p = ConfigurationRepository.getProperties();
                if (p != null) {
                    irmiExportedPort = PortNumber.strToint((String)p.getProperty(propertyName, "0"), (String)propertyName);
                    ++irmiExportedPort;
                }
                if (irmiExportedPort > 1) {
                    serviceURL = serviceURL + ":" + irmiExportedPort;
                }
                serviceURL = serviceURL + "/jndi/rmi://" + host + ":" + port + "/" + myName;
            } else if (scheme.equals("cmi")) {
                String myName = "cmiconnector_" + cdName;
                serviceURL = "service:jmx:rmi://" + host;
                int jrmpExportedPort = 0;
                String propertyName = "carol.jrmp.server.port";
                Properties p = ConfigurationRepository.getProperties();
                if (p != null) {
                    jrmpExportedPort = PortNumber.strToint((String)p.getProperty(propertyName, "0"), (String)propertyName);
                }
                if (jrmpExportedPort > 0) {
                    serviceURL = serviceURL + ":" + jrmpExportedPort;
                }
                serviceURL = serviceURL + "/jndi/cmi://" + host + ":" + port + "/" + myName;
            } else if (scheme.equals("iiop")) {
                String myName = "iiopconnector_" + cdName;
                serviceURL = "service:jmx:iiop://" + host + "/jndi/iiop://" + host + ":" + port + "/" + myName;
            }
        }
        catch (Exception e) {
            throw new ClusterDaemonException("Cannot get JMX URL", e);
        }
        return serviceURL;
    }

    public static String getObjectName() throws ClusterDaemonException {
        String objName = null;
        try {
            ProtocolConfiguration protocolConfiguration = ConfigurationRepository.getCurrentConfiguration();
            ConfigurationRepository.setCurrentConfiguration((ProtocolConfiguration)protocolConfiguration);
            String carolProtocol = protocolConfiguration.getName();
            String providerUrl = protocolConfiguration.getProviderURL();
            URI carolURL = new URI(providerUrl);
            String scheme = carolURL.getScheme();
            if (scheme.equals("rmi") && carolProtocol.equals("jrmp")) {
                objName = "connectors:protocol=jrmp, name=cs_connector";
            } else if (scheme.equals("rmi") && carolProtocol.equals("irmi")) {
                objName = "connectors:protocol=irmi, name=cs_connector";
            } else if (scheme.equals("jrmi")) {
                objName = "connectors:protocol=jrmi, name=cs_connector";
            } else if (scheme.equals("cmi")) {
                objName = "connectors:protocol=cmi, name=cs_connector";
            } else if (scheme.equals("iiop")) {
                objName = "connectors:protocol=iiop, name=cs_connector";
            }
        }
        catch (Exception e) {
            throw new ClusterDaemonException("Cannot get ObjectName", e);
        }
        return objName;
    }

    public static void loadClusterDaemonConfiguration(String confFileName) throws ClusterDaemonException {
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        currentConfiguration = null;
        try {
            currentConfiguration = ClusterDaemonConfigurationManager.getClusterDaemonConfiguration((String)confFileName, (ClassLoader)currentLoader);
            currentConfigurationFileName = ClusterDaemonConfigurationManager.getClusterDaemonFileName((String)confFileName);
        }
        catch (ClusterDaemonConfigurationException e) {
            throw new ClusterDaemonException(e);
        }
    }

    public static ClusterDaemonConfiguration getCurrentConfiguration() {
        return currentConfiguration;
    }

    public static String getCurrentConfigurationFileName() {
        return currentConfigurationFileName;
    }
}

