/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.reference;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import net.jcip.annotations.Immutable;
import org.ow2.cmi.lb.LoadBalanceable;
import org.ow2.cmi.reference.util.ProviderURLParser;

@Immutable
public class ServerRef
implements LoadBalanceable,
Serializable {
    private static final long serialVersionUID = -1397334469981842637L;
    private final InetAddress inetAddress;
    private final int port;
    private final String hostname;
    private final String scheme;
    private final String protocol;

    public ServerRef(String protocol, String providerURL) throws MalformedURLException, UnknownHostException {
        this.protocol = protocol;
        ProviderURLParser providerURLParser = new ProviderURLParser(protocol, providerURL);
        providerURLParser.parse();
        this.inetAddress = InetAddress.getByName(providerURLParser.getHostName());
        this.port = providerURLParser.getPort();
        this.scheme = providerURLParser.getScheme();
        this.hostname = providerURLParser.getHostName();
    }

    public ServerRef(String providerURL) throws MalformedURLException, UnknownHostException {
        this.protocol = null;
        ProviderURLParser providerURLParser = new ProviderURLParser(providerURL);
        providerURLParser.parse();
        this.inetAddress = InetAddress.getByName(providerURLParser.getHostName());
        this.port = providerURLParser.getPort();
        this.scheme = providerURLParser.getScheme();
        this.hostname = providerURLParser.getHostName();
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getScheme() {
        return this.scheme;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return this.getProviderURL();
    }

    public String getProtocol() {
        return this.protocol;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ServerRef)) {
            return false;
        }
        ServerRef serverRef = (ServerRef)obj;
        return this.inetAddress.equals(serverRef.inetAddress) && this.port == serverRef.port;
    }

    public int hashCode() {
        return this.inetAddress.hashCode() + this.port;
    }

    public String getProviderURL() {
        return this.scheme + "://" + this.hostname + ":" + this.port;
    }

    public ServerRef getServerRef() {
        return this;
    }
}

