/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Valve;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHostValve;
import org.apache.catalina.core.StandardPipeline;
import org.apache.catalina.loader.WebappClassLoader;
import org.apache.catalina.startup.HostConfig;
import org.apache.catalina.valves.ValveBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.modeler.Registry;

public class StandardHost
extends ContainerBase
implements Host {
    private static Log log = LogFactory.getLog(StandardHost.class);
    private String[] aliases = new String[0];
    private final Object aliasesLock = new Object();
    private String appBase = "webapps";
    private boolean autoDeploy = true;
    private String configClass = "org.apache.catalina.startup.ContextConfig";
    private String contextClass = "org.apache.catalina.core.StandardContext";
    private boolean deployOnStartup = true;
    private boolean deployXML = true;
    private String errorReportValveClass = "org.apache.catalina.valves.ErrorReportValve";
    private ObjectName errorReportValveObjectName = null;
    private static final String info = "org.apache.catalina.core.StandardHost/1.0";
    private boolean liveDeploy = true;
    private boolean unpackWARs = true;
    private String workDir = null;
    private boolean xmlValidation = false;
    private boolean xmlNamespaceAware = false;
    private Map<ClassLoader, String> childClassLoaders = new WeakHashMap<ClassLoader, String>();
    private boolean initialized = false;

    public StandardHost() {
        this.pipeline.setBasic(new StandardHostValve());
    }

    public String getAppBase() {
        return this.appBase;
    }

    public void setAppBase(String appBase) {
        String oldAppBase = this.appBase;
        this.appBase = appBase;
        this.support.firePropertyChange("appBase", oldAppBase, this.appBase);
    }

    public boolean getAutoDeploy() {
        return this.autoDeploy;
    }

    public void setAutoDeploy(boolean autoDeploy) {
        boolean oldAutoDeploy = this.autoDeploy;
        this.autoDeploy = autoDeploy;
        this.support.firePropertyChange("autoDeploy", oldAutoDeploy, this.autoDeploy);
    }

    public String getConfigClass() {
        return this.configClass;
    }

    public void setConfigClass(String configClass) {
        String oldConfigClass = this.configClass;
        this.configClass = configClass;
        this.support.firePropertyChange("configClass", oldConfigClass, this.configClass);
    }

    public String getContextClass() {
        return this.contextClass;
    }

    public void setContextClass(String contextClass) {
        String oldContextClass = this.contextClass;
        this.contextClass = contextClass;
        this.support.firePropertyChange("contextClass", oldContextClass, this.contextClass);
    }

    public boolean getDeployOnStartup() {
        return this.deployOnStartup;
    }

    public void setDeployOnStartup(boolean deployOnStartup) {
        boolean oldDeployOnStartup = this.deployOnStartup;
        this.deployOnStartup = deployOnStartup;
        this.support.firePropertyChange("deployOnStartup", oldDeployOnStartup, this.deployOnStartup);
    }

    public boolean isDeployXML() {
        return this.deployXML;
    }

    public void setDeployXML(boolean deployXML) {
        this.deployXML = deployXML;
    }

    public boolean getLiveDeploy() {
        return this.autoDeploy;
    }

    public void setLiveDeploy(boolean liveDeploy) {
        this.setAutoDeploy(liveDeploy);
    }

    public String getErrorReportValveClass() {
        return this.errorReportValveClass;
    }

    public void setErrorReportValveClass(String errorReportValveClass) {
        String oldErrorReportValveClassClass = this.errorReportValveClass;
        this.errorReportValveClass = errorReportValveClass;
        this.support.firePropertyChange("errorReportValveClass", oldErrorReportValveClassClass, this.errorReportValveClass);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.nullName"));
        }
        name = name.toLowerCase();
        String oldName = this.name;
        this.name = name;
        this.support.firePropertyChange("name", oldName, this.name);
    }

    public boolean isUnpackWARs() {
        return this.unpackWARs;
    }

    public void setUnpackWARs(boolean unpackWARs) {
        this.unpackWARs = unpackWARs;
    }

    public void setXmlValidation(boolean xmlValidation) {
        this.xmlValidation = xmlValidation;
    }

    public boolean getXmlValidation() {
        return this.xmlValidation;
    }

    public boolean getXmlNamespaceAware() {
        return this.xmlNamespaceAware;
    }

    public void setXmlNamespaceAware(boolean xmlNamespaceAware) {
        this.xmlNamespaceAware = xmlNamespaceAware;
    }

    public String getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(String workDir) {
        this.workDir = workDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAlias(String alias) {
        alias = alias.toLowerCase();
        Object object = this.aliasesLock;
        synchronized (object) {
            for (int i = 0; i < this.aliases.length; ++i) {
                if (!this.aliases[i].equals(alias)) continue;
                return;
            }
            String[] newAliases = new String[this.aliases.length + 1];
            for (int i = 0; i < this.aliases.length; ++i) {
                newAliases[i] = this.aliases[i];
            }
            newAliases[this.aliases.length] = alias;
            this.aliases = newAliases;
        }
        this.fireContainerEvent("addAlias", alias);
    }

    public void addChild(Container child) {
        if (child instanceof Lifecycle) {
            ((Lifecycle)((Object)child)).addLifecycleListener(new MemoryLeakTrackingListener());
        }
        if (!(child instanceof Context)) {
            throw new IllegalArgumentException(sm.getString("standardHost.notContext"));
        }
        super.addChild(child);
    }

    public String[] findReloadedContextMemoryLeaks() {
        System.gc();
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<ClassLoader, String> entry : this.childClassLoaders.entrySet()) {
            ClassLoader cl = entry.getKey();
            if (!(cl instanceof WebappClassLoader) || ((WebappClassLoader)cl).isStarted()) continue;
            result.add(entry.getValue());
        }
        return result.toArray(new String[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findAliases() {
        Object object = this.aliasesLock;
        synchronized (object) {
            return this.aliases;
        }
    }

    public String getInfo() {
        return info;
    }

    public Context map(String uri) {
        int slash;
        if (log.isDebugEnabled()) {
            log.debug("Mapping request URI '" + uri + "'");
        }
        if (uri == null) {
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace("  Trying the longest context path prefix");
        }
        Context context = null;
        String mapuri = uri;
        while ((context = (Context)this.findChild(mapuri)) == null && (slash = mapuri.lastIndexOf(47)) >= 0) {
            mapuri = mapuri.substring(0, slash);
        }
        if (context == null) {
            if (log.isTraceEnabled()) {
                log.trace("  Trying the default context");
            }
            context = (Context)this.findChild("");
        }
        if (context == null) {
            log.error(sm.getString("standardHost.mappingError", uri));
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug(" Mapped to context '" + context.getPath() + "'");
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAlias(String alias) {
        alias = alias.toLowerCase();
        Object object = this.aliasesLock;
        synchronized (object) {
            int n = -1;
            for (int i = 0; i < this.aliases.length; ++i) {
                if (!this.aliases[i].equals(alias)) continue;
                n = i;
                break;
            }
            if (n < 0) {
                return;
            }
            int j = 0;
            String[] results = new String[this.aliases.length - 1];
            for (int i = 0; i < this.aliases.length; ++i) {
                if (i == n) continue;
                results[j++] = this.aliases[i];
            }
            this.aliases = results;
        }
        this.fireContainerEvent("removeAlias", alias);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.getParent() != null) {
            sb.append(this.getParent().toString());
            sb.append(".");
        }
        sb.append("StandardHost[");
        sb.append(this.getName());
        sb.append("]");
        return sb.toString();
    }

    public synchronized void start() throws LifecycleException {
        if (this.started) {
            return;
        }
        if (!this.initialized) {
            this.init();
        }
        if (this.realm == null) {
            ObjectName realmName = null;
            try {
                realmName = new ObjectName(this.domain + ":type=Realm,host=" + this.getName());
                if (this.mserver.isRegistered(realmName)) {
                    this.mserver.invoke(realmName, "init", new Object[0], new String[0]);
                }
            }
            catch (Throwable t) {
                log.debug("No realm for this host " + realmName);
            }
        }
        if (this.errorReportValveClass != null && !this.errorReportValveClass.equals("")) {
            try {
                boolean found = false;
                if (this.errorReportValveObjectName != null) {
                    ObjectName[] names = ((StandardPipeline)this.pipeline).getValveObjectNames();
                    for (int i = 0; !found && i < names.length; ++i) {
                        if (!this.errorReportValveObjectName.equals(names[i])) continue;
                        found = true;
                    }
                }
                if (!found) {
                    Valve valve = (Valve)Class.forName(this.errorReportValveClass).newInstance();
                    this.addValve(valve);
                    this.errorReportValveObjectName = ((ValveBase)valve).getObjectName();
                }
            }
            catch (Throwable t) {
                log.error(sm.getString("standardHost.invalidErrorReportValveClass", this.errorReportValveClass), t);
            }
        }
        if (log.isDebugEnabled()) {
            if (this.xmlValidation) {
                log.debug(sm.getString("standardHost.validationEnabled"));
            } else {
                log.debug(sm.getString("standardHost.validationDisabled"));
            }
        }
        super.start();
    }

    public String[] getValveNames() throws Exception {
        Valve[] valves = this.getValves();
        String[] mbeanNames = new String[valves.length];
        for (int i = 0; i < valves.length; ++i) {
            if (valves[i] == null || ((ValveBase)valves[i]).getObjectName() == null) continue;
            mbeanNames[i] = ((ValveBase)valves[i]).getObjectName().toString();
        }
        return mbeanNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAliases() {
        Object object = this.aliasesLock;
        synchronized (object) {
            return this.aliases;
        }
    }

    public void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.getParent() == null) {
            try {
                ObjectName serviceName = new ObjectName(this.domain + ":type=Engine");
                HostConfig deployer = new HostConfig();
                this.addLifecycleListener(deployer);
                if (this.mserver.isRegistered(serviceName)) {
                    if (log.isDebugEnabled()) {
                        log.debug("Registering " + serviceName + " with the Engine");
                    }
                    this.mserver.invoke(serviceName, "addChild", new Object[]{this}, new String[]{"org.apache.catalina.Container"});
                }
            }
            catch (Exception ex) {
                log.error("Host registering failed!", ex);
            }
        }
        if (this.oname == null) {
            try {
                StandardEngine engine = (StandardEngine)this.parent;
                this.domain = engine.getName();
                if (log.isDebugEnabled()) {
                    log.debug("Register host " + this.getName() + " with domain " + this.domain);
                }
                this.controller = this.oname = new ObjectName(this.domain + ":type=Host,host=" + this.getName());
                Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, null);
            }
            catch (Throwable t) {
                log.error("Host registering failed!", t);
            }
        }
    }

    public void destroy() throws Exception {
        Container[] children = this.findChildren();
        super.destroy();
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof StandardContext)) continue;
            ((StandardContext)children[i]).destroy();
        }
    }

    public ObjectName preRegister(MBeanServer server, ObjectName oname) throws Exception {
        ObjectName res = super.preRegister(server, oname);
        String name = oname.getKeyProperty("host");
        if (name != null) {
            this.setName(name);
        }
        return res;
    }

    public ObjectName createObjectName(String domain, ObjectName parent) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Create ObjectName " + domain + " " + parent);
        }
        return new ObjectName(domain + ":type=Host,host=" + this.getName());
    }

    private class MemoryLeakTrackingListener
    implements LifecycleListener {
        private MemoryLeakTrackingListener() {
        }

        public void lifecycleEvent(LifecycleEvent event) {
            if (event.getType().equals("after_start") && event.getSource() instanceof Context) {
                Context context = (Context)event.getSource();
                StandardHost.this.childClassLoaders.put(context.getLoader().getClassLoader(), context.getServletContext().getContextPath());
            }
        }
    }
}

