/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.catalina.Context;
import org.apache.catalina.Realm;
import org.apache.catalina.connector.Request;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.MemoryRealm;
import org.apache.catalina.realm.MemoryRuleSet;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.digester.Digester;

public class JAASMemoryLoginModule
extends MemoryRealm
implements LoginModule,
Realm {
    private static Log log = LogFactory.getLog(JAASMemoryLoginModule.class);
    protected CallbackHandler callbackHandler = null;
    protected boolean committed = false;
    protected Map options = null;
    protected String pathname = "conf/tomcat-users.xml";
    protected Principal principal = null;
    protected HashMap principals = new HashMap();
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.authenticator");
    protected Map sharedState = null;
    protected Subject subject = null;

    public JAASMemoryLoginModule() {
        log.debug("MEMORY LOGIN MODULE");
    }

    public boolean abort() throws LoginException {
        if (this.principal == null) {
            return false;
        }
        if (this.committed) {
            this.logout();
        } else {
            this.committed = false;
            this.principal = null;
        }
        log.debug("Abort");
        return true;
    }

    public boolean commit() throws LoginException {
        log.debug("commit " + this.principal);
        if (this.principal == null) {
            return false;
        }
        if (!this.subject.getPrincipals().contains(this.principal)) {
            this.subject.getPrincipals().add(this.principal);
            if (this.principal instanceof GenericPrincipal) {
                String[] roles = ((GenericPrincipal)this.principal).getRoles();
                for (int i = 0; i < roles.length; ++i) {
                    this.subject.getPrincipals().add(new GenericPrincipal(null, roles[i], null));
                }
            }
        }
        this.committed = true;
        return true;
    }

    public SecurityConstraint[] findSecurityConstraints(Request request, Context context) {
        ArrayList<SecurityConstraint> results = null;
        SecurityConstraint[] constraints = context.findConstraints();
        if (constraints == null || constraints.length == 0) {
            if (context.getLogger().isDebugEnabled()) {
                context.getLogger().debug("  No applicable constraints defined");
            }
            return null;
        }
        String uri = request.getDecodedRequestURI();
        String contextPath = request.getContextPath();
        if (contextPath.length() > 0) {
            uri = uri.substring(contextPath.length());
        }
        uri = RequestUtil.URLDecode(uri);
        String method = request.getMethod();
        for (int i = 0; i < constraints.length; ++i) {
            if (context.getLogger().isDebugEnabled()) {
                context.getLogger().debug("  Checking constraint '" + constraints[i] + "' against " + method + " " + uri + " --> " + constraints[i].included(uri, method));
            }
            if (!constraints[i].included(uri, method)) continue;
            if (results == null) {
                results = new ArrayList<SecurityConstraint>();
            }
            results.add(constraints[i]);
        }
        if (context.getLogger().isDebugEnabled()) {
            context.getLogger().debug("  No applicable constraint located");
        }
        if (results == null) {
            return null;
        }
        SecurityConstraint[] array = new SecurityConstraint[results.size()];
        System.arraycopy(results.toArray(), 0, array, 0, array.length);
        return array;
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        log.debug("Init");
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        if (options.get("pathname") != null) {
            this.pathname = (String)options.get("pathname");
        }
        this.load();
    }

    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("No CallbackHandler specified");
        }
        Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false), new TextInputCallback("nonce"), new TextInputCallback("nc"), new TextInputCallback("cnonce"), new TextInputCallback("qop"), new TextInputCallback("realmName"), new TextInputCallback("md5a2"), new TextInputCallback("authMethod")};
        String username = null;
        String password = null;
        String nonce = null;
        String nc = null;
        String cnonce = null;
        String qop = null;
        String realmName = null;
        String md5a2 = null;
        String authMethod = null;
        try {
            this.callbackHandler.handle(callbacks);
            username = ((NameCallback)callbacks[0]).getName();
            password = new String(((PasswordCallback)callbacks[1]).getPassword());
            nonce = ((TextInputCallback)callbacks[2]).getText();
            nc = ((TextInputCallback)callbacks[3]).getText();
            cnonce = ((TextInputCallback)callbacks[4]).getText();
            qop = ((TextInputCallback)callbacks[5]).getText();
            realmName = ((TextInputCallback)callbacks[6]).getText();
            md5a2 = ((TextInputCallback)callbacks[7]).getText();
            authMethod = ((TextInputCallback)callbacks[8]).getText();
        }
        catch (IOException e) {
            throw new LoginException(e.toString());
        }
        catch (UnsupportedCallbackException e) {
            throw new LoginException(e.toString());
        }
        if (authMethod == null) {
            this.principal = super.authenticate(username, password);
        } else if (authMethod.equals("DIGEST")) {
            this.principal = super.authenticate(username, password, nonce, nc, cnonce, qop, realmName, md5a2);
        } else if (authMethod.equals("CLIENT_CERT")) {
            this.principal = super.getPrincipal(username);
        } else {
            throw new LoginException("Unknown authentication method");
        }
        log.debug("login " + username + " " + this.principal);
        if (this.principal != null) {
            return true;
        }
        throw new FailedLoginException("Username or password is incorrect");
    }

    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.principal);
        this.committed = false;
        this.principal = null;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load() {
        File file = new File(this.pathname);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), this.pathname);
        }
        if (!file.exists() || !file.canRead()) {
            log.warn("Cannot load configuration file " + file.getAbsolutePath());
            return;
        }
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.addRuleSet(new MemoryRuleSet());
        try {
            try {
                digester.push(this);
                digester.parse(file);
            }
            catch (Exception e) {
                log.warn("Error processing configuration file " + file.getAbsolutePath(), e);
                Object var5_4 = null;
                digester.reset();
                return;
            }
            Object var5_3 = null;
            digester.reset();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            digester.reset();
            throw throwable;
        }
    }
}

